/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.importation.engines;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.importation.TiesImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.Label;

final class TiesImportEngine {
    private final JunctionEditor junctionEditor;
    private final FichothequeEditor fichothequeEditor;
    private final SubsetItem mainSubsetItem;
    private final BdfServer bdfServer;
    private final Predicate<Subset> subsetAccessPredicate;

    private TiesImportEngine(BdfServer bdfServer, JunctionEditor junctionEditor, SubsetItem mainSubsetItem, PermissionSummary permissionSummary) {
        this.junctionEditor = junctionEditor;
        this.fichothequeEditor = junctionEditor.getFichothequeEditor();
        this.mainSubsetItem = mainSubsetItem;
        this.bdfServer = bdfServer;
        this.subsetAccessPredicate = permissionSummary.getSubsetAccessPredicate();
    }

    static void run(BdfServer bdfServer, JunctionEditor junctionEditor, SubsetItem mainSubsetItem, TiesImport tiesImport, PermissionSummary permissionSummary) {
        TiesImportEngine tiesImportEngine = new TiesImportEngine(bdfServer, junctionEditor, mainSubsetItem, permissionSummary);
        tiesImportEngine.runReplace(tiesImport);
        tiesImportEngine.runAppend(tiesImport);
    }

    private void runReplace(TiesImport tiesImport) {
        List<IncludeKey> removedIncludeKeyList = tiesImport.getRemovedIncludeKeyList();
        List<TiesImport.TieImport> replaceList = tiesImport.getReplaceTieImportList();
        if (removedIncludeKeyList.isEmpty() && replaceList.isEmpty()) {
            return;
        }
        LinkedHashSet<IncludeKey> clearExisting = new LinkedHashSet<IncludeKey>();
        clearExisting.addAll(removedIncludeKeyList);
        for (TiesImport.TieImport tieImport : replaceList) {
            if (!this.subsetAccessPredicate.test(tieImport.getOtherSubset())) continue;
            clearExisting.add(tieImport.getIncludeKey());
        }
        JunctionChangeEngine replaceEngine = JunctionChangeEngine.clearExistingEngine(this.mainSubsetItem, clearExisting);
        for (TiesImport.TieImport tieImport : replaceList) {
            if (!this.subsetAccessPredicate.test(tieImport.getOtherSubset())) continue;
            this.addTie(replaceEngine, tieImport);
        }
        this.junctionEditor.updateJunctions(this.mainSubsetItem, replaceEngine.toJunctionChanges());
    }

    private void runAppend(TiesImport tiesImport) {
        List<TiesImport.TieImport> appendList = tiesImport.getAppendTieImportList();
        if (appendList.isEmpty()) {
            return;
        }
        JunctionChangeEngine appendEngine = JunctionChangeEngine.appendEngine(this.mainSubsetItem);
        for (TiesImport.TieImport tieImport : appendList) {
            if (!this.subsetAccessPredicate.test(tieImport.getOtherSubset())) continue;
            this.addTie(appendEngine, tieImport);
        }
        this.junctionEditor.updateJunctions(this.mainSubsetItem, appendEngine.toJunctionChanges());
    }

    private void addTie(JunctionChangeEngine engine, TiesImport.TieImport tieImport) {
        TiesImport.Other other = tieImport.getOther();
        if (other instanceof TiesImport.IdOther) {
            this.addIdOther(engine, tieImport, (TiesImport.IdOther)other);
        } else if (other instanceof TiesImport.IdalphaOther) {
            this.addIdalphaOther(engine, tieImport, (TiesImport.IdalphaOther)other);
        } else if (other instanceof TiesImport.LabelOther) {
            this.addLabelOther(engine, tieImport, (TiesImport.LabelOther)other);
        }
    }

    private void addIdOther(JunctionChangeEngine engine, TiesImport.TieImport tieImport, TiesImport.IdOther idOther) {
        Subset otherSubset = tieImport.getOtherSubset();
        if (otherSubset instanceof Thesaurus) {
            this.addIdOther(engine, tieImport, (Thesaurus)otherSubset, idOther);
        } else {
            SubsetItem otherSubsetItem = otherSubset.getSubsetItemById(idOther.getOtherId());
            if (otherSubsetItem != null) {
                engine.addTie(otherSubsetItem, tieImport.getMode(), tieImport.getWeight());
            }
        }
    }

    private void addIdOther(JunctionChangeEngine engine, TiesImport.TieImport tieImport, Thesaurus thesaurus, TiesImport.IdOther idOther) {
        ExternalSource externalSource;
        int otherId = idOther.getOtherId();
        Motcle motcle = thesaurus.getMotcleById(otherId);
        if (motcle == null && (externalSource = ExternalSourceUtils.getExternalSource(this.bdfServer, thesaurus)) != null) {
            motcle = externalSource.getMotcle(this.fichothequeEditor, thesaurus, otherId);
        }
        if (motcle != null) {
            engine.addTie(motcle, tieImport.getMode(), tieImport.getWeight());
        }
    }

    private void addIdalphaOther(JunctionChangeEngine engine, TiesImport.TieImport tieImport, TiesImport.IdalphaOther idalphaOther) {
        ExternalSource externalSource;
        Subset otherSubset = tieImport.getOtherSubset();
        if (!(otherSubset instanceof Thesaurus)) {
            return;
        }
        Thesaurus thesaurus = (Thesaurus)otherSubset;
        String idalpha = idalphaOther.getIdalpha();
        Motcle motcle = thesaurus.getMotcleByIdalpha(idalpha);
        if (motcle == null && (externalSource = ExternalSourceUtils.getExternalSource(this.bdfServer, thesaurus)) != null) {
            motcle = externalSource.getMotcle(this.fichothequeEditor, thesaurus, idalpha);
        }
        if (motcle != null) {
            engine.addTie(motcle, tieImport.getMode(), tieImport.getWeight());
        }
    }

    private void addLabelOther(JunctionChangeEngine engine, TiesImport.TieImport tieImport, TiesImport.LabelOther labelOther) {
        Subset otherSubset = tieImport.getOtherSubset();
        if (!(otherSubset instanceof Thesaurus)) {
            return;
        }
        Thesaurus thesaurus = (Thesaurus)otherSubset;
        Label label = labelOther.getLabel();
        Motcle motcle = thesaurus.seekMotcleByLabel(label.getLabelString(), label.getLang());
        if (motcle == null) {
            if (thesaurus.isIdalphaType()) {
                return;
            }
            DynamicEditPolicy dynamicEditPolicy = this.getDynamicEditPolicy(thesaurus);
            switch (dynamicEditPolicy.getType()) {
                case "allow": {
                    ThesaurusEditor thsedit = this.junctionEditor.getFichothequeEditor().getThesaurusEditor(thesaurus);
                    try {
                        motcle = thsedit.createMotcle(-1, null);
                        thsedit.putLabel(motcle, label);
                        break;
                    }
                    catch (ParseException | ExistingIdException e) {
                        throw new ShouldNotOccurException(e);
                    }
                }
                case "external": {
                    ExternalSource externalSource = ExternalSourceUtils.getExternalSource(this.bdfServer, thesaurus);
                    if (externalSource == null) break;
                    motcle = externalSource.getMotcle(this.fichothequeEditor, thesaurus, label.getLabelString(), label.getLang());
                }
            }
        }
        if (motcle != null) {
            engine.addTie(motcle, tieImport.getMode(), tieImport.getWeight());
        }
    }

    private DynamicEditPolicy getDynamicEditPolicy(Thesaurus thesaurus) {
        return this.bdfServer.getPolicyManager().getPolicyProvider().getDynamicEditPolicy(thesaurus);
    }
}

