/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders.field;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.field.TextFieldEntry;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.syntax.FicheblockSyntaxHandler;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class TextFieldEntryBuilder {
    private static final Map<String, Integer> EMPTY_MAP = Collections.emptyMap();
    private final CorpusField corpusField;
    private String label = "";
    private boolean mandatory = false;
    private String formattedText = "";
    private int rows;
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;
    private Map<String, Integer> matchingMap = EMPTY_MAP;

    public TextFieldEntryBuilder(CorpusField corpusField) {
        this.corpusField = corpusField;
    }

    public TextFieldEntryBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public TextFieldEntryBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public TextFieldEntryBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public TextFieldEntryBuilder setFormattedText(String formattedText) {
        if (formattedText == null) {
            throw new IllegalArgumentException("formattedText is null");
        }
        this.formattedText = formattedText;
        return this;
    }

    public TextFieldEntryBuilder setRows(int rows) {
        this.rows = rows;
        return this;
    }

    public TextFieldEntryBuilder setMatchingMap(Map<String, Integer> matchingMap) {
        this.matchingMap = matchingMap == null ? EMPTY_MAP : matchingMap;
        return this;
    }

    public TextFieldEntry toTextFieldEntry() {
        return new InternalTextFieldEntry(this.corpusField, this.label, this.mandatory, this.attributes, this.formattedText, this.rows, this.matchingMap);
    }

    public static TextFieldEntryBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, CorpusField corpusField, FieldUi fieldUi, @Nullable String defaultValue) {
        String value;
        if (!corpusField.isSection()) {
            throw new IllegalArgumentException("!corpusField.isSection()");
        }
        Map<String, Integer> matchingMap = EMPTY_MAP;
        if (fichePointeur.isEmpty()) {
            value = defaultValue != null ? defaultValue : FicheFormUtils.getDefVal(fichePointeur, ficheFormParameters, fieldUi);
        } else {
            FicheBlocks ficheBlocks = (FicheBlocks)fichePointeur.getValue(corpusField);
            if (ficheBlocks == null) {
                value = "";
            } else {
                StringBuilder buf = new StringBuilder();
                FicheblockSyntaxHandler handler = new FicheblockSyntaxHandler(buf);
                try {
                    FicheblockSyntax.appendFicheBlocks(handler, ficheBlocks, ficheFormParameters.getFicheBlockFormSyntaxParameters());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                matchingMap = handler.getMatchingMap();
                value = buf.toString();
            }
        }
        if (value.isEmpty() && fieldUi.isObsolete()) {
            return null;
        }
        return TextFieldEntryBuilder.init(corpusField).setFormattedText(value).setMandatory(fieldUi.isMandatory()).setAttributes(fieldUi.getAttributes()).setRows(FicheFormUtils.getRows(fieldUi)).setLabel(L10nUtils.toLabelString(ficheFormParameters, corpusField)).setMatchingMap(matchingMap);
    }

    public static TextFieldEntryBuilder init(CorpusField corpusField) {
        return new TextFieldEntryBuilder(corpusField);
    }

    private static class InternalTextFieldEntry
    implements TextFieldEntry {
        private final CorpusField corpusField;
        private final String label;
        private final boolean mandatory;
        private final Attributes attributes;
        private final String formattedText;
        private final int rows;
        private final Map<String, Integer> matchingMap;

        public InternalTextFieldEntry(CorpusField corpusField, String label, boolean mandatory, Attributes attributes, String formattedText, int rows, Map<String, Integer> matchingMap) {
            this.corpusField = corpusField;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.formattedText = formattedText;
            this.rows = rows;
            this.matchingMap = matchingMap;
        }

        @Override
        public CorpusField getCorpusField() {
            return this.corpusField;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public String getFormattedText() {
            return this.formattedText;
        }

        @Override
        public int getRows() {
            return this.rows;
        }

        @Override
        public Map<String, Integer> getMatchingMap() {
            return this.matchingMap;
        }
    }
}

