/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.tools.balayage.BdfBalayageUtils;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.EngineUtils;
import fr.exemole.bdfserver.tools.balayage.engine.runners.AbstractOutputRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Predicate;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.text.ValueResolver;

public class DocumentOutputRunner
extends AbstractOutputRunner {
    private Predicate<String> extensionPredicate;

    public DocumentOutputRunner(BalayageParameters balayageParameters, int outputIndex, BalayageOutput output, int balayageUnitIndex) {
        super(balayageParameters, outputIndex, output, balayageUnitIndex);
        this.extensionPredicate = BdfBalayageUtils.getExtensionPredicate(output.getBalayageUnit());
    }

    public void copy(ValueResolver valueResolver, Document document) {
        File directory = this.rootDirectory;
        String path = EngineUtils.getPath(this.output, valueResolver);
        if (path != null) {
            directory = new File(directory, path);
        }
        this.prepareDirectory(directory);
        for (Version version : document.getVersionList()) {
            if (!this.extensionPredicate.test(version.getExtension())) continue;
            File destination = new File(directory, version.getFileName());
            try {
                InputStream is = version.getInputStream();
                try (FileOutputStream os = new FileOutputStream(destination);){
                    IOUtils.copy(is, (OutputStream)os);
                    this.balayageLog.addFileGeneration(this.balayageUnitIndex, this.outputIndex, destination);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                String message = ioe.getClass().getName();
                if (msg != null) {
                    message = message + " : " + msg;
                }
                this.balayageLog.addOutputError(this.balayageUnitIndex, this.outputIndex, this.output, "ioException", destination.getName(), message);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.extensionPredicate = null;
    }
}

