/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import java.io.File;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.fichotheque.tools.parsers.FicheParseEngine;
import net.fichotheque.tools.parsers.FicheParser;
import net.fichotheque.tools.parsers.JunctionParseEngine;
import net.fichotheque.tools.parsers.ParseContext;
import net.fichotheque.tools.parsers.junction.DocumentTokenParser;
import net.fichotheque.tools.parsers.junction.IllustrationTokenParser;
import net.fichotheque.tools.parsers.junction.TokenKey;
import net.fichotheque.tools.parsers.junction.TokenKeys;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;

public final class EditionEngine {
    private final BdfParameters bdfParameters;
    private final BdfServer bdfServer;
    private final PermissionSummary permissionSummary;
    private final FichothequeEditor fichothequeEditor;
    private final RequestMap globalRequestMap;
    private final short ficheParseType;
    private final FicheParser ficheParser;
    private final Lang workingLang;
    private final ParseContext parseContext;

    private EditionEngine(EditSession editSession, BdfParameters bdfParameters, RequestMap requestMap, short ficheParseType) {
        this.bdfParameters = bdfParameters;
        this.bdfServer = bdfParameters.getBdfServer();
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.fichothequeEditor = editSession.getFichothequeEditor();
        this.globalRequestMap = requestMap;
        this.ficheParseType = ficheParseType;
        BdfUser bdfUser = bdfParameters.getBdfUser();
        this.workingLang = bdfUser.getWorkingLang();
        this.ficheParser = new FicheParser(BdfServerUtils.getFicheParserParameters(this.bdfServer, bdfUser));
        this.parseContext = new ParseContext(this.fichothequeEditor, this.bdfServer.getFichothequeQuestioner(), this.bdfServer.getPolicyManager().getPolicyProvider(), this.bdfServer.getThesaurusLangChecker(), this.bdfServer.getExternalSourceProvider(), this.permissionSummary.getSubsetAccessPredicate());
    }

    private void run(FicheMeta mainFicheMeta) {
        String prefixType = this.globalRequestMap.getParameter("prefixtype");
        if (prefixType == null) {
            this.runDefault(mainFicheMeta);
        } else {
            switch (prefixType) {
                case "satellites": {
                    this.runWithSatellites(mainFicheMeta);
                    break;
                }
                default: {
                    this.runDefault(mainFicheMeta);
                }
            }
        }
    }

    private void runDefault(FicheMeta ficheMeta) {
        this.newParser(ficheMeta, null).run().saveFiche();
    }

    private void runWithSatellites(FicheMeta mainFicheMeta) {
        SubsetKey mainCorpusKey = mainFicheMeta.getSubsetKey();
        Parser mainParser = this.newParser(mainFicheMeta, mainCorpusKey.getSubsetName()).run().saveFiche();
        Fiche mainFiche = mainParser.getFiche();
        String[] satellitePrefixArray = this.globalRequestMap.getParameterValues("prefixlist");
        if (satellitePrefixArray != null) {
            int id = mainFicheMeta.getId();
            for (String prefix : satellitePrefixArray) {
                Corpus satelliteCorpus = this.getSatelliteCorpus(mainCorpusKey, prefix);
                if (satelliteCorpus == null) continue;
                FicheMeta satelliteFicheMeta = satelliteCorpus.getFicheMetaById(id);
                if (satelliteFicheMeta != null) {
                    if (!this.permissionSummary.canWrite(satelliteFicheMeta)) continue;
                    this.parseSatellite(satelliteFicheMeta, prefix, mainFiche);
                    continue;
                }
                if (!this.permissionSummary.canCreate(satelliteCorpus)) continue;
                satelliteFicheMeta = this.createSatelliteFiche(this.fichothequeEditor.getCorpusEditor(satelliteCorpus.getSubsetKey()), id);
                this.parseSatellite(satelliteFicheMeta, prefix, mainFiche);
            }
        }
    }

    private void parseSatellite(FicheMeta satelliteFicheMeta, String prefix, Fiche mainFiche) {
        Parser parser = this.newParser(satelliteFicheMeta, prefix).run();
        Fiche satelliteFiche = parser.getFiche();
        if (satelliteFiche != null && mainFiche != null) {
            satelliteFiche.setOwners(mainFiche.getOwners());
        }
        parser.saveFiche();
    }

    private Corpus getSatelliteCorpus(SubsetKey mainCorpusKey, String prefix) {
        try {
            SubsetKey corpusKey = SubsetKey.parse((short)1, prefix);
            if (!this.permissionSummary.hasAccess(corpusKey)) {
                return null;
            }
            Corpus satelliteCorpus = (Corpus)this.bdfServer.getFichotheque().getSubset(corpusKey);
            if (satelliteCorpus == null) {
                return null;
            }
            Subset masterSubset = satelliteCorpus.getMasterSubset();
            if (masterSubset == null) {
                return null;
            }
            if (!masterSubset.getSubsetKey().equals(mainCorpusKey)) {
                return null;
            }
            return satelliteCorpus;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private Parser newParser(FicheMeta ficheMeta, @Nullable String paramSuffix) {
        RequestMap requestMap = paramSuffix != null ? RequestUtils.reduceToSuffix(this.globalRequestMap, paramSuffix + "_") : this.globalRequestMap;
        return new Parser(ficheMeta, requestMap);
    }

    private FicheMeta createSatelliteFiche(CorpusEditor satelliteEditor, int id) {
        FicheMeta ficheMeta;
        try {
            ficheMeta = satelliteEditor.createFiche(id);
        }
        catch (ExistingIdException eii) {
            throw new ImplementationException(eii);
        }
        catch (NoMasterIdException nmie) {
            throw new ShouldNotOccurException(nmie);
        }
        satelliteEditor.setDate(ficheMeta, FuzzyDate.current(), false);
        return ficheMeta;
    }

    public static final void replace(EditSession editSession, BdfParameters bdfParameters, RequestMap requestMap, FicheMeta ficheMeta) {
        EditionEngine editionEngine = new EditionEngine(editSession, bdfParameters, requestMap, 1);
        editionEngine.run(ficheMeta);
    }

    public static final void update(EditSession editSession, BdfParameters bdfParameters, RequestMap requestMap, FicheMeta ficheMeta) {
        EditionEngine editionEngine = new EditionEngine(editSession, bdfParameters, requestMap, 2);
        editionEngine.run(ficheMeta);
    }

    public static final void junctionOnly(EditSession editSession, BdfParameters bdfParameters, RequestMap requestMap, FicheMeta ficheMeta) {
        EditionEngine editionEngine = new EditionEngine(editSession, bdfParameters, requestMap, 0);
        editionEngine.run(ficheMeta);
    }

    private class Parser {
        private final FicheMeta ficheMeta;
        private final RequestMap requestMap;
        private Fiche fiche = null;

        private Parser(FicheMeta ficheMeta, RequestMap requestMap) {
            this.requestMap = requestMap;
            this.ficheMeta = ficheMeta;
        }

        private Fiche getFiche() {
            return this.fiche;
        }

        private Parser run() {
            this.parseJunction();
            this.parseFiche();
            return this;
        }

        private void parseJunction() {
            FileValue[] fileValues;
            File tmpDirectory;
            JunctionParseEngine.run(this.ficheMeta, this.requestMap, EditionEngine.this.parseContext, EditionEngine.this.workingLang);
            TokenKeys tokenKeys = TokenKeys.build(this.requestMap.getParameterNameSet());
            if (tokenKeys.withIllustration()) {
                tmpDirectory = ConfigurationUtils.getTmpDirectory(EditionEngine.this.bdfServer);
                IllustrationTokenParser illustrationTokenParser = new IllustrationTokenParser(this.ficheMeta, tmpDirectory);
                for (TokenKey tokenKey : tokenKeys.getTokenKeyList("illustration_file")) {
                    fileValues = this.requestMap.getFileValues(tokenKey.getParamName());
                    if (fileValues == null) continue;
                    illustrationTokenParser.addFromMultipart(tokenKey, fileValues);
                }
                for (TokenKey tokenKey : tokenKeys.getTokenKeyList("illustration_ref")) {
                    illustrationTokenParser.parse(tokenKey, this.requestMap.getParameterValues(tokenKey.getParamName()));
                }
                illustrationTokenParser.save(EditionEngine.this.fichothequeEditor);
            }
            if (tokenKeys.withDocument()) {
                tmpDirectory = ConfigurationUtils.getTmpDirectory(EditionEngine.this.bdfServer);
                DocumentTokenParser documentTokenParser = new DocumentTokenParser(this.ficheMeta, tmpDirectory);
                for (TokenKey tokenKey : tokenKeys.getTokenKeyList("document_file")) {
                    fileValues = this.requestMap.getFileValues(tokenKey.getParamName());
                    if (fileValues == null) continue;
                    documentTokenParser.addFromMultipart(tokenKey, fileValues);
                }
                for (TokenKey tokenKey : tokenKeys.getTokenKeyList("document_ref")) {
                    documentTokenParser.parse(tokenKey, this.requestMap.getParameterValues(tokenKey.getParamName()));
                }
                documentTokenParser.save(EditionEngine.this.fichothequeEditor);
            }
        }

        private void parseFiche() {
            if (EditionEngine.this.ficheParseType != 0) {
                this.fiche = FicheParseEngine.run(EditionEngine.this.ficheParser, this.ficheMeta, this.requestMap, EditionEngine.this.ficheParseType);
            }
        }

        private Parser saveFiche() {
            if (this.fiche != null) {
                CorpusEditor corpusEditor = EditionEngine.this.fichothequeEditor.getCorpusEditor(this.ficheMeta.getSubsetKey());
                FieldGenerationEngine engine = BdfCommandUtils.buildEngine(EditionEngine.this.bdfParameters, this.ficheMeta.getCorpus());
                CorpusTools.saveFiche(corpusEditor, this.ficheMeta, this.fiche, engine, true);
            }
            return this;
        }
    }
}

