/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.AppHtmlProducer;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.MessageHtmlProducer;
import fr.exemole.bdfserver.tools.apps.AppConf;
import fr.exemole.bdfserver.tools.apps.AppConfUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;

public class AppInstruction
implements BdfInstruction {
    private static final CommandMessage INACTIVE_MESSAGE = LogUtils.error("_ error.unsupported.inactiveapp", new Object[0]);
    private final BdfServer bdfServer;
    private final RequestMap requestMap;
    private final AppConf appConf;

    private AppInstruction(BdfServer bdfServer, RequestMap requestMap, AppConf appConf) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
        this.appConf = appConf;
    }

    @Override
    public short getBdfUserNeed() {
        String userNeedString = this.appConf.getString("core_bdfuserneed", "mandatory");
        if (userNeedString.equals("none")) {
            return 1;
        }
        if (this.requestMap.isTrue("bdf-exit")) {
            return 4;
        }
        if (userNeedString.equals("if_any")) {
            return 2;
        }
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        BdfServerHtmlProducer appHtmlProducer;
        boolean isActive = this.appConf.getBoolean("active");
        if (bdfUser != null) {
            DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
            appHtmlProducer = isActive ? new AppHtmlProducer(bdfParameters, this.appConf) : AppInstruction.initInactiveMessage(new MessageHtmlProducer(bdfParameters));
        } else {
            LangPreference langPreference = BdfInstructionUtils.getLangPreference(this.requestMap, this.bdfServer);
            appHtmlProducer = isActive ? new AppHtmlProducer(this.bdfServer, langPreference, this.appConf) : AppInstruction.initInactiveMessage(new MessageHtmlProducer(this.bdfServer, langPreference));
        }
        if (this.requestMap.isTrue("reload")) {
            this.bdfServer.getL10nManager().update();
            this.bdfServer.getTransformationManager().update();
            this.bdfServer.getJsAnalyser().clearCache();
        }
        return HtmlResponseHandler.init(appHtmlProducer);
    }

    @Override
    public Object getLoginOption(String optionName) {
        switch (optionName) {
            case "sessionmessage": {
                String messageKey = this.appConf.getString("login_sessionmessage");
                if (messageKey != null) {
                    return LogUtils.done(messageKey, new Object[0]);
                }
                return null;
            }
            case "availablespheres": {
                return this.appConf.getArray("login_availablespheres");
            }
            case "defaultsphere": {
                return this.appConf.getString("login_defaultsphere");
            }
            case "titlephrasename": {
                String titlePhraseName = this.appConf.getString("core_titlephrasename");
                if (titlePhraseName == null) {
                    titlePhraseName = this.appConf.getString("login_titlephrasename");
                }
                return titlePhraseName;
            }
        }
        return null;
    }

    public static AppInstruction build(BdfServer bdfServer, RequestMap requestMap, String appName) {
        if (appName.isEmpty()) {
            return null;
        }
        AppConf appConf = AppConfUtils.getAppConf(bdfServer.getResourceStorages(), appName);
        if (appConf != null) {
            return new AppInstruction(bdfServer, requestMap, appConf);
        }
        return null;
    }

    private static BdfServerHtmlProducer initInactiveMessage(MessageHtmlProducer messageHtmlProducer) {
        messageHtmlProducer.addMessages(INACTIVE_MESSAGE).setBodyCssClass("global-body-Message");
        return messageHtmlProducer;
    }
}

