/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.session.AuthenticationException;
import fr.exemole.bdfserver.conf.ConfUtils;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.api.namespaces.IndexSpace;
import fr.exemole.bdfserver.servlets.BDFSession;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.HttpServletRequestMap;

public final class BDFUtils {
    private BDFUtils() {
    }

    public static boolean hasLogin(HttpServletRequestMap requestMap) {
        String bdfLogin = requestMap.getParameter("bdf-login");
        if (bdfLogin == null) {
            bdfLogin = requestMap.getParameter("bdf-idsphere");
        }
        return bdfLogin != null;
    }

    public static LoginKey getLoginKey(HttpServletRequestMap requestMap) throws AuthenticationException {
        String completeLogin = BDFUtils.getCompleteLogin(requestMap);
        try {
            LoginKey loginKey = LoginKey.parse(completeLogin);
            return loginKey;
        }
        catch (ParseException pe) {
            throw new AuthenticationException(AuthenticationException.LOGIN_ERROR);
        }
    }

    public static CentralUser getCentralUser(HttpServletRequestMap requestMap, Multi multi) throws AuthenticationException {
        LoginKey loginKey = BDFUtils.getLoginKey(requestMap);
        CentralSphere centralSphere = multi.getCentralSphere(loginKey.getSphereName());
        if (centralSphere == null) {
            throw new AuthenticationException(AuthenticationException.SPHERE_ERROR);
        }
        CentralUser centralUser = centralSphere.getCentralUser(loginKey.getLogin());
        if (centralUser == null) {
            throw new AuthenticationException(AuthenticationException.LOGIN_ERROR);
        }
        return centralUser;
    }

    public static Redacteur getRedacteur(BdfServer bdfServer, HttpServletRequestMap requestMap) throws AuthenticationException {
        Redacteur redacteur;
        String completeLogin = BDFUtils.getCompleteLogin(requestMap);
        try {
            redacteur = bdfServer.getFichothequeQuestioner().getRedacteurByLogin(completeLogin);
        }
        catch (UserLoginException e) {
            if (e.isUnknownSphere()) {
                throw new AuthenticationException(AuthenticationException.SPHERE_ERROR);
            }
            throw new AuthenticationException(AuthenticationException.LOGIN_ERROR);
        }
        if (redacteur == null) {
            throw new AuthenticationException(AuthenticationException.LOGIN_ERROR);
        }
        return redacteur;
    }

    public static String getCompleteLogin(HttpServletRequestMap requestMap) throws AuthenticationException {
        String bdfLogin = requestMap.getParameter("bdf-login");
        if (bdfLogin == null) {
            bdfLogin = requestMap.getParameter("bdf-idsphere");
        }
        if (bdfLogin == null) {
            throw new AuthenticationException(AuthenticationException.UNDEFINED_ERROR);
        }
        String bdfSphere = requestMap.getParameter("bdf-sphere");
        if (!(bdfLogin = bdfLogin.trim()).contains("[")) {
            if (bdfSphere != null) {
                bdfSphere = bdfSphere.trim();
            }
            if (bdfSphere == null || bdfSphere.isEmpty()) {
                throw new AuthenticationException(AuthenticationException.SPHERE_ERROR);
            }
            bdfLogin = bdfLogin + "[" + bdfSphere + "]";
        }
        return bdfLogin;
    }

    public static String getRootUrl(HttpServletRequest request, String fichothequeName) {
        StringBuilder url = new StringBuilder();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getContextPath());
        url.append("/");
        if (!fichothequeName.isEmpty() && !fichothequeName.equals("_unique")) {
            url.append(fichothequeName);
            url.append("/");
        }
        return url.toString();
    }

    public static BDFSession getCurrentBdfSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (BDFSession)session.getAttribute("fr.exemole.BDFSession");
        }
        return null;
    }

    public static Domain parsePathInfo(String pathInfo) {
        String firstPart = pathInfo.toLowerCase();
        String secondPart = "";
        int length = pathInfo.length();
        for (int i = 0; i < length; ++i) {
            char carac = pathInfo.charAt(i);
            boolean isSeparator = false;
            switch (carac) {
                case '-': 
                case ':': 
                case '_': {
                    isSeparator = true;
                }
            }
            if (!isSeparator) continue;
            secondPart = firstPart.substring(i + 1);
            firstPart = firstPart.substring(0, i);
            break;
        }
        return new Domain(firstPart, secondPart);
    }

    public static LangPreference getLangPreference(Multi multi, HttpServletRequestMap requestMap) {
        return RequestUtils.checkLangPreference(requestMap, new LangPreferenceBuilder()).addLangs(multi.getMultiMetadata().getWorkingLangs()).addLang(Lang.build("fr")).toLangPreference();
    }

    public static SubsetKey getValidCentralSphere(Multi multi, String sphereName) {
        try {
            SubsetKey sphereKey = SubsetKey.parse((short)3, sphereName);
            if (multi.getCentralSphereNameSet().contains(sphereKey.getSubsetName())) {
                return sphereKey;
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static String getFichothequeRedirect(Multi multi) {
        String value = null;
        Attribute attribute = multi.getMultiMetadata().getAttributes().getAttribute(IndexSpace.REDIRECT_KEY);
        value = attribute != null ? attribute.getFirstValue() : multi.getMultiConf().getParam("default_fichotheque");
        if (value != null && !ConfUtils.isValidMultiName(value)) {
            value = null;
        }
        return value;
    }
}

