/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.misc;

import java.io.IOException;
import java.util.Set;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.json.FicheJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;

public class FicheRevisionsJsonProducer
implements JsonProducer {
    private final Corpus corpus;
    private final FichothequeQuestioner fichothequeQuestioner;
    private final Set<String> revisionNameSet;
    private final int id;

    public FicheRevisionsJsonProducer(Corpus corpus, int id, Set<String> revisionNameSet, FichothequeQuestioner fichothequeQuestioner) {
        this.corpus = corpus;
        this.id = id;
        this.revisionNameSet = revisionNameSet;
        this.fichothequeQuestioner = fichothequeQuestioner;
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("ficheRevisions");
        jw.object();
        for (String revisionName : this.revisionNameSet) {
            FicheAPI fiche = this.corpus.getFicheRevision(this.id, revisionName);
            jw.key(revisionName);
            jw.object();
            if (fiche != null) {
                FicheJson.properties(jw, this.corpus, fiche, this.fichothequeQuestioner);
            }
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }
}

