/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.api.users.BdfUserPrefsEditor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.CleanedString;

public class ThesaurusParameters {
    private Lang labelLang;
    private String labelFilter;
    private SubsetKey satelliteCorpusKey;
    private String satelliteFilter;

    @Nullable
    public Lang getLabelLang() {
        return this.labelLang;
    }

    @Nullable
    public String getLabelFilter() {
        return this.labelFilter;
    }

    @Nullable
    public SubsetKey getSatelliteCorpusKey() {
        return this.satelliteCorpusKey;
    }

    @Nullable
    public String getSatelliteFilter() {
        return this.satelliteFilter;
    }

    public boolean isEmpty() {
        if (this.labelLang != null) {
            return false;
        }
        return this.labelFilter == null;
    }

    private boolean populate(String paramName, String paramValue) {
        if (paramValue.isEmpty()) {
            switch (paramName) {
                case "labellang": 
                case "labelfilter": 
                case "satellitecorpus": 
                case "satellitefilter": {
                    return true;
                }
            }
            return false;
        }
        switch (paramName) {
            case "labellang": {
                try {
                    this.labelLang = Lang.parse(paramValue);
                    return true;
                }
                catch (ParseException pe) {
                    return false;
                }
            }
            case "labelfilter": {
                this.labelFilter = paramValue;
                return true;
            }
            case "satellitecorpus": {
                try {
                    this.satelliteCorpusKey = SubsetKey.parse((short)1, paramValue);
                    return true;
                }
                catch (ParseException pe) {
                    return false;
                }
            }
            case "satellitefilter": {
                this.satelliteFilter = paramValue;
                return true;
            }
        }
        return false;
    }

    public void save(BdfServerEditor bdfServerEditor, BdfUser bdfUser, Thesaurus thesaurus) {
        BdfUserPrefsEditor bdfUserPrefsEditor = bdfServerEditor.getBdfUserPrefsEditor(bdfUser.getPrefs());
        AttributeKey attributeKey = BdfUserSpace.toFilterParametersKey(thesaurus);
        List<CleanedString> valueList = this.getAttributeValueList();
        if (valueList.isEmpty()) {
            bdfUserPrefsEditor.removeAttribute(attributeKey);
        } else {
            AttributeBuilder attributeBuilder = new AttributeBuilder(attributeKey);
            for (CleanedString value : valueList) {
                attributeBuilder.addValue(value);
            }
            bdfUserPrefsEditor.putAttribute(attributeBuilder.toAttribute());
        }
    }

    private List<CleanedString> getAttributeValueList() {
        ArrayList<CleanedString> result = new ArrayList<CleanedString>();
        if (this.labelLang != null) {
            result.add(CleanedString.newInstance("labellang=" + this.labelLang.toString()));
        }
        if (this.labelFilter != null) {
            result.add(CleanedString.newInstance("labelfilter=" + this.labelFilter));
        }
        if (this.satelliteCorpusKey != null) {
            result.add(CleanedString.newInstance("satellitecorpus=" + this.satelliteCorpusKey.getSubsetName()));
        }
        if (this.satelliteFilter != null) {
            result.add(CleanedString.newInstance("satellitefilter=" + this.satelliteFilter));
        }
        return result;
    }

    public static ThesaurusParameters buildFromThesaurus(BdfUser bdfUser, Thesaurus thesaurus) {
        ThesaurusParameters parameters = new ThesaurusParameters();
        AttributeKey attributeKey = BdfUserSpace.toFilterParametersKey(thesaurus);
        Attribute attribute = bdfUser.getPrefs().getAttributes().getAttribute(attributeKey);
        if (attribute == null) {
            return parameters;
        }
        for (String value : attribute) {
            int idx = value.indexOf(61);
            if (idx <= 0) continue;
            String paramName = value.substring(0, idx).trim();
            String paramValue = value.substring(idx + 1).trim();
            if (paramName.length() <= 0) continue;
            parameters.populate(paramName, paramValue);
        }
        return parameters;
    }

    @Nullable
    public static ThesaurusParameters buildFromRequest(RequestMap requestMap) {
        ThesaurusParameters parameters = new ThesaurusParameters();
        boolean done = false;
        for (String paramName : requestMap.getParameterNameSet()) {
            boolean result = parameters.populate(paramName, requestMap.getParameter(paramName));
            if (!result) continue;
            done = true;
        }
        if (done) {
            return parameters;
        }
        return null;
    }
}

