/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.jslib.MiscJsLibs;
import fr.exemole.bdfserver.htmlproducers.thesaurus.SelectionIndexation;
import fr.exemole.bdfserver.tools.BH;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;

public class SelectionIndexationFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Motcle motcle;
    private final String mode;
    private final PermissionSummary permissionSummary;

    public SelectionIndexationFormHtmlProducer(BdfParameters bdfParameters, Motcle motcle, String mode) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.motcle = motcle;
        this.mode = mode;
        this.addThemeCss("selectionindexation.css");
        this.addJsLib(MiscJsLibs.SELECTIONINDEXATION);
    }

    @Override
    public void printHtml() {
        SelectionIndexation selectionIndexation = SelectionIndexation.build(this.bdfServer, this.bdfUser, this.motcle, this.bdfUser.getSelectedFiches(), this.mode);
        this.start();
        this.__(SelectionIndexation.printCommandResult(this)).__(PageUnit.start("action-FicheIndexation", "_ title.edition.selectionindexation"));
        this.P().__localize("_ label.global.motcle").__colon().__space().__(this.printMotcleTitle())._P();
        this.P().__localize("_ label.global.thesaurus").__colon().__space().__escape(FichothequeUtils.getTitle(this.motcle.getThesaurus(), this.workingLang))._P();
        if (!this.mode.isEmpty()) {
            this.P().__localize("_ label.global.mode").__colon().__space().__escape(this.mode)._P();
        }
        this.DIV(HA.id("selectionindexationToolbar"))._DIV();
        this.FORM_post(HA.action("thesaurus")).INPUT_hidden(ParameterMap.init().command("SelectionIndexation").page("selectionindexation-form").subset(this.motcle.getThesaurus()).subsetItem(this.motcle).param("mode", this.mode)).__(selectionIndexation).__(Button.COMMAND, Button.submit("_ submit.thesaurus.motcleselectionindexation"))._FORM();
        this.__(PageUnit.END);
        this.end();
    }

    private boolean printMotcleTitle() {
        if (this.permissionSummary.isSubsetAdmin(this.motcle.getSubsetKey())) {
            this.A(HA.href(BH.domain("thesaurus").page("motcle-changeform").subsetItem(this.motcle))).__(BdfHtmlUtils.printMotcleTitle(this, this.motcle, this.workingLang))._A();
        } else {
            this.__(BdfHtmlUtils.printMotcleTitle(this, this.motcle, this.workingLang));
        }
        return true;
    }
}

