/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import net.fichotheque.metadata.FichothequeMetadata;
import net.mapeadores.util.html.CommandBox;

public class CoreFormHtmlProducer
extends BdfServerHtmlProducer {
    public CoreFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
    }

    @Override
    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("configuration").family("CNF").veil(true).page("config-core");
        this.printIdentification(commandBox);
        this.printLangConfig(commandBox);
        this.printUserAllow(commandBox);
        this.end();
    }

    private void printIdentification(CommandBox commandBox) {
        FichothequeMetadata fichothequeMetadata = this.bdfServer.getFichotheque().getFichothequeMetadata();
        commandBox = commandBox.derive("Identification", "_ CNF-01").submitLocKey("_ submit.configuration.identification");
        this.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.configuration.authority", this.name("authority").value(fichothequeMetadata.getAuthority()).size("60").populate(InputPattern.AUTHORITY).required(true))).__(Grid.textInputRow("_ label.configuration.basename_fichotheque", this.name("basename").value(fichothequeMetadata.getBaseName()).size("30").populate(InputPattern.TECHNICAl_UNDERSCORE).required(true))).__(Grid.END).__end(commandBox);
    }

    private void printLangConfig(CommandBox commandBox) {
        LangConfiguration langConfiguration = this.bdfServer.getLangConfiguration();
        boolean allLanguages = langConfiguration.isAllLanguages();
        String supplementaryId = this.generateId();
        commandBox = commandBox.derive("LangConfig", "_ CNF-03").submitLocKey("_ submit.configuration.langconfig");
        this.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.configuration.workinglang", this.name("workinglang").value(langConfiguration.getWorkingLangs().toString(";")).size("15"))).__(Grid.radioRow((Object)"_ label.configuration.alllang_no", this.name("alllang").value("0").checked(!allLanguages).populate(Deploy.radio(supplementaryId)), () -> this.DIV(Grid.detailPanelTable().id(supplementaryId).addClass(allLanguages, "hidden")).__(Grid.textInputRow("_ label.configuration.supplementarylang", this.name("supplementarylang").value(langConfiguration.getSupplementaryLangs().toString(";")).size("15")))._DIV())).__(Grid.radioRow("_ label.configuration.alllang_yes", this.name("alllang").value("1").checked(allLanguages))).__(Grid.checkboxRow("_ label.configuration.withnonlatin", this.name("withnonlatin").value("1").checked(langConfiguration.isWithNonlatin()))).__(Grid.checkboxRow("_ label.configuration.withoutsurnamefirst", this.name("withoutsurnamefirst").value("1").checked(langConfiguration.isWithoutSurnameFirst()))).__(Grid.END).__end(commandBox);
    }

    private void printUserAllow(CommandBox commandBox) {
        UserAllow userAllow = this.bdfServer.getPolicyManager().getUserAllow();
        commandBox = commandBox.derive("UserAllowChange", "_ CNF-05").submitLocKey("_ submit.configuration.userallowchange");
        this.__start(commandBox).__(Grid.START).__(Grid.checkboxRow("_ label.configuration.userallow_data", this.name("data").value("1").checked(userAllow.isDataChangeAllowed()))).__(Grid.checkboxRow("_ label.configuration.userallow_password", this.name("password").value("1").checked(userAllow.isPasswordChangeAllowed()))).__(Grid.END).__end(commandBox);
    }
}

