/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email.datasource;

import fr.exemole.bdfserver.api.BdfServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import net.fichotheque.addenda.Version;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;

public class VersionDataSource
implements DataSource {
    private final Version version;
    private final String versionName;
    private final String contentType;

    private VersionDataSource(String versionName, Version version, String contentType) {
        this.version = version;
        this.contentType = contentType;
        this.versionName = versionName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.versionName;
    }

    public InputStream getInputStream() throws IOException {
        return this.version.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("no editable source");
    }

    public static VersionDataSource newInstance(BdfServer bdfServer, Version version) {
        String versionName = version.getFileName();
        MimeTypeResolver mimeTypeResolver = bdfServer.getMimeTypeResolver();
        String contentType = MimeTypeUtils.getMimeType(mimeTypeResolver, versionName);
        return new VersionDataSource(versionName, version, contentType);
    }
}

