/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.simplegrille.smstimpl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.desmodo.simplegrille.api.SimpleStructure;
import net.desmodo.simplegrille.api.SimpleStructureBuilder;
import net.desmodo.simplegrille.smstimpl.SimpleContexteImpl;
import net.desmodo.simplegrille.smstimpl.SimpleContexteListImpl;
import net.desmodo.simplegrille.smstimpl.SimpleDescripteurPereImpl;
import net.desmodo.simplegrille.smstimpl.SimpleFamilleImpl;
import net.desmodo.simplegrille.smstimpl.SimpleStructureImpl;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.InvalidXMLException;

public class SimpleStructureBuilderImpl
implements SimpleStructureBuilder {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");
    private final Set<Lang> langSet = new LinkedHashSet<Lang>();
    private final List<TermBuilder> contexteList = new ArrayList<TermBuilder>();
    private final List<TermBuilder> descripteurList = new ArrayList<TermBuilder>();
    private final List<TermBuilder> familleList = new ArrayList<TermBuilder>();
    private final Map<String, TermBuilder> descripteurMap = new HashMap<String, TermBuilder>();
    private final Map<String, TermBuilder> familleMap = new HashMap<String, TermBuilder>();
    private final Map<String, ListBuilder> contexteListMap = new LinkedHashMap<String, ListBuilder>();

    @Override
    public void addLang(Lang lang) {
        this.langSet.add(lang);
    }

    @Override
    public int addSimpleContexte(String idctxt, Color color, String name) {
        ListBuilder listBuilder = this.getListBuilder(name);
        TermBuilder termBuilder = listBuilder.addTermBuilder(idctxt, color);
        return termBuilder.getIndex();
    }

    @Override
    public int addSimpleDescripteurPere(String iddesc, String idfamille, String contexteListName) {
        TermBuilder termBuilder = this.descripteurMap.get(iddesc);
        if (termBuilder == null) {
            termBuilder = new TermBuilder(this.descripteurList.size(), iddesc);
            termBuilder.setContexteListName(contexteListName);
            termBuilder.setIdfamille(idfamille);
            this.descripteurList.add(termBuilder);
            this.descripteurMap.put(iddesc, termBuilder);
        }
        return termBuilder.getIndex();
    }

    @Override
    public int addSimpleFamille(String idfamille, Color color) {
        TermBuilder termBuilder = this.familleMap.get(idfamille);
        if (termBuilder == null) {
            termBuilder = new TermBuilder(this.familleMap.size(), idfamille);
            termBuilder.setIdfamille(idfamille);
            termBuilder.setColor(color);
            this.familleMap.put(idfamille, termBuilder);
            this.familleList.add(termBuilder);
        }
        return termBuilder.getIndex();
    }

    @Override
    public void putContexteLibelle(int index, Label libelle) {
        TermBuilder termBuilder = this.contexteList.get(index);
        termBuilder.setLibelle(libelle);
    }

    @Override
    public void putDescripteurPereLibelle(int index, Label libelle) {
        TermBuilder termBuilder = this.descripteurList.get(index);
        termBuilder.setLibelle(libelle);
    }

    @Override
    public void putFamilleLibelle(int index, Label libelle) {
        TermBuilder termBuilder = this.familleList.get(index);
        termBuilder.setLibelle(libelle);
    }

    @Override
    public void putContexteListLibelle(String name, Label libelle) {
        ListBuilder builder = this.getListBuilder(name);
        builder.putLibelle(libelle);
    }

    @Override
    public void setContexteListColor(String name, Color color) {
        ListBuilder builder = this.getListBuilder(name);
        builder.setColor(color);
    }

    @Override
    public void addListLengthValue(int index, String idctxt, int value) {
        TermBuilder termBuilder = this.descripteurList.get(index);
        termBuilder.addListLength(idctxt, value);
    }

    private ListBuilder getListBuilder(String name) {
        ListBuilder listBuilder = this.contexteListMap.get(name);
        if (listBuilder == null) {
            listBuilder = new ListBuilder(name);
            this.contexteListMap.put(name, listBuilder);
        }
        return listBuilder;
    }

    public SimpleStructure toSimpleStructure() {
        Langs langs = this.langSet.isEmpty() ? LangsUtils.wrap((Lang[])new Lang[]{DEFAULT_LANG}) : LangsUtils.fromCollection(this.langSet);
        HashMap<String, Object> simpleFamilleMap = new HashMap<String, Object>();
        int familleSize = this.familleList.size();
        SimpleFamilleImpl[] familleArray = new SimpleFamilleImpl[familleSize];
        for (int i = 0; i < familleSize; ++i) {
            TermBuilder termeBuilder = this.familleList.get(i);
            String idfamille = termeBuilder.getIdfamille();
            Color color = termeBuilder.getColor();
            SimpleFamilleImpl implSimpleFamille = new SimpleFamilleImpl(idfamille, termeBuilder.libelleMap, color);
            simpleFamilleMap.put(idfamille, implSimpleFamille);
            familleArray[i] = implSimpleFamille;
        }
        HashMap<String, SimpleContexteListImpl> implClMap = new HashMap<String, SimpleContexteListImpl>();
        int sizeContexteList = this.contexteListMap.size();
        SimpleContexteListImpl[] contexteListArray = null;
        if (sizeContexteList == 0) {
            throw new InvalidXMLException("missing simple-contexte-list element in simple-structure");
        }
        contexteListArray = new SimpleContexteListImpl[sizeContexteList];
        int p = 0;
        for (ListBuilder listBuilder : this.contexteListMap.values()) {
            SimpleContexteListImpl iscl;
            contexteListArray[p] = iscl = listBuilder.toImplSimpleContexteList();
            implClMap.put(iscl.getName(), iscl);
            ++p;
        }
        int sizeDescripteur = this.descripteurList.size();
        if (sizeDescripteur == 0) {
            throw new InvalidXMLException("missing simple-descripteur-pere element in simple-structure");
        }
        SimpleDescripteurPereImpl[] descripteurArray = new SimpleDescripteurPereImpl[sizeDescripteur];
        for (int i = 0; i < sizeDescripteur; ++i) {
            SimpleContexteListImpl iscl;
            TermBuilder termeBuilder = this.descripteurList.get(i);
            String idfamille = termeBuilder.getIdfamille();
            SimpleFamilleImpl simpleFamille = null;
            if (idfamille != null) {
                simpleFamille = (SimpleFamilleImpl)simpleFamilleMap.get(idfamille);
            }
            if ((iscl = (SimpleContexteListImpl)implClMap.get(termeBuilder.getContexteListName())) == null) {
                iscl = contexteListArray[0];
            }
            descripteurArray[i] = new SimpleDescripteurPereImpl(termeBuilder.id, termeBuilder.libelleMap, simpleFamille, iscl, termeBuilder.getListLengthMap());
        }
        return new SimpleStructureImpl(langs, contexteListArray, descripteurArray, familleArray);
    }

    private class ListBuilder {
        private final String name;
        private final Map<String, TermBuilder> contexteMap = new LinkedHashMap<String, TermBuilder>();
        private final Map<Lang, Label> libelleMap = new HashMap<Lang, Label>();
        private Color color;

        private ListBuilder(String name) {
            this.name = name;
        }

        public TermBuilder addTermBuilder(String idctxt, Color color) {
            TermBuilder termBuilder = this.contexteMap.get(idctxt);
            if (termBuilder == null) {
                termBuilder = new TermBuilder(SimpleStructureBuilderImpl.this.contexteList.size(), idctxt);
                termBuilder.setColor(color);
                SimpleStructureBuilderImpl.this.contexteList.add(termBuilder);
                this.contexteMap.put(idctxt, termBuilder);
            }
            return termBuilder;
        }

        private SimpleContexteListImpl toImplSimpleContexteList() {
            int size = this.contexteMap.size();
            if (size == 0) {
                throw new InvalidXMLException("empty simple-contexte-list");
            }
            SimpleContexteImpl[] iscArray = new SimpleContexteImpl[size];
            int p = 0;
            for (TermBuilder termeBuilder : this.contexteMap.values()) {
                iscArray[p] = new SimpleContexteImpl(termeBuilder.id, termeBuilder.libelleMap, termeBuilder.getColor());
                ++p;
            }
            return new SimpleContexteListImpl(this.name, this.libelleMap, iscArray, this.color);
        }

        public void putLibelle(Label libelle) {
            this.libelleMap.put(libelle.getLang(), libelle);
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    private class TermBuilder {
        private Map<Lang, Label> libelleMap = new HashMap<Lang, Label>();
        private Map<String, Integer> listLengthMap = null;
        private final int index;
        private String id;
        private String idfamille;
        private Color color;
        private String contexteListName;

        private TermBuilder(int index, String id) {
            this.index = index;
            this.id = id;
        }

        public int getIndex() {
            return this.index;
        }

        void setLibelle(Label libelle) {
            this.libelleMap.put(libelle.getLang(), libelle);
        }

        void setIdfamille(String idfamille) {
            this.idfamille = idfamille;
        }

        void setColor(Color color) {
            this.color = color;
        }

        void setContexteListName(String contexteListName) {
            this.contexteListName = contexteListName;
        }

        String getContexteListName() {
            return this.contexteListName;
        }

        Color getColor() {
            return this.color;
        }

        String getIdfamille() {
            return this.idfamille;
        }

        void addListLength(String idctxt, int value) {
            if (this.listLengthMap == null) {
                this.listLengthMap = new HashMap<String, Integer>();
            }
            this.listLengthMap.put(idctxt, value);
        }

        Map<String, Integer> getListLengthMap() {
            return this.listLengthMap;
        }
    }
}

