/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.simplegrille;

import fr.exemole.bdfext.simplegrille.export.IndexHtmlProducer;
import fr.exemole.bdfext.simplegrille.export.SimpleGrilleXmlProducer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import java.text.ParseException;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.servlets.handlers.XmlResponseHandler;
import net.mapeadores.util.xml.XmlProducer;

public class SimpleGrilleBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private final Map<String, String> paramMap;
    private final RequestMap requestMap;
    private final BdfServer bdfServer;
    private final Fichotheque fichotheque;

    public SimpleGrilleBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> paramMap) {
        this.bdfServer = bdfServer;
        this.paramMap = paramMap;
        this.requestMap = requestMap;
        this.fichotheque = bdfServer.getFichotheque();
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        String page = this.paramMap.get("page");
        if (page.equals("simplegrille")) {
            Corpus corpus;
            try {
                SubsetKey corpusKey = SubsetKey.parse((short)1, (String)this.paramMap.get("corpus"));
                corpus = (Corpus)this.fichotheque.getSubset(corpusKey);
                if (corpus == null) {
                    return SimpleResponseHandler.init((String)("Corpus inconnu = " + this.paramMap.get("corpus")));
                }
            }
            catch (ParseException pe) {
                return SimpleResponseHandler.init((String)("Corpus incorrect = " + this.paramMap.get("corpus")));
            }
            int id = Integer.parseInt(this.paramMap.get("id"));
            FicheMeta ficheMeta = corpus.getFicheMetaById(id);
            if (ficheMeta == null) {
                return SimpleResponseHandler.init((String)("Aucune fiche avec le num\u00e9ro = " + id));
            }
            return XmlResponseHandler.init((XmlProducer)new SimpleGrilleXmlProducer(ficheMeta), (String)"application/x-simplegrille");
        }
        if (page.equals("index")) {
            return HtmlResponseHandler.init((HtmlProducer)new IndexHtmlProducer((BdfParameters)bdfParameters));
        }
        return null;
    }
}

