/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.exportation.analytique;

import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.ItemAnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.TableaucroiseDef;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.exportation.CategoryColumnDef;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Lien;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.primitives.RangeDateFilter;
import net.mapeadores.util.text.DateFormatBundle;

public class TableaucroiseTableEngine
extends TableEngine {
    private static final short LABEL_OPTION = 1;
    private static final short IDALPHA_OPTION = 2;
    private static final short IDALPHALABEL_OPTION = 3;
    private final Fichotheque fichotheque;
    private final AnalytiqueDetails analytiqueDetails;
    private final Thesaurus croiseThesaurus;
    private final List<Motcle> motcleList;
    private final OdTableDef odTableDef;
    private final String title;
    private final DecimalFormatSymbols symbols;
    private final Currencies currencies;
    private final int currencyLength;
    private final Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
    private final IncludeKey includeKey;
    private final short rowHeaderType;
    private final short colHeaderType;

    public TableaucroiseTableEngine(AnalytiqueDetails analytiqueDetails, ScarabeLocalisation scarabeLocalisation, IncludeKey includeKey, List<Motcle> motcleList) {
        super(scarabeLocalisation);
        this.includeKey = includeKey;
        this.fichotheque = analytiqueDetails.getAnalytiqueSubset().getSubset().getFichotheque();
        this.analytiqueDetails = analytiqueDetails;
        this.croiseThesaurus = (Thesaurus)this.fichotheque.getSubset(includeKey.getSubsetKey());
        this.motcleList = motcleList;
        this.title = this.initTitle(scarabeLocalisation);
        this.symbols = new DecimalFormatSymbols(scarabeLocalisation.getFormatLocale());
        this.currencies = analytiqueDetails.getCustomCurrencies();
        this.currencyLength = this.currencies.size();
        TableaucroiseDef tableaucroiseDef = TableaucroiseTableEngine.getTableaucroiseDef(analytiqueDetails, includeKey);
        OdTableDefBuilder odTableDefBuilder = OdTableDefBuilder.init((String)"").addStandard();
        int motcleCount = motcleList.size();
        for (int j = 0; j < motcleCount; ++j) {
            for (int i = 0; i < this.currencyLength; ++i) {
                String category = "MIDDLE_MONTANT";
                if (i == this.currencyLength - 1) {
                    category = "LAST_MONTANT";
                }
                odTableDefBuilder.add((OdColumnDef)CategoryColumnDef.buildCurrency((ExtendedCurrency)this.currencies.get(i), category));
            }
        }
        this.odTableDef = odTableDefBuilder.toOdTableDef();
        for (int i = 0; i < motcleCount; ++i) {
            Motcle motcle = motcleList.get(i);
            this.indexMap.put(motcle.getId(), i);
        }
        this.rowHeaderType = this.getHeaderType(tableaucroiseDef, "rowheader");
        this.colHeaderType = this.getHeaderType(tableaucroiseDef, "colheader");
    }

    private String initTitle(ScarabeLocalisation scarabeLocalisation) {
        Lang workingLang = scarabeLocalisation.getWorkingLang();
        StringBuilder buf = new StringBuilder();
        if (this.analytiqueDetails instanceof ItemAnalytiqueDetails) {
            buf.append(ScarabeUtils.getLibelle(((ItemAnalytiqueDetails)this.analytiqueDetails).getAnalytiqueItem(), workingLang));
        } else {
            buf.append(FichothequeUtils.getTitle((Subset)this.analytiqueDetails.getAnalytiqueSubset().getSubset(), (Lang)workingLang));
        }
        RangeDateFilter rangeDateFilter = this.analytiqueDetails.getRangeDateFilter();
        if (rangeDateFilter != null) {
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle((Locale)scarabeLocalisation.getFormatLocale());
            buf.append(" / ");
            FuzzyDate min = rangeDateFilter.getMinDate();
            buf.append(min.getDateLitteral(dateFormatBundle));
            FuzzyDate max = rangeDateFilter.getMaxDate();
            if (!max.equals((Object)min)) {
                buf.append(" - ");
                buf.append(max.getDateLitteral(dateFormatBundle));
            }
        }
        return buf.toString();
    }

    @Override
    public OdTableDef getOdTableDef() {
        return this.odTableDef;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void writeHead(ScarabeTableWriter tableWriter) {
        tableWriter.startRow((short)103);
        tableWriter.addStringCell(this.title);
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        for (Motcle motcle : this.motcleList) {
            tableWriter.addStringCell(this.subsetItemToText((SubsetItem)motcle, workingLang, this.colHeaderType), this.currencyLength);
        }
        tableWriter.endRow();
    }

    @Override
    public void writeBody(ScarabeTableWriter tableWriter) {
        Total totalFinal = new Total(this.motcleList.size(), this.currencyLength, "");
        for (AnalytiqueDetail analytiqueDetail : this.analytiqueDetails.getAnalytiqueDetailList()) {
            Total soustotal = this.printLignes(tableWriter, analytiqueDetail, 1);
            totalFinal.addTotal(soustotal);
        }
        if (!totalFinal.isEmpty()) {
            this.printTotalRow(tableWriter, (short)104, totalFinal, "_ label.scarabe.total_lignes");
        }
    }

    private Total printLignes(ScarabeTableWriter tableWriter, AnalytiqueDetail analytiqueDetail, int level) {
        Lang workingLang = this.getScarabeLocalisation().getWorkingLang();
        Total totalIntermediaire = new Total(this.motcleList.size(), this.currencyLength, ScarabeUtils.getIdalpha(analytiqueDetail.getDetailObject(), workingLang));
        if (analytiqueDetail.isLigneEmpty()) {
            return totalIntermediaire;
        }
        if (!analytiqueDetail.getLigneDetailList().isEmpty()) {
            String libelle = this.toText(analytiqueDetail.getDetailObject(), workingLang, this.rowHeaderType);
            tableWriter.startRow();
            tableWriter.addStringCell(libelle);
            for (LigneDetail ligneDetail : analytiqueDetail.getLigneDetailList()) {
                this.addLigne(totalIntermediaire, ligneDetail);
            }
            int motcleCount = totalIntermediaire.getMoneyByCurrencyCount();
            for (int i = 0; i < motcleCount; ++i) {
                this.printMontantCell(tableWriter, totalIntermediaire.getMoneyByCurrency(i));
            }
            tableWriter.endRow();
        }
        boolean withIntermediaire = false;
        for (AnalytiqueDetail sousDetail : analytiqueDetail.getSubDetailList()) {
            Total sousTotal = this.printLignes(tableWriter, sousDetail, level + 1);
            if (sousTotal.isEmpty()) continue;
            totalIntermediaire.addTotal(sousTotal);
            withIntermediaire = true;
        }
        if (withIntermediaire) {
            this.printTotalIntermediaireRow(tableWriter, (short)115, totalIntermediaire);
        }
        return totalIntermediaire;
    }

    private void printMontantCell(ScarabeTableWriter tableWriter, MoneyByCurrency moneyByCurrency) {
        boolean opposite = true;
        for (int i = 0; i < this.currencyLength; ++i) {
            if (moneyByCurrency.withMoney(i)) {
                long moneyLong = moneyByCurrency.getMoneyLong(i);
                if (opposite) {
                    moneyLong = -moneyLong;
                }
                tableWriter.addMoneyCell(moneyLong, (ExtendedCurrency)this.currencies.get(i));
                continue;
            }
            tableWriter.addNullCell(1);
        }
    }

    private void printTotalRow(ScarabeTableWriter tableWriter, short rowType, Total total, String messageKey) {
        tableWriter.startRow(rowType);
        tableWriter.addMessageCell(messageKey);
        int motcleCount = total.getMoneyByCurrencyCount();
        for (int i = 0; i < motcleCount; ++i) {
            this.printMontantCell(tableWriter, total.getMoneyByCurrency(i));
        }
        tableWriter.endRow();
    }

    private void printTotalIntermediaireRow(ScarabeTableWriter tableWriter, short rowType, Total total) {
        tableWriter.startRow(rowType);
        tableWriter.addStringCell("(" + total.getTotalIntermediaireIntitule() + ")");
        int motcleCount = total.getMoneyByCurrencyCount();
        for (int i = 0; i < motcleCount; ++i) {
            this.printMontantCell(tableWriter, total.getMoneyByCurrency(i));
        }
        tableWriter.endRow();
    }

    private void addLigne(Total total, LigneDetail ligneDetail) {
        Ligne ligne = ligneDetail.getLigne();
        MoneyByCurrency moneyByCurrency = ligneDetail.getMoneyByCurrency();
        String mode = this.includeKey.getMode();
        int poidsFilter = this.includeKey.getPoidsFilter();
        Croisements croisements = this.fichotheque.getCroisements((SubsetItem)ligne.getFicheMeta(), (Subset)this.croiseThesaurus);
        for (Croisements.Entry entry : croisements.getEntryList()) {
            Croisement croisement;
            Lien lien;
            SubsetItem subsetItem = entry.getSubsetItem();
            Integer index = this.indexMap.get(subsetItem.getId());
            if (index == null || (lien = (croisement = entry.getCroisement()).getLienByMode(mode)) == null || poidsFilter != -1 && lien.getPoids() != poidsFilter) continue;
            total.add(index, moneyByCurrency);
        }
    }

    private String toText(Object object, Lang workingLang, short type) {
        if (object instanceof AnalytiqueItem) {
            return this.subsetItemToText(((AnalytiqueItem)object).getSubsetItem(), workingLang, type);
        }
        if (object instanceof AnalytiqueGathering.SubCorpus) {
            return ScarabeUtils.getShortLibelle((SubsetItem)((AnalytiqueGathering.SubCorpus)object).getFicheMeta(), workingLang);
        }
        if (object instanceof AnalytiqueGathering.Groupby) {
            Motcle motcle = ((AnalytiqueGathering.Groupby)object).getMotcle();
            if (motcle == null) {
                return "";
            }
            return this.subsetItemToText((SubsetItem)motcle, workingLang, type);
        }
        return "";
    }

    private String subsetItemToText(SubsetItem subsetItem, Lang workingLang, short type) {
        if (subsetItem instanceof FicheMeta) {
            return ((FicheMeta)subsetItem).getTitre();
        }
        Motcle motcle = (Motcle)subsetItem;
        String idalpha = motcle.getIdalpha();
        if (idalpha == null) {
            return motcle.getLabelString(workingLang);
        }
        switch (type) {
            case 1: {
                return motcle.getLabelString(workingLang, idalpha);
            }
            case 3: {
                return ScarabeUtils.getLibelle((SubsetItem)motcle, workingLang);
            }
        }
        return idalpha;
    }

    private static TableaucroiseDef getTableaucroiseDef(AnalytiqueDetails analytiqueDetailHolder, IncludeKey includeKey) {
        AnalytiqueDef analytiqueDef = analytiqueDetailHolder.getAnalytiqueSubset().getAnalytiqueDef();
        for (TableaucroiseDef tableaucroiseDef : analytiqueDef.getTableaucroiseDefList()) {
            if (!tableaucroiseDef.getIncludeKey().equals((Object)includeKey)) continue;
            return tableaucroiseDef;
        }
        return null;
    }

    private short getHeaderType(TableaucroiseDef tableaucroiseDef, String name) {
        if (tableaucroiseDef == null) {
            return 2;
        }
        String option = tableaucroiseDef.getOption(name);
        if (option == null) {
            return 2;
        }
        switch (option) {
            case "label": 
            case "lib": {
                return 1;
            }
            case "idalphalabel": 
            case "idalphalib": {
                return 3;
            }
        }
        return 2;
    }

    private static class Total {
        private final MutableMoneyByCurrency[] moneyByCurrencyArray;
        private boolean empty = true;
        private String intitule;

        private Total(int motcleCount, int currencyCount, String intitule) {
            this.moneyByCurrencyArray = new MutableMoneyByCurrency[motcleCount];
            for (int i = 0; i < motcleCount; ++i) {
                this.moneyByCurrencyArray[i] = new MutableMoneyByCurrency(currencyCount);
            }
            this.intitule = intitule;
        }

        private int getMoneyByCurrencyCount() {
            return this.moneyByCurrencyArray.length;
        }

        private MoneyByCurrency getMoneyByCurrency(int i) {
            return this.moneyByCurrencyArray[i];
        }

        private void addTotal(Total total) {
            if (total.isEmpty()) {
                return;
            }
            int length = this.moneyByCurrencyArray.length;
            for (int i = 0; i < length; ++i) {
                this.moneyByCurrencyArray[i].add(total.moneyByCurrencyArray[i]);
            }
            if (total.intitule.length() > 0) {
                this.intitule = this.intitule.length() == 0 ? total.intitule : this.intitule + " + " + total.intitule;
            }
            this.empty = false;
        }

        private void add(int index, MoneyByCurrency moneyByCurrency) {
            this.moneyByCurrencyArray[index].add(moneyByCurrency);
            this.empty = false;
        }

        private boolean isEmpty() {
            return this.empty;
        }

        private String getTotalIntermediaireIntitule() {
            return this.intitule;
        }
    }
}

