/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.cours;

import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.metadata.CorpusField;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyConversion;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;

public class CoursManagerBuilder {
    private CoursManagerBuilder() {
    }

    public static CoursManager build(AliasHolder coursAliasHolder) {
        Corpus coursCorpus = coursAliasHolder.getCorpus("cours");
        CorpusField monnaieField = coursAliasHolder.getCorpusField("cours_monnaie");
        CorpusField pivotField = coursAliasHolder.getCorpusField("cours_montantspivots");
        CorpusField dateField = coursAliasHolder.getCorpusField("cours_date");
        InternalCoursManager coursManager = new InternalCoursManager(pivotField.getCurrencies());
        for (FicheMeta ficheMeta : coursCorpus.getFicheMetaList()) {
            Object pivotObj;
            ExtendedCurrency otherCurrency;
            FicheAPI ficheAPI = coursCorpus.getFicheAPI(ficheMeta, false);
            Object monnaieObj = ficheAPI.getValue(monnaieField);
            if (monnaieObj == null || !(monnaieObj instanceof Item)) continue;
            try {
                otherCurrency = ExtendedCurrency.parse((String)((Item)monnaieObj).getValue());
            }
            catch (ParseException pe) {
                continue;
            }
            FuzzyDate date = null;
            Object dateObj = ficheAPI.getValue(dateField);
            if (dateObj != null) {
                if (!(dateObj instanceof Datation)) continue;
                date = ((Datation)dateObj).getDate();
            }
            if ((pivotObj = ficheAPI.getValue(pivotField)) == null || !(pivotObj instanceof FicheItems)) continue;
            FicheItems pivotList = (FicheItems)pivotObj;
            for (FicheItem ficheItem : pivotList) {
                if (!(ficheItem instanceof Montant)) continue;
                coursManager.add(otherCurrency, (Montant)ficheItem, date);
            }
        }
        return coursManager;
    }

    private static String toKey(ExtendedCurrency pivotCurrency, ExtendedCurrency otherCurrency) {
        return pivotCurrency.getCurrencyCode() + "_" + otherCurrency.getCurrencyCode();
    }

    private static class InternalCoursManager
    implements CoursManager {
        private final Currencies pivotCurrencies;
        private final Map<String, Pivot> pivotMap = new HashMap<String, Pivot>();

        private InternalCoursManager(Currencies pivotCurrencies) {
            this.pivotCurrencies = pivotCurrencies;
        }

        @Override
        public MoneyConversion getMoneyConversion(FuzzyDate date, ExtendedCurrency pivotCurrency, ExtendedCurrency otherCurrency) {
            if (pivotCurrency.equals((Object)otherCurrency)) {
                return MoneyUtils.SAME_MONEYCONVERSION;
            }
            String key = CoursManagerBuilder.toKey(pivotCurrency, otherCurrency);
            Pivot pivot = this.pivotMap.get(key);
            if (pivot == null) {
                return null;
            }
            return pivot.getMoneyConversion(date);
        }

        @Override
        public Currencies getPivotCurrencies() {
            return this.pivotCurrencies;
        }

        private void add(ExtendedCurrency otherCurrency, Montant montant, FuzzyDate date) {
            ExtendedCurrency pivotCurrency = montant.getCurrency();
            String key = CoursManagerBuilder.toKey(pivotCurrency, otherCurrency);
            Pivot pivot = this.pivotMap.get(key);
            if (pivot == null) {
                pivot = new Pivot();
                this.pivotMap.put(key, pivot);
            }
            MoneyConversion moneyConversion = MoneyUtils.toMoneyConversion((ExtendedCurrency)pivotCurrency, (ExtendedCurrency)otherCurrency, (Decimal)montant.getDecimal());
            pivot.add(date, moneyConversion);
        }
    }

    private static class Pivot {
        private MoneyConversion defaultMonnaieConversion;
        private final Map<FuzzyDate, MoneyConversion> conversionMap = new HashMap<FuzzyDate, MoneyConversion>();

        private Pivot() {
        }

        public MoneyConversion getMoneyConversion(FuzzyDate date) {
            if (date == null) {
                return this.defaultMonnaieConversion;
            }
            MoneyConversion moneyConversion = this.conversionMap.get(date);
            if (moneyConversion != null) {
                return moneyConversion;
            }
            short type = date.getType();
            switch (type) {
                case 5: {
                    return this.getMoneyConversion(date.truncate((short)4));
                }
                case 4: {
                    return this.getMoneyConversion(date.truncate((short)3));
                }
                case 3: {
                    return this.getMoneyConversion(date.truncate((short)2));
                }
                case 2: {
                    return this.getMoneyConversion(date.truncate((short)1));
                }
            }
            return this.defaultMonnaieConversion;
        }

        private void add(FuzzyDate date, MoneyConversion moneyConversion) {
            if (date == null) {
                this.defaultMonnaieConversion = moneyConversion;
            } else {
                this.conversionMap.put(date, moneyConversion);
            }
        }
    }
}

