/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.configuration;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDefManager;
import fr.exemole.bdfext.scarabe.api.configuration.TableDefConfig;
import fr.exemole.bdfext.scarabe.tools.analytique.PrerequestDefManagerDOMReader;
import fr.exemole.bdfext.scarabe.tools.analytique.PrerequestDefManagerImpl;
import fr.exemole.bdfext.scarabe.xml.PrerequestDefManagerXMLWriter;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.tools.exportation.table.TableDefParser;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.ResourceFolder;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.MessageByLine;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SimpleLineMessageHandler;
import net.mapeadores.util.logging.SimpleMessageHandler;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;
import org.w3c.dom.Document;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static PrerequestDefManager getPrerequestDefManager(ScarabeContext scarabeContext) {
        return (PrerequestDefManager)scarabeContext.getContextObject("PREREQUESTDEF_MANAGER");
    }

    public static void initPrerequestDefManager(ScarabeContext scarabeContext) {
        PrerequestDefManagerImpl prerequestDefManager = new PrerequestDefManagerImpl();
        scarabeContext.putContextObject("PREREQUESTDEF_MANAGER", prerequestDefManager);
        EditableResourceStorage resourceStorage = scarabeContext.getDataStorage();
        RelativePath path = RelativePath.build((String)"conf/prerequestdefmanager.xml");
        if (resourceStorage.containsResource(path)) {
            DocStream docStream = resourceStorage.getResourceDocStream(path);
            Document document = DOMUtils.readDocument((DocStream)docStream);
            SimpleMessageHandler simpleHandler = new SimpleMessageHandler();
            PrerequestDefManagerDOMReader reader = new PrerequestDefManagerDOMReader((MessageHandler)simpleHandler);
            reader.updateManager(prerequestDefManager, document.getDocumentElement());
        }
    }

    public static void initTableDefConfig(ScarabeContext scarabeContext) {
        EditableResourceStorage resourceStorage = scarabeContext.getDataStorage();
        ConfigurationUtils.checkMigration(resourceStorage);
        ResourceFolder root = resourceStorage.getRoot();
        for (ResourceFolder subfolder : root.getSubfolderList()) {
            String name = subfolder.getName();
            if (!name.equals("tabledef")) continue;
            for (String resourceName : subfolder.getResourceNameList()) {
                if (!resourceName.endsWith(".txt")) continue;
                String tableDefName = resourceName.substring(0, resourceName.length() - 4);
                String content = ConfigurationUtils.getTableDefContent(scarabeContext, tableDefName);
                ConfigurationUtils.updateTableDefConfig(scarabeContext, tableDefName, content);
            }
        }
    }

    private static void checkMigration(EditableResourceStorage resourceStorage) {
        RelativePath path = ConfigurationUtils.buildTableDefContentPath("tabledef_ligne");
        RelativePath destination = ConfigurationUtils.buildTableDefContentPath("banque_general");
        if (resourceStorage.containsResource(path) && !resourceStorage.containsResource(destination)) {
            EditOrigin editOrigin = EditOriginUtils.newEditOrigin((String)"Migration");
            DocStream docStream = resourceStorage.getResourceDocStream(path);
            try (InputStream is = docStream.getInputStream();){
                resourceStorage.saveResource(destination, is, editOrigin);
            }
            catch (IOException ioe) {
                throw new BdfStorageException((Throwable)ioe);
            }
            resourceStorage.removeResource(path, editOrigin);
        }
    }

    public static void updateTableDefConfig(ScarabeContext scarabeContext, String tableDefName, String content) {
        SimpleLineMessageHandler lineMessageHandler = new SimpleLineMessageHandler();
        TableDef tableDef = TableDefParser.parse((String)content, (LineMessageHandler)lineMessageHandler, (int)0);
        InternalTableDefConfig tableDefConfig = new InternalTableDefConfig(tableDefName, tableDef, lineMessageHandler);
        scarabeContext.putContextObject(tableDefName, tableDefConfig);
    }

    public static TableDefConfig getTableDefConfig(ScarabeContext scarabeContext, String tableDefName) {
        return (TableDefConfig)scarabeContext.getContextObject(tableDefName);
    }

    public static String getTableDefContent(ScarabeContext scarabeContext, String tableDefName) {
        String result;
        RelativePath path;
        EditableResourceStorage resourceStorage = scarabeContext.getDataStorage();
        try {
            path = ConfigurationUtils.buildTableDefContentPath(tableDefName);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        if (!resourceStorage.containsResource(path)) {
            return null;
        }
        DocStream docStream = resourceStorage.getResourceDocStream(path);
        try (InputStream is = docStream.getInputStream();){
            result = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (IOException ioe) {
            throw new BdfStorageException((Throwable)ioe);
        }
        return result;
    }

    public static void saveTableDefContent(ScarabeContext scarabeContext, String tableDefName, String content, EditOrigin editOrigin) {
        RelativePath path;
        EditableResourceStorage resourceStorage = scarabeContext.getDataStorage();
        try {
            path = ConfigurationUtils.buildTableDefContentPath(tableDefName);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        try {
            InputStream inputStream = IOUtils.toInputStream((String)content, (String)"UTF-8");
            resourceStorage.saveResource(path, inputStream, editOrigin);
        }
        catch (IOException ioe) {
            throw new BdfStorageException((Throwable)ioe);
        }
    }

    public static void savePrerequestDefManager(ScarabeContext scarabeContext, EditOrigin editOrigin) {
        PrerequestDefManager prerequestDefManager = (PrerequestDefManager)scarabeContext.getContextObject("PREREQUESTDEF_MANAGER");
        EditableResourceStorage resourceStorage = scarabeContext.getDataStorage();
        RelativePath path = RelativePath.build((String)"conf/prerequestdefmanager.xml");
        StringBuilder buf = new StringBuilder();
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter((Appendable)buf);
        PrerequestDefManagerXMLWriter managerWriter = new PrerequestDefManagerXMLWriter((XMLWriter)xmlWriter);
        try {
            XMLUtils.appendXmlDeclaration((AppendableXMLWriter)xmlWriter);
            managerWriter.appendPrerequestDefManager(prerequestDefManager);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            InputStream inputStream = IOUtils.toInputStream((String)buf.toString(), (String)"UTF-8");
            resourceStorage.saveResource(path, inputStream, editOrigin);
        }
        catch (IOException ioe) {
            throw new BdfStorageException((Throwable)ioe);
        }
    }

    private static RelativePath buildTableDefContentPath(String colDefType) {
        return RelativePath.build((String)("tabledef/" + colDefType + ".txt"));
    }

    private static class InternalTableDefConfig
    implements TableDefConfig {
        private final String name;
        private final TableDef tableDef;
        private final SimpleLineMessageHandler lineMessageHandler;

        private InternalTableDefConfig(String name, TableDef tableDef, SimpleLineMessageHandler lineMessageHandler) {
            this.name = name;
            this.tableDef = tableDef;
            this.lineMessageHandler = lineMessageHandler;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TableDef getTableDef() {
            return this.tableDef;
        }

        @Override
        public boolean hasErrorsOrWarnings() {
            return this.lineMessageHandler.hasMessage();
        }

        @Override
        public List<MessageByLine> getMessageByLineList() {
            return this.lineMessageHandler.toMessageByLineList();
        }
    }
}

