/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen.writers;

import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenWriter;
import fr.exemole.bdfext.scarabe.api.comptagen.Compte;
import fr.exemole.bdfext.scarabe.api.comptagen.Journal;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import java.io.IOException;
import net.fichotheque.alias.AliasHolder;
import net.mapeadores.util.money.MoneyLong;
import net.mapeadores.util.primitives.FuzzyDate;

public class FecComptagenWriter
implements ComptagenWriter {
    private static final String[] COLUMN_ARRAY = new String[]{"JournalCode", "JournalLib", "EcritureNum", "EcritureDate", "CompteNum", "CompteLib", "CompAuxNum", "CompAuxLib", "PieceRef", "PieceDate", "EcritureLib", "Debit", "Credit", "EcritureLet", "DateLet", "ValidDate", "Montantdevise", "Idevise"};
    private final Appendable appendable;
    private final AliasHolder coreAliasHolder;
    private final int exportFractionDigits;
    private final int maxLength = 60;

    public FecComptagenWriter(Appendable appendable, AliasHolder coreAliasHolder, int exportFractionDigits) {
        this.appendable = appendable;
        this.coreAliasHolder = coreAliasHolder;
        this.exportFractionDigits = exportFractionDigits;
    }

    @Override
    public String getExtension() {
        return ".txt";
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public void writeColumns() throws IOException {
        boolean next = false;
        for (String column : COLUMN_ARRAY) {
            if (next) {
                this.next(column);
                continue;
            }
            this.first(column);
            next = true;
        }
        this.appendable.append("\n");
    }

    @Override
    public void writeLigne(ComptagenLigne ligne) throws IOException {
        Journal journal = ligne.getJournal();
        String date = FecComptagenWriter.toFecFormat(ligne.getDate());
        String libelle = ComptagenUtils.getShortTitle(ligne, 60);
        String montant = MoneyLong.toString((long)ligne.getExportMoneyLong(), (int)this.exportFractionDigits);
        String ecritureNum = String.valueOf(ligne.getEcritureNum());
        montant = montant.replace('.', ',');
        boolean isDebit = ligne.isDebit();
        this.first(journal);
        this.next(ecritureNum);
        this.next(date);
        this.addCompte(ligne.getCompte());
        this.addCompte(ligne.getCompteTiers());
        this.next(ligne.getPieceRef());
        this.next(date);
        this.next(libelle);
        this.appendMontant(isDebit, montant);
        this.nextEmpty(2);
        this.next(date);
        this.nextEmpty(2);
        this.appendable.append("\n");
        Compte contrepartie = ligne.getContrepartie();
        if (contrepartie != null) {
            this.first(journal);
            this.next(ecritureNum);
            this.next(date);
            this.addCompte(contrepartie);
            this.nextEmpty(2);
            this.next(ligne.getPieceRef());
            this.next(date);
            this.next(libelle);
            this.appendMontant(!isDebit, montant);
            this.nextEmpty(2);
            this.next(date);
            this.nextEmpty(2);
            this.appendable.append("\n");
        }
    }

    private void first(String s) throws IOException {
        this.appendable.append(s);
    }

    private void first(Journal journal) throws IOException {
        this.first(journal.getCode());
        this.next(journal.getLibelle());
    }

    private void next(String s) throws IOException {
        this.appendable.append('\t');
        this.appendable.append(s);
    }

    private void nextEmpty() throws IOException {
        this.appendable.append('\t');
    }

    private void nextEmpty(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.nextEmpty();
        }
    }

    private void addCompte(Compte compte) throws IOException {
        if (compte == null) {
            this.nextEmpty();
            this.nextEmpty();
        } else {
            this.next(compte.getNumero());
            this.next(compte.getLibelle());
        }
    }

    private void appendMontant(boolean isDebit, String montant) throws IOException {
        if (isDebit) {
            this.next(montant);
            this.next("0");
        } else {
            this.next("0");
            this.next(montant);
        }
    }

    private static String toFecFormat(FuzzyDate date) {
        String dateiso = date.toISOString();
        return dateiso.replace("-", "");
    }
}

