/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen;

import fr.exemole.bdfext.scarabe.ScarabeSpace;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenInfo;
import fr.exemole.bdfext.scarabe.api.comptagen.Compte;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.localisation.Lang;

public class ComptagenInfoBuilder {
    private ComptagenInfoBuilder() {
    }

    public static ComptagenInfo build(AliasHolder coreAliasHolder, AliasHolder comptagenAliasHolder, Lang lang) {
        HashMap<String, Compte> contrepartieMap = new HashMap<String, Compte>();
        Corpus banqueCorpus = coreAliasHolder.getCorpus("banque");
        Thesaurus banqueThesaurus = coreAliasHolder.getThesaurus("banque");
        Thesaurus plancomptable = comptagenAliasHolder.getThesaurus("plancomptable");
        FichePointeur banquePointeur = PointeurFactory.newFichePointeur((Corpus)banqueCorpus);
        for (FicheMeta banque : banqueCorpus.getFicheMetaList()) {
            Motcle banqueMotcle = banqueThesaurus.getMotcleById(banque.getId());
            String idalpha = banqueMotcle.getIdalpha();
            boolean withoutContrepartie = ScarabeSpace.isWithoutContrepartie((SubsetItem)banqueMotcle);
            if (withoutContrepartie) continue;
            banquePointeur.setCurrentSubsetItem((SubsetItem)banque);
            Croisements planCroisements = banquePointeur.getCroisements((Subset)plancomptable);
            Motcle motcle = (Motcle)planCroisements.getFirstSubsetItem();
            if (motcle == null) continue;
            Compte compte = ComptagenUtils.toCompte(motcle, lang);
            contrepartieMap.put(idalpha, compte);
        }
        return new InternalComptagenInfo(contrepartieMap);
    }

    private static class InternalComptagenInfo
    implements ComptagenInfo {
        private final Map<String, Compte> contrepartieMap;

        private InternalComptagenInfo(Map<String, Compte> contrepartieMap) {
            this.contrepartieMap = contrepartieMap;
        }

        @Override
        public Compte getContrepartie(String banqueIdalpha) {
            return this.contrepartieMap.get(banqueIdalpha);
        }

        @Override
        public boolean isContrepartie(String compteIdalpha) {
            for (Compte contrepartie : this.contrepartieMap.values()) {
                if (!contrepartie.getNumero().equals(compteIdalpha)) continue;
                return true;
            }
            return false;
        }
    }
}

