/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatUnit;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItemEligibility;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.AvenirDetail;
import fr.exemole.bdfext.scarabe.api.analytique.GroupbyDef;
import fr.exemole.bdfext.scarabe.api.analytique.LigneDetail;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyChronology;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.Prerequest;
import fr.exemole.bdfext.scarabe.api.analytique.PrerequestDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeOperand;
import fr.exemole.bdfext.scarabe.api.analytique.TableaucroiseDef;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueDefDOMReader;
import fr.exemole.bdfext.scarabe.tools.analytique.CustomLigneDefBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.PrerequestDefManagerDOMReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyConversion;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class AnalytiqueUtils {
    public static final AnalytiqueDef DEFAULT_ANALYTIQUEDEF = new DefaultAnalytiqueDef();
    public static final AnalytiqueItemEligibility ALL_ANALYTIQUEITEMELIGIBILITY = new AllAnalytiqueItemEligibility();
    public static final List<PrerequestDef> EMPTY_PREREQUESTDEFLIST = Collections.emptyList();
    public static final MoneyByCurrency EMPTY_MONEYBYCURRENCY = new EmptyMoneyByCurrency();
    public static final List<AnalytiqueSubset> EMPTY_ANALYTIQUESUBSETLIST = Collections.emptyList();
    public static final List<AnalytiqueItem> EMPTY_ANALYTIQUEITEMLIST2 = Collections.emptyList();
    public static final List<SoldeOperand> EMPTY_SOLDEOPERANDLIST = Collections.emptyList();
    public static final List<OperationDef> EMPTY_OPERATIONDEFLIST = Collections.emptyList();
    public static final List<TableaucroiseDef> EMPTY_TABLEAUCROISEDEFLIST = Collections.emptyList();
    public static final List<AnalytiqueGathering.SubCorpus> EMPTY_SUBCORPUSLIST = Collections.emptyList();
    public static final List<AnalytiqueGathering.Groupby> EMPTY_GROUPBYLIST = Collections.emptyList();
    public static final List<AnalytiqueItem> EMPTY_ANALYTIQUEITEMLIST = Collections.emptyList();
    public static final List<Recapitulatif.Annee> EMPTY_ANNEELIST = Collections.emptyList();
    public static final AgregatGathering EMPTY_AGREGATGATHERING = new EmptyAgregatGathering();

    private AnalytiqueUtils() {
    }

    public static void addError(MessageHandler messageHandler, String messageKey, Object ... messageValues) {
        messageHandler.addMessage("severe.scarabe", LocalisationUtils.toMessage((String)messageKey, (Object[])messageValues));
    }

    public static void addWarning(MessageHandler messageHandler, String messageKey, Object ... messageValues) {
        messageHandler.addMessage("warning.scarabe", LocalisationUtils.toMessage((String)messageKey, (Object[])messageValues));
    }

    public static List<AnalytiqueItem> toAnalytiqueItemList(Collection<AnalytiqueItem> analytiqueItems) {
        if (analytiqueItems == null || analytiqueItems.isEmpty()) {
            return EMPTY_ANALYTIQUEITEMLIST;
        }
        return AnalytiqueUtils.wrap(analytiqueItems.toArray(new AnalytiqueItem[analytiqueItems.size()]));
    }

    public static Document toDocument(String s, MessageHandler messageHandler) {
        s = "<root>\n" + s + "\n</root>";
        try {
            return DOMUtils.parseDocument((String)s);
        }
        catch (SAXException saxe) {
            AnalytiqueUtils.addError(messageHandler, "_ error.exception.xml.sax", saxe.getMessage());
            return null;
        }
    }

    public static AnalytiqueDef parseAnalytiqueDef(Subset subset, String s, MessageHandler messageHandler) {
        s = "<root>\n" + s + "\n</root>";
        try {
            Document document = DOMUtils.parseDocument((String)s);
            return AnalytiqueDefDOMReader.init(subset, messageHandler).read(document.getDocumentElement());
        }
        catch (SAXException saxe) {
            AnalytiqueUtils.addError(messageHandler, "_ error.exception.xml.sax", saxe.getMessage());
            return DEFAULT_ANALYTIQUEDEF;
        }
    }

    public static List<PrerequestDef> parsePrerequestDefList(String s, MessageHandler messageHandler) {
        s = "<root>\n" + s + "\n</root>";
        try {
            Document document = DOMUtils.parseDocument((String)s);
            PrerequestDefManagerDOMReader reader = new PrerequestDefManagerDOMReader(messageHandler);
            return reader.readPrerequestDefList(document.getDocumentElement());
        }
        catch (SAXException saxe) {
            AnalytiqueUtils.addError(messageHandler, "_ error.exception.xml.sax", saxe.getMessage());
            return EMPTY_PREREQUESTDEFLIST;
        }
    }

    public static List<PrerequestDef> toPrerequestDefList(Collection<PrerequestDef> prerequestDefs) {
        int size = prerequestDefs.size();
        if (size == 0) {
            return EMPTY_PREREQUESTDEFLIST;
        }
        return AnalytiqueUtils.wrap(prerequestDefs.toArray(new PrerequestDef[size]));
    }

    public static LigneDetail toLigneDetail(Ligne ligne, MoneyByCurrency moneyByCurrency) {
        return new InternalLigneDetail(ligne, moneyByCurrency);
    }

    public static AvenirDetail toAvenirDetail(Avenir avenir, MoneyByCurrency moneyByCurrency) {
        return new InternalAvenirDetail(avenir, moneyByCurrency);
    }

    public static AnalytiqueItemEligibility toAnalytiqueItemEligibility(Set<Integer> set) {
        return new ExcludeAnalytiqueItemEligibility(set);
    }

    public static AnalytiqueItemEligibility buildAnalytiqueItemEligibility(AnalytiqueParameters analytiqueParameters) {
        Set<Integer> excludeSet = analytiqueParameters.getExcludeIdSet();
        Set<Integer> includeSet = analytiqueParameters.getIncludeIdSet();
        int excludeSize = excludeSet.size();
        int includeSize = includeSet.size();
        if (excludeSize == 0 && includeSize == 0) {
            return ALL_ANALYTIQUEITEMELIGIBILITY;
        }
        if (excludeSize == 0) {
            return new IncludeAnalytiqueItemEligibility(includeSet);
        }
        if (includeSize == 0) {
            return new ExcludeAnalytiqueItemEligibility(excludeSet);
        }
        return new BothAnalytiqueItemEligibility(includeSet, excludeSet);
    }

    public static int useOwnLignes(AnalytiqueSubset analytiqueSubset, AnalytiqueItem analytiqueItem, AnalytiqueItemEligibility rootEligibility) {
        short eligibility = rootEligibility.accept(analytiqueItem);
        if (eligibility == 1) {
            return -1;
        }
        boolean withList = false;
        if (eligibility == 2) {
            AnalytiqueItem parent = analytiqueSubset.getParent(analytiqueItem.getSubsetItem().getId());
            boolean yes = false;
            while (parent != null) {
                if (rootEligibility.accept(parent) == 3) {
                    yes = true;
                    break;
                }
                parent = analytiqueSubset.getParent(parent.getSubsetItem().getId());
            }
            if (yes) {
                withList = true;
            }
        } else {
            withList = true;
        }
        if (withList) {
            return 1;
        }
        return 0;
    }

    public static String getLibelleKey(String ligneName) {
        switch (ligneName) {
            case "_apport_": {
                return "_ label.scarabe.apports";
            }
            case "_depense_": {
                return "_ label.scarabe.depenses";
            }
            case "_avance_": {
                return "_ label.scarabe.avances_nonsoldees";
            }
            case "_avenir_depense_": {
                return "_ label.scarabe.depenses_avenir";
            }
        }
        throw new SwitchException("Unknown specialName : " + ligneName);
    }

    public static boolean isSpecialLigne(String specialName) {
        switch (specialName) {
            case "_apport_": 
            case "_depense_": 
            case "_avance_": 
            case "_avenir_depense_": {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpecialOperand(String specialName) {
        switch (specialName) {
            case "_lignes_": 
            case "_avenir_": 
            case "_apport_": 
            case "_depense_": 
            case "_avance_": 
            case "_avenir_depense_": {
                return true;
            }
        }
        return false;
    }

    public static long convert(CoursManager coursManager, ExtendedCurrency pivotCurrency, Ligne ligne) {
        Long pivot = ligne.getPivotMoneyLong(pivotCurrency);
        if (pivot != null) {
            return pivot;
        }
        FuzzyDate date = ligne.getDate();
        AvanceInfo avanceInfo = ligne.getAvanceInfo();
        if (avanceInfo != null) {
            date = avanceInfo.getAvanceDate();
        }
        long otherMoneyLong = ligne.getComputeMoneyLong();
        MoneyConversion moneyConversion = coursManager.getMoneyConversion(date, pivotCurrency, ligne.getMouvement().getCurrency());
        if (moneyConversion == null) {
            return 0L;
        }
        return moneyConversion.convertToPivot(otherMoneyLong);
    }

    public static long convert(CoursManager coursManager, ExtendedCurrency pivotCurrency, Avenir avenir) {
        long otherMoneyLong = avenir.getComputeMoneyLong();
        MoneyConversion moneyConversion = coursManager.getMoneyConversion(null, pivotCurrency, avenir.getMontant().getCurrency());
        if (moneyConversion == null) {
            return 0L;
        }
        return moneyConversion.convertToPivot(otherMoneyLong);
    }

    public static AgregatUnit toAgregatUnit(SubsetItem subsetItem, MoneyByCurrency moneyByCurrency) {
        return new InternalAgregatUnit(subsetItem, moneyByCurrency);
    }

    public static Prerequest toPrerequest(Subset subset, PrerequestDef prerequestDef) {
        HashSet<Integer> excludeSet = new HashSet<Integer>();
        for (Object excludeObj : prerequestDef.getExcludeList()) {
            Object obj = AnalytiqueUtils.checkId(subset, excludeObj);
            if (obj == null) continue;
            if (obj instanceof Integer) {
                excludeSet.add((Integer)obj);
                continue;
            }
            excludeSet.addAll((List)obj);
        }
        HashSet<Integer> includeSet = new HashSet<Integer>();
        for (Object includeObj : prerequestDef.getIncludeList()) {
            Object obj = AnalytiqueUtils.checkId(subset, includeObj);
            if (obj == null) continue;
            if (obj instanceof Integer) {
                includeSet.add((Integer)obj);
                continue;
            }
            includeSet.addAll((List)obj);
        }
        return new InternalPrerequest(prerequestDef, excludeSet, includeSet);
    }

    public static SoldeOperand toSoldeOperand(String name, int sign, boolean mandatory) {
        return new InternalSoldeOperand(name, sign, mandatory);
    }

    public static AnalytiqueGathering.SubCorpus toSubCorpus(FicheMeta ficheMeta, AnalytiqueGathering analytiqueGathering) {
        return new InternalSubCorpus(ficheMeta, analytiqueGathering);
    }

    public static AnalytiqueGathering.Groupby toGroupby(Motcle motcle, AnalytiqueGathering analytiqueGathering, Collection<AnalytiqueGathering.Groupby> children) {
        List<AnalytiqueGathering.Groupby> childList = AnalytiqueUtils.wrap(children.toArray(new AnalytiqueGathering.Groupby[children.size()]));
        return new InternalGroupby(motcle, analytiqueGathering, childList);
    }

    private static Object checkId(Subset subset, Object obj) {
        if (obj instanceof Integer) {
            if (subset.getSubsetItemById(((Integer)obj).intValue()) != null) {
                return obj;
            }
            return null;
        }
        if (obj instanceof String) {
            if (!(subset instanceof Thesaurus)) {
                return null;
            }
            String idalpha = (String)obj;
            Thesaurus thesaurus = (Thesaurus)subset;
            if (idalpha.endsWith("*")) {
                Set<Motcle> motcleSet = AnalytiqueUtils.filterThesaurus(thesaurus, idalpha.substring(0, idalpha.length() - 1));
                if (motcleSet.isEmpty()) {
                    return null;
                }
                ArrayList<Integer> idList = new ArrayList<Integer>();
                for (Motcle motcle : motcleSet) {
                    idList.add(motcle.getId());
                }
                return idList;
            }
            Motcle motcle = thesaurus.getMotcleByIdalpha(idalpha);
            if (motcle != null) {
                return motcle.getId();
            }
            return null;
        }
        return null;
    }

    private static Set<Motcle> filterThesaurus(Thesaurus thesaurus, String prefix) {
        HashSet<Motcle> motcleSet = new HashSet<Motcle>();
        for (Motcle motcle : thesaurus.getMotcleList()) {
            if (!motcle.getIdalpha().startsWith(prefix)) continue;
            motcleSet.add(motcle);
        }
        return motcleSet;
    }

    public static List<AnalytiqueSubset> wrap(AnalytiqueSubset[] array) {
        return new AnalytiqueSubsetList(array);
    }

    public static List<AnalytiqueItem> wrap(AnalytiqueItem[] array) {
        return new AnalytiqueItemList(array);
    }

    public static List<AnalytiqueDetail> wrap(AnalytiqueDetail[] array) {
        return new AnalytiqueDetailList(array);
    }

    public static List<LigneDetail> wrap(LigneDetail[] array) {
        return new LigneDetailList(array);
    }

    public static List<AgregatUnit> wrap(AgregatUnit[] array) {
        return new AgregatUnitList(array);
    }

    public static List<AvenirDetail> wrap(AvenirDetail[] array) {
        return new AvenirDetailList(array);
    }

    public static List<AnalytiqueRecap> wrap(AnalytiqueRecap[] array) {
        return new AnalytiqueRecapList(array);
    }

    public static List<Operation> wrap(Operation[] array) {
        return new OperationList(array);
    }

    public static List<AgregatDef.ParentageDef> wrap(AgregatDef.ParentageDef[] array) {
        return new ParentageDefList(array);
    }

    public static List<AgregatDef.CroisementDef> wrap(AgregatDef.CroisementDef[] array) {
        return new CroisementDefList(array);
    }

    public static List<SoldeOperand> wrap(SoldeOperand[] array) {
        return new SoldeOperandList(array);
    }

    public static List<PrerequestDef> wrap(PrerequestDef[] array) {
        return new PrerequestDefList(array);
    }

    public static List<Prerequest> wrap(Prerequest[] array) {
        return new PrerequestList(array);
    }

    public static List<OperationDef> wrap(OperationDef[] array) {
        return new OperationDefList(array);
    }

    public static List<TableaucroiseDef> wrap(TableaucroiseDef[] array) {
        return new TableaucroiseDefList(array);
    }

    public static List<AnalytiqueGathering.Groupby> wrap(AnalytiqueGathering.Groupby[] array) {
        return new GroupbyList(array);
    }

    public static List<AnalytiqueGathering.SubCorpus> wrap(AnalytiqueGathering.SubCorpus[] array) {
        return new SubCorpusList(array);
    }

    public static List<Recapitulatif.Annee> wrap(Recapitulatif.Annee[] array) {
        return new AnneeList(array);
    }

    public static List<Recapitulatif.Mois> wrap(Recapitulatif.Mois[] array) {
        return new MoisList(array);
    }

    public static List<Recapitulatif.Jour> wrap(Recapitulatif.Jour[] array) {
        return new JourList(array);
    }

    public static List<MoneyChronology.Year> wrap(MoneyChronology.Year[] array) {
        return new YearList(array);
    }

    public static List<MoneyChronology.Month> wrap(MoneyChronology.Month[] array) {
        return new MonthList(array);
    }

    private static class InternalLigneDetail
    implements LigneDetail {
        private final Ligne ligne;
        private final MoneyByCurrency moneyByCurrency;

        private InternalLigneDetail(Ligne ligne, MoneyByCurrency moneyByCurrency) {
            this.ligne = ligne;
            this.moneyByCurrency = moneyByCurrency;
        }

        @Override
        public Ligne getLigne() {
            return this.ligne;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }
    }

    private static class InternalAvenirDetail
    implements AvenirDetail {
        private final Avenir avenir;
        private final MoneyByCurrency moneyByCurrency;

        private InternalAvenirDetail(Avenir avenir, MoneyByCurrency moneyByCurrency) {
            this.avenir = avenir;
            this.moneyByCurrency = moneyByCurrency;
        }

        @Override
        public Avenir getAvenir() {
            return this.avenir;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }
    }

    private static class ExcludeAnalytiqueItemEligibility
    implements AnalytiqueItemEligibility {
        private final Set<Integer> excludeSet;

        private ExcludeAnalytiqueItemEligibility(Set<Integer> excludeSet) {
            this.excludeSet = excludeSet;
        }

        @Override
        public short accept(AnalytiqueItem analytiqueItem) {
            int id = analytiqueItem.getSubsetItem().getId();
            if (this.excludeSet.contains(id)) {
                return 1;
            }
            return 3;
        }

        @Override
        public AnalytiqueItemEligibility getChildrenDerivation() {
            return this;
        }
    }

    private static class IncludeAnalytiqueItemEligibility
    implements AnalytiqueItemEligibility {
        private final Set<Integer> includeSet;

        private IncludeAnalytiqueItemEligibility(Set<Integer> includeSet) {
            this.includeSet = includeSet;
        }

        @Override
        public short accept(AnalytiqueItem analytiqueItem) {
            int id = analytiqueItem.getSubsetItem().getId();
            if (this.includeSet.contains(id)) {
                return 3;
            }
            return 2;
        }

        @Override
        public AnalytiqueItemEligibility getChildrenDerivation() {
            return ALL_ANALYTIQUEITEMELIGIBILITY;
        }
    }

    private static class BothAnalytiqueItemEligibility
    implements AnalytiqueItemEligibility {
        private final Set<Integer> includeSet;
        private final Set<Integer> excludeSet;
        private final ExcludeAnalytiqueItemEligibility excludeAnalytiqueItemEligibility;

        private BothAnalytiqueItemEligibility(Set<Integer> includeSet, Set<Integer> excludeSet) {
            this.includeSet = includeSet;
            this.excludeSet = excludeSet;
            this.excludeAnalytiqueItemEligibility = new ExcludeAnalytiqueItemEligibility(excludeSet);
        }

        @Override
        public short accept(AnalytiqueItem analytiqueItem) {
            int id = analytiqueItem.getSubsetItem().getId();
            if (this.excludeSet.contains(id)) {
                return 1;
            }
            if (this.includeSet.contains(id)) {
                return 3;
            }
            return 2;
        }

        @Override
        public AnalytiqueItemEligibility getChildrenDerivation() {
            return this.excludeAnalytiqueItemEligibility;
        }
    }

    private static class InternalAgregatUnit
    implements AgregatUnit {
        private final SubsetItem subsetItem;
        private final MoneyByCurrency moneyByCurrency;

        private InternalAgregatUnit(SubsetItem subsetItem, MoneyByCurrency moneyByCurrency) {
            this.subsetItem = subsetItem;
            this.moneyByCurrency = moneyByCurrency;
        }

        @Override
        public SubsetItem getSubsetItem() {
            return this.subsetItem;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }
    }

    private static class InternalPrerequest
    implements Prerequest {
        private final PrerequestDef prerequestDef;
        private final Set<Integer> excludeIdSet;
        private final Set<Integer> includeIdSet;

        private InternalPrerequest(PrerequestDef prerequestDef, Set<Integer> excludeIdSet, Set<Integer> includeIdSet) {
            this.prerequestDef = prerequestDef;
            this.excludeIdSet = excludeIdSet;
            this.includeIdSet = includeIdSet;
        }

        @Override
        public PrerequestDef getPrerequestDef() {
            return this.prerequestDef;
        }

        @Override
        public Set<Integer> getExcludeIdSet() {
            return this.excludeIdSet;
        }

        @Override
        public Set<Integer> getIncludeIdSet() {
            return this.includeIdSet;
        }
    }

    private static class InternalSoldeOperand
    implements SoldeOperand {
        private final String name;
        private final int sign;
        private final boolean mandatory;

        private InternalSoldeOperand(String name, int sign, boolean mandatory) {
            this.name = name;
            this.sign = sign;
            this.mandatory = mandatory;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getSign() {
            return this.sign;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }
    }

    private static class InternalSubCorpus
    implements AnalytiqueGathering.SubCorpus {
        private final FicheMeta ficheMeta;
        private final AnalytiqueGathering analytiqueGathering;

        private InternalSubCorpus(FicheMeta ficheMeta, AnalytiqueGathering analytiqueGathering) {
            this.ficheMeta = ficheMeta;
            this.analytiqueGathering = analytiqueGathering;
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public List<Ligne> getDepenseList() {
            return this.analytiqueGathering.getDepenseList();
        }

        @Override
        public List<Ligne> getApportList() {
            return this.analytiqueGathering.getApportList();
        }

        @Override
        public List<Ligne> getAvanceList() {
            return this.analytiqueGathering.getAvanceList();
        }

        @Override
        public List<Ligne> getSoldeAvanceList() {
            return this.analytiqueGathering.getSoldeAvanceList();
        }

        @Override
        public List<Avenir> getDepenseAvenirList() {
            return this.analytiqueGathering.getDepenseAvenirList();
        }

        @Override
        public boolean hasWarning() {
            return this.analytiqueGathering.hasWarning();
        }

        @Override
        public List<Message> getWarningList() {
            return this.analytiqueGathering.getWarningList();
        }

        @Override
        public AgregatGathering getAgregatGathering(int operationIndex) {
            return this.analytiqueGathering.getAgregatGathering(operationIndex);
        }
    }

    private static class InternalGroupby
    implements AnalytiqueGathering.Groupby {
        private final Motcle motcle;
        private final AnalytiqueGathering analytiqueGathering;
        private final List<AnalytiqueGathering.Groupby> childList;

        private InternalGroupby(Motcle motcle, AnalytiqueGathering analytiqueGathering, List<AnalytiqueGathering.Groupby> childList) {
            this.motcle = motcle;
            this.analytiqueGathering = analytiqueGathering;
            this.childList = childList;
        }

        @Override
        public Motcle getMotcle() {
            return this.motcle;
        }

        @Override
        public List<Ligne> getDepenseList() {
            return this.analytiqueGathering.getDepenseList();
        }

        @Override
        public List<Ligne> getApportList() {
            return this.analytiqueGathering.getApportList();
        }

        @Override
        public List<Ligne> getAvanceList() {
            return this.analytiqueGathering.getAvanceList();
        }

        @Override
        public List<Ligne> getSoldeAvanceList() {
            return this.analytiqueGathering.getSoldeAvanceList();
        }

        @Override
        public List<Avenir> getDepenseAvenirList() {
            return this.analytiqueGathering.getDepenseAvenirList();
        }

        @Override
        public boolean hasWarning() {
            return this.analytiqueGathering.hasWarning();
        }

        @Override
        public List<Message> getWarningList() {
            return this.analytiqueGathering.getWarningList();
        }

        @Override
        public AgregatGathering getAgregatGathering(int operationIndex) {
            return this.analytiqueGathering.getAgregatGathering(operationIndex);
        }

        @Override
        public List<AnalytiqueGathering.Groupby> getChildList() {
            return this.childList;
        }
    }

    private static class AnalytiqueSubsetList
    extends AbstractList<AnalytiqueSubset>
    implements RandomAccess {
        private final AnalytiqueSubset[] array;

        private AnalytiqueSubsetList(AnalytiqueSubset[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueSubset get(int index) {
            return this.array[index];
        }
    }

    private static class AnalytiqueItemList
    extends AbstractList<AnalytiqueItem>
    implements RandomAccess {
        private final AnalytiqueItem[] array;

        private AnalytiqueItemList(AnalytiqueItem[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueItem get(int index) {
            return this.array[index];
        }
    }

    private static class AnalytiqueDetailList
    extends AbstractList<AnalytiqueDetail>
    implements RandomAccess {
        private final AnalytiqueDetail[] array;

        private AnalytiqueDetailList(AnalytiqueDetail[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueDetail get(int index) {
            return this.array[index];
        }
    }

    private static class LigneDetailList
    extends AbstractList<LigneDetail>
    implements RandomAccess {
        private final LigneDetail[] array;

        private LigneDetailList(LigneDetail[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public LigneDetail get(int index) {
            return this.array[index];
        }
    }

    private static class AgregatUnitList
    extends AbstractList<AgregatUnit>
    implements RandomAccess {
        private final AgregatUnit[] array;

        private AgregatUnitList(AgregatUnit[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AgregatUnit get(int index) {
            return this.array[index];
        }
    }

    private static class AvenirDetailList
    extends AbstractList<AvenirDetail>
    implements RandomAccess {
        private final AvenirDetail[] array;

        private AvenirDetailList(AvenirDetail[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AvenirDetail get(int index) {
            return this.array[index];
        }
    }

    private static class AnalytiqueRecapList
    extends AbstractList<AnalytiqueRecap>
    implements RandomAccess {
        private final AnalytiqueRecap[] array;

        private AnalytiqueRecapList(AnalytiqueRecap[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueRecap get(int index) {
            return this.array[index];
        }
    }

    private static class OperationList
    extends AbstractList<Operation>
    implements RandomAccess {
        private final Operation[] array;

        private OperationList(Operation[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Operation get(int index) {
            return this.array[index];
        }
    }

    private static class ParentageDefList
    extends AbstractList<AgregatDef.ParentageDef>
    implements RandomAccess {
        private final AgregatDef.ParentageDef[] array;

        private ParentageDefList(AgregatDef.ParentageDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AgregatDef.ParentageDef get(int index) {
            return this.array[index];
        }
    }

    private static class CroisementDefList
    extends AbstractList<AgregatDef.CroisementDef>
    implements RandomAccess {
        private final AgregatDef.CroisementDef[] array;

        private CroisementDefList(AgregatDef.CroisementDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AgregatDef.CroisementDef get(int index) {
            return this.array[index];
        }
    }

    private static class SoldeOperandList
    extends AbstractList<SoldeOperand>
    implements RandomAccess {
        private final SoldeOperand[] array;

        private SoldeOperandList(SoldeOperand[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SoldeOperand get(int index) {
            return this.array[index];
        }
    }

    private static class PrerequestDefList
    extends AbstractList<PrerequestDef>
    implements RandomAccess {
        private final PrerequestDef[] array;

        private PrerequestDefList(PrerequestDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public PrerequestDef get(int index) {
            return this.array[index];
        }
    }

    private static class PrerequestList
    extends AbstractList<Prerequest>
    implements RandomAccess {
        private final Prerequest[] array;

        private PrerequestList(Prerequest[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Prerequest get(int index) {
            return this.array[index];
        }
    }

    private static class OperationDefList
    extends AbstractList<OperationDef>
    implements RandomAccess {
        private final OperationDef[] array;

        private OperationDefList(OperationDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public OperationDef get(int index) {
            return this.array[index];
        }
    }

    private static class TableaucroiseDefList
    extends AbstractList<TableaucroiseDef>
    implements RandomAccess {
        private final TableaucroiseDef[] array;

        private TableaucroiseDefList(TableaucroiseDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TableaucroiseDef get(int index) {
            return this.array[index];
        }
    }

    private static class GroupbyList
    extends AbstractList<AnalytiqueGathering.Groupby>
    implements RandomAccess {
        private final AnalytiqueGathering.Groupby[] array;

        private GroupbyList(AnalytiqueGathering.Groupby[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueGathering.Groupby get(int index) {
            return this.array[index];
        }
    }

    private static class SubCorpusList
    extends AbstractList<AnalytiqueGathering.SubCorpus>
    implements RandomAccess {
        private final AnalytiqueGathering.SubCorpus[] array;

        private SubCorpusList(AnalytiqueGathering.SubCorpus[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AnalytiqueGathering.SubCorpus get(int index) {
            return this.array[index];
        }
    }

    private static class AnneeList
    extends AbstractList<Recapitulatif.Annee>
    implements RandomAccess {
        private final Recapitulatif.Annee[] array;

        private AnneeList(Recapitulatif.Annee[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Recapitulatif.Annee get(int index) {
            return this.array[index];
        }
    }

    private static class MoisList
    extends AbstractList<Recapitulatif.Mois>
    implements RandomAccess {
        private final Recapitulatif.Mois[] array;

        private MoisList(Recapitulatif.Mois[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Recapitulatif.Mois get(int index) {
            return this.array[index];
        }
    }

    private static class JourList
    extends AbstractList<Recapitulatif.Jour>
    implements RandomAccess {
        private final Recapitulatif.Jour[] array;

        private JourList(Recapitulatif.Jour[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Recapitulatif.Jour get(int index) {
            return this.array[index];
        }
    }

    private static class YearList
    extends AbstractList<MoneyChronology.Year>
    implements RandomAccess {
        private final MoneyChronology.Year[] array;

        private YearList(MoneyChronology.Year[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public MoneyChronology.Year get(int index) {
            return this.array[index];
        }
    }

    private static class MonthList
    extends AbstractList<MoneyChronology.Month>
    implements RandomAccess {
        private final MoneyChronology.Month[] array;

        private MonthList(MoneyChronology.Month[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public MoneyChronology.Month get(int index) {
            return this.array[index];
        }
    }

    private static class DefaultAnalytiqueDef
    implements AnalytiqueDef {
        private final List<OperationDef> defaultOperationDefList;

        private DefaultAnalytiqueDef() {
            OperationDef[] defaultOperationDefArray = new OperationDef[]{this.toOperationDef("_apport_"), this.toOperationDef("_depense_"), this.toOperationDef("_avance_"), this.toOperationDef("_avenir_depense_")};
            this.defaultOperationDefList = AnalytiqueUtils.wrap(defaultOperationDefArray);
        }

        @Override
        public List<IncludeKey> getSubIncludeKeyList() {
            return FichothequeUtils.EMPTY_INCLUDEKEYLIST;
        }

        @Override
        public List<OperationDef> getOperationDefList() {
            return this.defaultOperationDefList;
        }

        private OperationDef toOperationDef(String specialName) {
            CustomLigneDefBuilder builder = new CustomLigneDefBuilder(specialName);
            return builder.toCustomLigneDef();
        }

        @Override
        public List<TableaucroiseDef> getTableaucroiseDefList() {
            return EMPTY_TABLEAUCROISEDEFLIST;
        }

        @Override
        public GroupbyDef getGroupbyDef() {
            return null;
        }
    }

    private static class AllAnalytiqueItemEligibility
    implements AnalytiqueItemEligibility {
        private AllAnalytiqueItemEligibility() {
        }

        @Override
        public short accept(AnalytiqueItem analytiqueItem) {
            return 3;
        }

        @Override
        public AnalytiqueItemEligibility getChildrenDerivation() {
            return this;
        }
    }

    private static class EmptyMoneyByCurrency
    implements MoneyByCurrency {
        private EmptyMoneyByCurrency() {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean withMoney(int currencyIndex) {
            return false;
        }

        @Override
        public long getMoneyLong(int currencyIndex) {
            return 0L;
        }
    }

    private static class EmptyAgregatGathering
    implements AgregatGathering {
        private final List<AgregatUnit> emptyList = Collections.emptyList();

        private EmptyAgregatGathering() {
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return EMPTY_MONEYBYCURRENCY;
        }

        @Override
        public List<AgregatUnit> getUnitList() {
            return this.emptyList;
        }
    }
}

