/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.Prerequest;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.SimpleMessageHandler;

public class AnalytiqueSubsetBuilder {
    private final Subset subset;
    private final AnalytiqueDef analytiqueDef;
    private final List<Prerequest> prerequestList = new ArrayList<Prerequest>();
    private final List<AnalytiqueItem> firstLevelList = new ArrayList<AnalytiqueItem>();
    private final SimpleMessageHandler simpleHandler;

    public AnalytiqueSubsetBuilder(Subset subset, AnalytiqueDef analytiqueDef, SimpleMessageHandler simpleHandler) {
        this.subset = subset;
        this.analytiqueDef = analytiqueDef;
        this.simpleHandler = simpleHandler;
    }

    public void add(Prerequest prerequest) {
        this.prerequestList.add(prerequest);
    }

    public void add(AnalytiqueItem analytiqueItem) {
        this.firstLevelList.add(analytiqueItem);
    }

    public AnalytiqueSubset toAnalytiqueSubset() {
        List<Prerequest> finalPrerequestList = AnalytiqueUtils.wrap(this.prerequestList.toArray(new Prerequest[this.prerequestList.size()]));
        List<AnalytiqueItem> finalFirstLevelList = AnalytiqueUtils.toAnalytiqueItemList(this.firstLevelList);
        HashMap<Integer, AnalytiqueItem> itemMap = new HashMap<Integer, AnalytiqueItem>();
        HashMap<Integer, AnalytiqueItem> parentMap = new HashMap<Integer, AnalytiqueItem>();
        for (AnalytiqueItem analytiqueItem : this.firstLevelList) {
            itemMap.put(analytiqueItem.getSubsetItem().getId(), analytiqueItem);
            AnalytiqueSubsetBuilder.checkList(itemMap, analytiqueItem, parentMap);
        }
        List errorList = LocalisationUtils.EMPTY_MESSAGELIST;
        List warningList = LocalisationUtils.EMPTY_MESSAGELIST;
        if (this.simpleHandler.hasMessage()) {
            errorList = this.simpleHandler.filterSevere();
            warningList = this.simpleHandler.filterWarning();
        }
        InternalAnalytiqueSubset analytiqueSubset = new InternalAnalytiqueSubset(this.subset, this.analytiqueDef, finalPrerequestList, finalFirstLevelList, itemMap, parentMap, errorList, warningList);
        return analytiqueSubset;
    }

    private static void checkList(Map<Integer, AnalytiqueItem> itemMap, AnalytiqueItem parent, Map<Integer, AnalytiqueItem> parentMap) {
        for (AnalytiqueItem analytiqueItem : parent.getChildList()) {
            int id = analytiqueItem.getSubsetItem().getId();
            itemMap.put(id, analytiqueItem);
            parentMap.put(id, parent);
            AnalytiqueSubsetBuilder.checkList(itemMap, analytiqueItem, parentMap);
        }
    }

    private static class InternalAnalytiqueSubset
    implements AnalytiqueSubset {
        private final SubsetKey subsetKey;
        private final Subset subset;
        private final AnalytiqueDef analytiqueDef;
        private final List<Prerequest> prerequestList;
        private final List<AnalytiqueItem> firstLevelList;
        private final Map<Integer, AnalytiqueItem> itemMap;
        private final Map<Integer, AnalytiqueItem> parentMap;
        private final List<Message> errorList;
        private final List<Message> warningList;

        private InternalAnalytiqueSubset(Subset subset, AnalytiqueDef analytiqueDef, List<Prerequest> prerequestList, List<AnalytiqueItem> firstLevelList, Map<Integer, AnalytiqueItem> itemMap, Map<Integer, AnalytiqueItem> parentMap, List<Message> errorList, List<Message> warningList) {
            this.subset = subset;
            this.subsetKey = subset.getSubsetKey();
            this.analytiqueDef = analytiqueDef;
            this.prerequestList = prerequestList;
            this.firstLevelList = firstLevelList;
            this.itemMap = itemMap;
            this.errorList = errorList;
            this.warningList = warningList;
            this.parentMap = parentMap;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return this.subsetKey;
        }

        @Override
        public Subset getSubset() {
            return this.subset;
        }

        @Override
        public boolean hasError() {
            return !this.errorList.isEmpty();
        }

        @Override
        public List<Message> getErrorList() {
            return this.errorList;
        }

        @Override
        public boolean hasWarning() {
            return !this.warningList.isEmpty();
        }

        @Override
        public List<Message> getWarningList() {
            return this.warningList;
        }

        @Override
        public List<AnalytiqueItem> getFirstLevelList() {
            return this.firstLevelList;
        }

        @Override
        public AnalytiqueItem getAnalytiqueItem(int id) {
            return this.itemMap.get(id);
        }

        @Override
        public AnalytiqueItem getParent(int id) {
            return this.parentMap.get(id);
        }

        @Override
        public AnalytiqueDef getAnalytiqueDef() {
            return this.analytiqueDef;
        }

        @Override
        public List<Prerequest> getPrerequestList() {
            return this.prerequestList;
        }
    }
}

