/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueGatheringBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.mapeadores.util.localisation.Message;

public class AnalytiqueItemBuilder {
    private final SubsetItem subsetItem;
    private final List<AnalytiqueItem> childList = new ArrayList<AnalytiqueItem>();
    private final List<AnalytiqueGathering.SubCorpus> subCorpusList = new ArrayList<AnalytiqueGathering.SubCorpus>();
    private final List<AnalytiqueGathering.Groupby> groupbyList = new ArrayList<AnalytiqueGathering.Groupby>();
    private final AnalytiqueGatheringBuilder analytiqueGatheringBuilder;

    public AnalytiqueItemBuilder(SubsetItem subsetItem, AnalytiqueGatheringBuilder analytiqueGatheringBuilder) {
        this.subsetItem = subsetItem;
        this.analytiqueGatheringBuilder = analytiqueGatheringBuilder;
    }

    public void addChild(AnalytiqueItem analytiqueItem) {
        this.childList.add(analytiqueItem);
    }

    public void addSubCorpus(AnalytiqueGathering.SubCorpus subCorpus) {
        this.subCorpusList.add(subCorpus);
    }

    public void addGroupby(AnalytiqueGathering.Groupby groupby) {
        this.groupbyList.add(groupby);
    }

    public AnalytiqueItem toAnalytiqueItem() {
        List<AnalytiqueItem> finalChildList = this.childList.isEmpty() ? AnalytiqueUtils.EMPTY_ANALYTIQUEITEMLIST : AnalytiqueUtils.toAnalytiqueItemList(this.childList);
        List<AnalytiqueGathering.SubCorpus> finalSubCorpusList = this.subCorpusList.isEmpty() ? AnalytiqueUtils.EMPTY_SUBCORPUSLIST : AnalytiqueUtils.wrap(this.subCorpusList.toArray(new AnalytiqueGathering.SubCorpus[this.subCorpusList.size()]));
        List<AnalytiqueGathering.Groupby> finalGroupbyList = this.groupbyList.isEmpty() ? AnalytiqueUtils.EMPTY_GROUPBYLIST : AnalytiqueUtils.wrap(this.groupbyList.toArray(new AnalytiqueGathering.Groupby[this.groupbyList.size()]));
        InternalAnalytiqueItem result = new InternalAnalytiqueItem(this.subsetItem, this.analytiqueGatheringBuilder.toAnalytiqueGathering(), finalChildList, finalSubCorpusList, finalGroupbyList);
        return result;
    }

    private static class InternalAnalytiqueItem
    implements AnalytiqueItem {
        private final SubsetItem subsetItem;
        private final AnalytiqueGathering analytiqueGathering;
        private final List<AnalytiqueItem> childList;
        private final List<AnalytiqueGathering.SubCorpus> subCorpusList;
        private final List<AnalytiqueGathering.Groupby> groupbyList;

        private InternalAnalytiqueItem(SubsetItem subsetItem, AnalytiqueGathering analytiqueGathering, List<AnalytiqueItem> childList, List<AnalytiqueGathering.SubCorpus> subCorpusList, List<AnalytiqueGathering.Groupby> subgroupList) {
            this.subsetItem = subsetItem;
            this.analytiqueGathering = analytiqueGathering;
            this.childList = childList;
            this.subCorpusList = subCorpusList;
            this.groupbyList = subgroupList;
        }

        @Override
        public SubsetItem getSubsetItem() {
            return this.subsetItem;
        }

        @Override
        public List<AnalytiqueItem> getChildList() {
            return this.childList;
        }

        @Override
        public List<Ligne> getDepenseList() {
            return this.analytiqueGathering.getDepenseList();
        }

        @Override
        public List<Ligne> getApportList() {
            return this.analytiqueGathering.getApportList();
        }

        @Override
        public List<Ligne> getAvanceList() {
            return this.analytiqueGathering.getAvanceList();
        }

        @Override
        public List<Ligne> getSoldeAvanceList() {
            return this.analytiqueGathering.getSoldeAvanceList();
        }

        @Override
        public List<Avenir> getDepenseAvenirList() {
            return this.analytiqueGathering.getDepenseAvenirList();
        }

        @Override
        public boolean hasWarning() {
            return this.analytiqueGathering.hasWarning();
        }

        @Override
        public List<Message> getWarningList() {
            return this.analytiqueGathering.getWarningList();
        }

        @Override
        public AgregatGathering getAgregatGathering(int operationIndex) {
            return this.analytiqueGathering.getAgregatGathering(operationIndex);
        }

        @Override
        public List<AnalytiqueGathering.SubCorpus> getSubCorpusList() {
            return this.subCorpusList;
        }

        @Override
        public List<AnalytiqueGathering.Groupby> getGroupbyList() {
            return this.groupbyList;
        }
    }
}

