/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.LigneListsBuffer;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatGatheringBuilder;
import java.util.List;
import net.fichotheque.include.IncludeKey;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SimpleMessageHandler;

public class AnalytiqueGatheringBuilder
extends LigneListsBuffer {
    private static final short DEFAULT = 1;
    private static final short SUBCORPUS = 2;
    private static final short GROUPBY = 3;
    private static final AgregatGatheringBuilder[] EMPTY_ARRAY = new AgregatGatheringBuilder[0];
    private final AgregatGatheringBuilder[] agregatGatheringBuilderArray;
    private final short type;
    private final IncludeKey includeKey;
    private final SimpleMessageHandler simpleHandler = new SimpleMessageHandler();

    private AnalytiqueGatheringBuilder(short type, int operationLength, IncludeKey includeKey) {
        this.type = type;
        this.includeKey = includeKey;
        this.agregatGatheringBuilderArray = operationLength == 0 ? EMPTY_ARRAY : new AgregatGatheringBuilder[operationLength];
    }

    public boolean accept(AgregatDef agregatDef) {
        switch (agregatDef.getType()) {
            case 1: {
                return this.type == 1;
            }
            case 2: {
                if (this.type == 2) {
                    return agregatDef.getIncludeKey().equals((Object)this.includeKey);
                }
                return false;
            }
        }
        return false;
    }

    public MessageHandler getMessageHandler() {
        return this.simpleHandler;
    }

    public AgregatGatheringBuilder getAgregatGatheringBuilder(int operationIndex, int currencyLength) {
        AgregatGatheringBuilder builder = this.agregatGatheringBuilderArray[operationIndex];
        if (builder != null) {
            return builder;
        }
        this.agregatGatheringBuilderArray[operationIndex] = builder = new AgregatGatheringBuilder(currencyLength);
        return builder;
    }

    public AnalytiqueGathering toAnalytiqueGathering() {
        List warningList = this.simpleHandler.hasMessage() ? this.simpleHandler.filterWarning() : LocalisationUtils.EMPTY_MESSAGELIST;
        int operationLength = this.agregatGatheringBuilderArray.length;
        AgregatGathering[] result = new AgregatGathering[operationLength];
        for (int i = 0; i < operationLength; ++i) {
            AgregatGatheringBuilder builder = this.agregatGatheringBuilderArray[i];
            result[i] = builder != null ? builder.toAgregatGathering() : AnalytiqueUtils.EMPTY_AGREGATGATHERING;
        }
        return new InternalAnalytiqueGathering(this.toDepenseLigneList(), this.toApportLigneList(), this.toAvanceLigneList(), this.toSoldeAvanceLigneList(), this.toDepenseAvenirList(), warningList, result);
    }

    public static AnalytiqueGatheringBuilder buildForAnalytiqueItem(int operationDefLength) {
        return new AnalytiqueGatheringBuilder(1, operationDefLength, null);
    }

    public static AnalytiqueGatheringBuilder buildForSubCorpus(int operationDefLength, IncludeKey includeKey) {
        return new AnalytiqueGatheringBuilder(2, operationDefLength, includeKey);
    }

    public static AnalytiqueGatheringBuilder buildForGroupby(int operationDefLength, IncludeKey includeKey) {
        return new AnalytiqueGatheringBuilder(3, operationDefLength, includeKey);
    }

    private static class InternalAnalytiqueGathering
    implements AnalytiqueGathering {
        private final List<Ligne> depenseList;
        private final List<Ligne> apportList;
        private final List<Ligne> avanceList;
        private final List<Ligne> soldeAvanceList;
        private final List<Avenir> depenseAvenirList;
        private final List<Message> warningList;
        private final AgregatGathering[] agregatGatheringArray;

        private InternalAnalytiqueGathering(List<Ligne> depenseList, List<Ligne> apportList, List<Ligne> avanceList, List<Ligne> soldeAvanceList, List<Avenir> depenseAvenirList, List<Message> warningList, AgregatGathering[] agregatGatheringArray) {
            this.depenseList = depenseList;
            this.apportList = apportList;
            this.avanceList = avanceList;
            this.soldeAvanceList = soldeAvanceList;
            this.depenseAvenirList = depenseAvenirList;
            this.warningList = warningList;
            this.agregatGatheringArray = agregatGatheringArray;
        }

        @Override
        public List<Ligne> getDepenseList() {
            return this.depenseList;
        }

        @Override
        public List<Ligne> getApportList() {
            return this.apportList;
        }

        @Override
        public List<Ligne> getAvanceList() {
            return this.avanceList;
        }

        @Override
        public List<Ligne> getSoldeAvanceList() {
            return this.soldeAvanceList;
        }

        @Override
        public List<Avenir> getDepenseAvenirList() {
            return this.depenseAvenirList;
        }

        @Override
        public boolean hasWarning() {
            return !this.warningList.isEmpty();
        }

        @Override
        public List<Message> getWarningList() {
            return this.warningList;
        }

        @Override
        public AgregatGathering getAgregatGathering(int operationIndex) {
            return this.agregatGatheringArray[operationIndex];
        }
    }
}

