/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.stream;

import fr.exemole.bdfext.scarabe.tools.exportation.OdsTableOutput;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.opendocument.io.OdZip;
import net.mapeadores.opendocument.io.OdZipEngine;
import net.mapeadores.opendocument.io.SheetWriter;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.io.StreamProducer;

public class TableEngineOdsProducer
implements StreamProducer {
    private final String fileName;
    private final TableEngine tableEngine;
    private final SheetWriter supplementarySheetsWriter;

    public TableEngineOdsProducer(String fileName, TableEngine tableEngine, SheetWriter supplementarySheetWriter) {
        this.fileName = fileName;
        this.tableEngine = tableEngine;
        this.supplementarySheetsWriter = supplementarySheetWriter;
    }

    public String getMimeType() {
        return "application/vnd.oasis.opendocument.spreadsheet";
    }

    public String getCharset() {
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void writeStream(OutputStream outputStream) throws IOException {
        OdZipEngine.run((OutputStream)outputStream, (OdZip)OdZip.spreadSheet().stylesOdSource((OdSource)new StyleOdSource()).contentOdSource((OdSource)new ContentOdSource()));
    }

    private class StyleOdSource
    implements OdSource {
        private StyleOdSource() {
        }

        public void writeStream(OutputStream outputStream) throws IOException {
            try (InputStream is = OdsTableOutput.class.getResourceAsStream("styles.xml");){
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            }
        }
    }

    private class ContentOdSource
    implements OdSource {
        private ContentOdSource() {
        }

        public void writeStream(OutputStream outputStream) throws IOException {
            OdsTableOutput.write(outputStream, TableEngineOdsProducer.this.tableEngine, TableEngineOdsProducer.this.supplementarySheetsWriter);
        }
    }
}

