/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.consumers.SatelliteTree;
import fr.exemole.bdfserver.htmlproducers.main.FichesHtmlProducer;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;

public class OverrideFichesHtmlProducer
extends FichesHtmlProducer {
    private final ScarabeContext scarabeContext;
    private FichePointeur mouvementFichePointeur;
    private final Corpus mouvementCorpus;

    public OverrideFichesHtmlProducer(BdfParameters bdfParameters, Fiches fiches, ScarabeContext scarabeContext) {
        super(bdfParameters, fiches);
        this.scarabeContext = scarabeContext;
        this.mouvementCorpus = scarabeContext.getCoreAliasHolder().getCorpus("mouvement");
        this.addExtensionThemeCss("scarabe", new String[]{"_action.css", "fiches.css"});
    }

    protected boolean printSupplementaryDetails(FicheMeta ficheMeta) {
        if (!ficheMeta.getCorpus().equals(this.mouvementCorpus)) {
            return false;
        }
        if (this.mouvementFichePointeur == null) {
            this.mouvementFichePointeur = PointeurFactory.newFichePointeur((Corpus)this.mouvementCorpus);
        }
        this.mouvementFichePointeur.setCurrentSubsetItem((SubsetItem)ficheMeta);
        CoreUtils.Lists mouvement = CoreUtils.getLists(this.mouvementFichePointeur, this.scarabeContext.getCoreAliasHolder());
        this.DETAILS(HA.open((boolean)true).classes("tools-Details")).SUMMARY().__localize("_ title.scarabe.lignes")._SUMMARY().__(SatelliteTree.TREE, () -> {
            this.printLigneLeaves(mouvement.getAvanceList(), "_ label.scarabe.fiche_avance");
            this.printLigneLeaves(mouvement.getSoldeAvanceList(), "_ label.scarabe.fiche_avance_solde");
            this.printLigneLeaves(mouvement.getDepenseList(), "_ label.scarabe.fiche_depense");
            this.printLigneLeaves(mouvement.getApportList(), "_ label.scarabe.fiche_apport");
        })._DETAILS();
        return true;
    }

    protected boolean printSupplementaryCommands(FicheMeta ficheMeta) {
        if (!ficheMeta.getCorpus().equals(this.mouvementCorpus)) {
            return false;
        }
        this.__(this.printCommand((CharSequence)BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)ficheMeta), "action-scarabe-MouvementCheck", "_ link.scarabe.mouvementresult"));
        return true;
    }

    private boolean printLigneLeaves(List<FicheMeta> ficheMetaList, String messageKey) {
        for (FicheMeta ficheMeta : ficheMetaList) {
            this.__(SatelliteTree.LEAF, () -> this.SPAN("scarabe-fiches-LigneTitle").SPAN("scarabe-fiches-Type").__localize(messageKey).__colon()._SPAN().A(HA.href((CharSequence)BdfInstructionUtils.getFicheGetLink((FicheMeta)ficheMeta, (String)"html")).target("Edition").classes("scarabe-fiches-Link")).__escape((CharSequence)this.getTitre(ficheMeta))._A()._SPAN().__(ScarabeHtmlUtils.printEditButton((HtmlPrinter)this, ficheMeta)));
        }
        return true;
    }

    private String getTitre(FicheMeta ficheMeta) {
        String titre = ficheMeta.getTitre();
        if (titre.length() == 0) {
            return "__";
        }
        return titre;
    }
}

