/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeJsLibs;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.tools.core.MouvementBuilder;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Tree;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlUtils;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHandler;
import fr.exemole.bdfserver.tools.BH;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.DateFormatBundle;

public class MouvementFicheResultHtmlProducer
extends BdfServerHtmlProducer {
    private static final HtmlWrapper INFO_BRANCH = Tree.branch((String)"scarabe-MouvementBranch");
    private static final HtmlWrapper INFO_LEAF = Tree.leaf((String)"scarabe-MouvementLeaf");
    private static final HtmlWrapper INFO_TREE = Tree.tree((String)"scarabe-MouvementTree");
    private static final String IFRAME_NAME = "_InternalFrame";
    private final FicheResultHandler ficheResultHandler;
    private final ScarabeContext scarabeContext;
    private final Mouvement mouvement;
    private final DecimalFormatSymbols symbols;

    public MouvementFicheResultHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext, FicheResultHandler ficheResultHandler) {
        super(bdfParameters);
        this.ficheResultHandler = ficheResultHandler;
        this.scarabeContext = scarabeContext;
        this.mouvement = MouvementBuilder.build(ficheResultHandler.getFicheMeta(), scarabeContext);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(ScarabeJsLibs.MOUVEMENTPAGE);
        this.addJsLib(BdfJsLibs.SHORTCUT_INIT);
        this.addJsLib(FicheJsLibs.FICHEFRAME_INIT);
        this.addThemeCss(new String[]{"edition.css"});
        this.addExtensionThemeCss("scarabe", new String[]{"mouvement-result.css"});
        this.symbols = new DecimalFormatSymbols(this.getFormatLocale());
    }

    public void printHtml() {
        String fichePath = this.ficheResultHandler.getFicheLink("html");
        this.startLoc("_ label.scarabe.fiche_mouvement", true);
        this.SCRIPT().__jsObject("var", "RESULT_ITEM", this.ficheResultHandler.getResultItemObject()).__jsObject("Ficheframe.ARGS", this.ficheResultHandler.getFicheframeArgsObject())._SCRIPT();
        this.DIV("edition-Page edition-result-Page").__(EditionHtmlUtils.printFicheframeFieldedit((HtmlPrinter)this)).__(this.printMouvementInfo()).NAV("edition-Toolbar").__(this.printToolbar()).__(EditionHtmlUtils.printFicheframeToolbar((HtmlPrinter)this))._NAV().IFRAME(HA.name((String)"ficheframe").src((CharSequence)fichePath).name(IFRAME_NAME).classes("edition-Unit").attr("data-ficheframe-role", "iframe")).P().A(HA.href((CharSequence)fichePath)).__localize("_ link.fiches.fiche_long")._A()._P()._IFRAME()._DIV();
        this.end();
    }

    private boolean printMouvementInfo() {
        this.DIV("unit-SimpleUnit scarabe-MouvementInfo").__(this.printCommandMessage()).__(INFO_TREE, () -> this.__(Tree.NODE, () -> this.DETAILS(HA.open((boolean)true)).__(this.printMouvementSummary()).__(INFO_BRANCH, () -> this.__(this.printError()).__(this.printMontant()).__(this.printFichesLiees(this.mouvement.getAvanceList(), "_ label.scarabe.fiche_avance")).__(this.printFichesLiees(this.mouvement.getSoldeAvanceList(), "_ label.scarabe.fiche_avance_solde")).__(this.printFichesLiees(this.mouvement.getDepenseList(), "_ label.scarabe.fiche_depense")).__(this.printFichesLiees(this.mouvement.getApportList(), "_ label.scarabe.fiche_apport")).__(this.printReste()))._DETAILS()))._DIV();
        return true;
    }

    private boolean printMouvementSummary() {
        int piece = this.mouvement.getNumeropiece();
        this.SUMMARY().__localize("_ label.scarabe.numeropiece").__colon();
        if (piece == -1) {
            this.__escape('?');
        } else {
            this.__append(piece);
        }
        this.__dash().__localize("_ label.scarabe.date").__colon();
        FuzzyDate date = this.mouvement.getDate();
        if (date == null) {
            this.__escape("?");
        } else {
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle((Locale)this.getFormatLocale());
            this.__escape(date.getDateLitteral(dateFormatBundle));
        }
        this.__dash().__localize("_ label.scarabe.libelle").__colon().__escape((CharSequence)this.mouvement.getLibelle())._SUMMARY();
        return true;
    }

    private boolean printError() {
        if (!this.mouvement.hasError()) {
            return false;
        }
        this.__(Tree.NODE, () -> this.DETAILS(HA.open((boolean)true).classes("global-WarningMessage")).SUMMARY().__localize("_ error.list.scarabe.mouvement").__colon()._SUMMARY().__(INFO_BRANCH, () -> {
            for (Message errorMessage : this.mouvement.getErrorMessageList()) {
                this.__(Tree.LEAF, () -> this.__localize(errorMessage));
            }
        }));
        return true;
    }

    private boolean printMontant() {
        Montant montant = this.mouvement.getMontant();
        if (montant == null) {
            return false;
        }
        this.__(INFO_LEAF, () -> this.__localize("_ label.scarabe.rappelmontant").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((Decimal)montant.getDecimal(), (ExtendedCurrency)montant.getCurrency(), (DecimalFormatSymbols)this.symbols)).__space().__escape('(').__localize(this.mouvement.isDebit() ? "_ label.scarabe.debit" : "_ label.scarabe.credit").__escape(')'));
        return true;
    }

    private boolean printReste() {
        Montant montant = this.mouvement.getMontant();
        if (montant == null) {
            return false;
        }
        this.__(INFO_LEAF, () -> this.__localize("_ label.scarabe.reste").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((long)this.mouvement.getResteMoneyLong(), (ExtendedCurrency)montant.getCurrency(), (DecimalFormatSymbols)this.symbols, (boolean)true)));
        return true;
    }

    private boolean printFichesLiees(List<Ligne> ligneList, String messageKey) {
        HtmlAttributes linkAttr = HA.href((CharSequence)"").target(IFRAME_NAME);
        for (Ligne ligne : ligneList) {
            FicheMeta ficheMeta = ligne.getFicheMeta();
            String titre = ficheMeta.getTitre().length() == 0 ? "__" : ficheMeta.getTitre();
            this.__(INFO_LEAF, () -> {
                this.EM().__localize(messageKey).__colon()._EM().A(linkAttr.href((CharSequence)BH.domain((String)"edition").page("fiche-change").subsetItem((SubsetItem)ficheMeta))).__escape((CharSequence)titre)._A();
                if (ligne.hasError()) {
                    this.SPAN("global-ErrorMessage").__space().__escape('(');
                    boolean next = false;
                    for (Message errorMessage : ligne.getErrorMessageList()) {
                        if (next) {
                            this.__escape(" ; ");
                        } else {
                            next = true;
                        }
                        this.__localize(errorMessage);
                    }
                    this.__escape(')')._SPAN();
                } else {
                    Montant montant = ligne.getMontant();
                    this.__colon().__escape((CharSequence)MoneyUtils.toLitteralString((Decimal)montant.getDecimal(), (ExtendedCurrency)montant.getCurrency(), (DecimalFormatSymbols)this.symbols));
                }
            });
        }
        return true;
    }

    private boolean printToolbar() {
        AliasHolder coreAliasHolder = this.scarabeContext.getCoreAliasHolder();
        this.__((Consumer)this.refreshLink()).__((Consumer)this.creationLink(coreAliasHolder.getCorpus("depense"))).__((Consumer)this.creationLink(coreAliasHolder.getCorpus("apport"))).__((Consumer)this.creationLink(coreAliasHolder.getCorpus("avance"))).__((Consumer)this.editLink());
        if (this.ficheResultHandler.getToolbarType() == 3) {
            this.SPAN("global-Glue")._SPAN().__((Consumer)FicheResultHandler.OVERLAY_CLOSE_BUTTON);
        }
        return true;
    }

    private Button creationLink(Corpus corpus) {
        String creationHref = BH.domain((String)"edition").page("fiche-creation").subset((Subset)corpus).param("mouvement", String.valueOf(this.mouvement.getId())).toString();
        String text = CorpusMetadataUtils.getNewFicheLabel((Corpus)corpus, (Lang)this.workingLang);
        return Button.link().href((CharSequence)creationHref).action("action-FicheCreate").target(IFRAME_NAME).text(text);
    }

    private Button refreshLink() {
        String refreshHref = BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)this.mouvement.getFicheMeta()).param("page-result-options", this.ficheResultHandler.getOptions()).param("goto", this.ficheResultHandler.getGotoValue()).toString();
        return Button.link().href((CharSequence)refreshHref).action("action-Refresh").textL10nObject((Object)"_ link.scarabe.pageupdate");
    }

    private Button editLink() {
        String editionHref = this.ficheResultHandler.getEditHref();
        return Button.link().href((CharSequence)editionHref).action("action-FicheEdit").textL10nObject((Object)"_ link.scarabe.mouvementchange").shortcutKey("F2").shortcutTooltip("F2");
    }
}

