/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;

public class AvancesNonSoldeesHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;
    private final Recapitulatif recapitulatif;
    private final DecimalFormatSymbols symbols;

    public AvancesNonSoldeesHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.addExtensionThemeCss("scarabe", new String[]{"index.css"});
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
        this.symbols = new DecimalFormatSymbols(this.getFormatLocale());
    }

    public void printHtml() {
        this.start();
        ScarabeHtmlUtils.printRecapitulatifToolList((HtmlPrinter)this, Scarabe.DOMAIN);
        this.printCommandMessageUnit();
        this.__((Consumer)PageUnit.start((Object)"_ label.scarabe.avancenonsoldeecount")).FORM_get("edition", "Edition").__(Button.COMMAND, (Consumer)Button.submit((String)"_ link.scarabe.avancessolde")).INPUT_hidden((Map)ParameterMap.init().subset((Subset)this.scarabeContext.getCoreAliasHolder().getCorpus("mouvement")).page("fiche-creation"));
        for (Ligne ligne : this.recapitulatif.getAvanceNonSoldeeList()) {
            this.printAvanceNonSoldee(ligne);
        }
        this._FORM().__(PageUnit.END);
        this.end();
    }

    private void printAvanceNonSoldee(Ligne ligne) {
        ExtendedCurrency avanceCurrency = ligne.getMontant().getCurrency();
        long avanceMoneyLong = -ligne.getComputeMoneyLong();
        FicheMeta ficheMeta = ligne.getFicheMeta();
        String titre = ficheMeta.getTitre();
        if (titre.length() == 0) {
            titre = "__";
        }
        HtmlAttributes checkbox = this.name("avances").value(String.valueOf(ficheMeta.getId()));
        this.H2().INPUT_checkbox(checkbox).__space().LABEL_for(checkbox.id()).__escape((CharSequence)titre)._LABEL().__(ScarabeHtmlUtils.printDisplayButton((HtmlPrinter)this, ficheMeta)).__(ScarabeHtmlUtils.printEditButton((HtmlPrinter)this, ficheMeta)).BR().__escape((CharSequence)MoneyUtils.toLitteralString((long)avanceMoneyLong, (ExtendedCurrency)avanceCurrency, (DecimalFormatSymbols)this.symbols, (boolean)true))._H2();
        AvanceInfo avanceInfo = ligne.getAvanceInfo();
        List<AvanceInfo.DepenseInfo> depenseInfoList = avanceInfo.getDepenseInfoList();
        if (depenseInfoList.isEmpty()) {
            return;
        }
        boolean withCurrencyDifference = false;
        StringBuilder buf = new StringBuilder();
        for (AvanceInfo.DepenseInfo depenseInfo : depenseInfoList) {
            buf.append(depenseInfo.getFicheMeta().getId());
            buf.append("; ");
        }
        this.P().__localize("_ label.scarabe.depenseidlist").__colon().BR().CODE().__escape((CharSequence)buf.toString())._CODE()._P();
        this.UL();
        String depenseParamName = "depensesparavance_" + ficheMeta.getId();
        for (AvanceInfo.DepenseInfo depenseInfo : depenseInfoList) {
            FicheMeta depenseFicheMeta = depenseInfo.getFicheMeta();
            String depenseTitre = ficheMeta.getTitre();
            if (depenseTitre.length() == 0) {
                depenseTitre = "__";
            }
            this.LI();
            this.P().INPUT_hidden(depenseParamName, String.valueOf(depenseFicheMeta.getId())).SMALL().__escape((CharSequence)depenseTitre).BR();
            if (depenseInfo.hasError()) {
                this.SPAN("global-ErrorMessage");
                boolean next = false;
                for (Message errorMessage : depenseInfo.getErrorMessageList()) {
                    if (next) {
                        this.__escape(" ; ");
                    } else {
                        next = true;
                    }
                    this.__localize(errorMessage);
                }
                this._SPAN();
            } else {
                ExtendedCurrency currency = depenseInfo.getCurrency();
                long moneyLong = depenseInfo.getMoneyLong();
                if (!currency.equals((Object)avanceCurrency)) {
                    this.SPAN("scarabe-index-Warning").__escape((CharSequence)MoneyUtils.toLitteralString((long)moneyLong, (ExtendedCurrency)currency, (DecimalFormatSymbols)this.symbols, (boolean)true))._SPAN();
                    withCurrencyDifference = true;
                } else {
                    avanceMoneyLong -= moneyLong;
                    this.__escape(MoneyUtils.toLitteralString((long)moneyLong, (ExtendedCurrency)currency, (DecimalFormatSymbols)this.symbols, (boolean)true));
                }
            }
            this._SMALL().__(ScarabeHtmlUtils.printDisplayButton((HtmlPrinter)this, depenseFicheMeta)).__(ScarabeHtmlUtils.printEditButton((HtmlPrinter)this, depenseFicheMeta))._P();
            this._LI();
        }
        this._UL();
        if (!withCurrencyDifference) {
            this.P().__localize("_ label.scarabe.reste").__colon().__escape((CharSequence)MoneyUtils.toLitteralString((long)avanceMoneyLong, (ExtendedCurrency)avanceCurrency, (DecimalFormatSymbols)this.symbols, (boolean)true))._P();
        }
    }
}

