/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.html.consumers;

import fr.exemole.bdfext.scarabe.api.analytique.TableaucroiseDef;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class TableaucroiseChoices
implements Consumer<HtmlPrinter> {
    private static final TableaucroiseChoices EMPTY = new TableaucroiseChoices(null);
    private final Choice[] choiceArray;

    private TableaucroiseChoices(Choice[] choiceArray) {
        this.choiceArray = choiceArray;
    }

    public boolean isEmpty() {
        return this.choiceArray == null;
    }

    @Override
    public void accept(HtmlPrinter hp) {
        for (Choice choice : this.choiceArray) {
            choice.accept(hp);
        }
    }

    public static TableaucroiseChoices build(List<TableaucroiseDef> tableaucroiseDefList, Fichotheque fichotheque, Lang lang) {
        if (tableaucroiseDefList.isEmpty()) {
            return EMPTY;
        }
        int tableaucroiseDefLength = tableaucroiseDefList.size();
        Choice[] choiceArray = new Choice[tableaucroiseDefLength];
        for (int i = 0; i < tableaucroiseDefLength; ++i) {
            TableaucroiseDef tableaucroiseDef = tableaucroiseDefList.get(i);
            String title = tableaucroiseDef.getTitleLabels().seekLabelString(lang, null);
            if (title == null) {
                Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(tableaucroiseDef.getIncludeKey().getSubsetKey());
                title = FichothequeUtils.getTitle((Subset)thesaurus, (Lang)lang);
            }
            choiceArray[i] = new Choice(title, tableaucroiseDef.getIncludeKey(), i == 0);
        }
        return new TableaucroiseChoices(choiceArray);
    }

    private static class Choice
    implements Consumer<HtmlPrinter> {
        private final String title;
        private final HtmlAttributes radio;

        private Choice(String title, IncludeKey includeKey, boolean checked) {
            this.title = title;
            this.radio = HA.type((String)"radio").name("includekey").value(includeKey.getKeyString()).checked(checked);
        }

        @Override
        public void accept(HtmlPrinter hp) {
            String id = hp.generateId();
            hp.P("command-FlexInput").INPUT(this.radio.id(id)).LABEL_for(id).__escape((CharSequence)this.title)._LABEL()._P();
        }
    }
}

