/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TableDefCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableDef";
    public static final String COMMANDKEY_GENERAL = "_ SCARABE-03";
    public static final String COMMANDKEY_ANALYTIQUE = "_ SCARABE-04";
    public static final String NAME_PARAMNAME = "name";
    public static final String CONTENT_PARAMNAME = "content";
    private final ScarabeContext scarabeContext;
    private String tableDefName;
    private String content;

    public TableDefCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin(Scarabe.DOMAIN, COMMANDNAME);
        ConfigurationUtils.saveTableDefContent(this.scarabeContext, this.tableDefName, this.content, editOrigin);
        ConfigurationUtils.updateTableDefConfig(this.scarabeContext, this.tableDefName, this.content);
        this.setDone("_ done.scarabe.tabledef", new Object[0]);
    }

    protected void checkParameters() throws ErrorMessageException {
        ScarabeUtils.checkInitState(this.scarabeContext);
        this.tableDefName = this.getMandatory(NAME_PARAMNAME);
        this.content = this.getMandatory(CONTENT_PARAMNAME);
    }
}

