/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.core.BanqueDetailBuilder;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.primitives.DateFilterUtils;
import net.mapeadores.util.primitives.RangeDateFilter;
import net.mapeadores.util.request.RequestMap;

public class BanqueDetailCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "BanqueDetail";
    public static final String DATE_PARAMNAME = "date";
    public static final String IDALPHA_PARAMNAME = "idalpha";
    public static final String TYPE_PARAMNAME = "type";
    public static final String SORT_PARAMNAME = "sort";
    public static final String MOUVEMENT_TYPE_VALUE = "mouvement";
    public static final String LIGNE_TYPE_VALUE = "ligne";
    public static final String GENERAL_TYPE_VALUE = "general";
    public static final String DATE_SORT_VALUE = "date";
    public static final String NUMEROPIECE_SORT_VALUE = "numeropiece";
    private RangeDateFilter rangeDateFilter;
    private final ScarabeContext scarabeContext;
    private final Recapitulatif recapitulatif;
    private Banque banque;
    private String type;
    private String sort;

    public BanqueDetailCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(bdfServer);
    }

    public boolean needSynchronisation() {
        return false;
    }

    protected void doCommand() throws ErrorMessageException {
        BanqueDetailBuilder banqueDetailBuilder = new BanqueDetailBuilder(this.banque, this.rangeDateFilter);
        this.balaieRecapitulatif(this.recapitulatif, this.banque, banqueDetailBuilder);
        if (this.sort.equals(NUMEROPIECE_SORT_VALUE)) {
            banqueDetailBuilder.sortByPiece();
        }
        this.putResultObject("scarabe.obj_banquedetail", banqueDetailBuilder.toBanqueDetail());
        this.putResultObject("scarabe.obj_type", this.type);
        this.bdfUser.putParameter("scarabe.lastbanquedetailtype", (Object)this.type);
        this.bdfUser.putParameter("scarabe.lastbanquedetailsort", (Object)this.sort);
    }

    protected void checkParameters() throws ErrorMessageException {
        ScarabeUtils.checkInitState(this.scarabeContext);
        this.type = this.getMandatory(TYPE_PARAMNAME);
        BanqueDetailCommand.testType(this.type);
        String idalpha = this.getMandatory(IDALPHA_PARAMNAME);
        this.sort = this.requestHandler.getTrimedParameter(SORT_PARAMNAME);
        if (!this.sort.isEmpty()) {
            BanqueDetailCommand.testSort(this.sort);
        } else {
            this.sort = "date";
        }
        this.banque = this.recapitulatif.getBanques().getBanqueByIdalpha(idalpha);
        if (this.banque == null) {
            throw BdfErrors.error((String)"_ error.wrong.value", (Object[])new Object[]{idalpha});
        }
        String dateString = this.requestHandler.getTrimedParameter("date");
        if (!dateString.isEmpty()) {
            try {
                this.rangeDateFilter = DateFilterUtils.parseDateFilter((String)dateString);
            }
            catch (ParseException pe) {
                throw BdfErrors.error((String)"_ error.wrong.date", (Object[])new Object[]{dateString});
            }
        }
    }

    private void balaieRecapitulatif(Recapitulatif recapitulatif, Banque banque, BanqueDetailBuilder banqueDetail) {
        String codeBanque = banque.getCodeBanque();
        for (Recapitulatif.Annee annee : recapitulatif.getAnneeList()) {
            for (Recapitulatif.Mois mois : annee.getMoisList()) {
                for (Recapitulatif.Jour jour : mois.getJourList()) {
                    for (Mouvement mouvement : jour.getMouvementList()) {
                        boolean continueTest;
                        if (!mouvement.getBanque().getCodeBanque().equals(codeBanque) || (continueTest = banqueDetail.addMouvement(mouvement))) continue;
                        return;
                    }
                }
            }
        }
    }

    private static void testType(String type) throws ErrorMessageException {
        switch (type) {
            case "mouvement": 
            case "ligne": 
            case "general": {
                return;
            }
        }
        throw BdfErrors.unknownParameterValue((String)TYPE_PARAMNAME, (String)type);
    }

    private static void testSort(String sort) throws ErrorMessageException {
        switch (sort) {
            case "date": 
            case "numeropiece": {
                return;
            }
        }
        throw BdfErrors.unknownParameterValue((String)SORT_PARAMNAME, (String)sort);
    }
}

