/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.commands.AnalytiqueConfigCommand;
import fr.exemole.bdfext.scarabe.commands.AnalytiqueDetailCommand;
import fr.exemole.bdfext.scarabe.commands.AnalytiqueRecapCommand;
import fr.exemole.bdfext.scarabe.commands.BanqueDetailCommand;
import fr.exemole.bdfext.scarabe.commands.DesherenceRemoveCommand;
import fr.exemole.bdfext.scarabe.commands.InstallationCommand;
import fr.exemole.bdfext.scarabe.commands.LigneSelectionCommand;
import fr.exemole.bdfext.scarabe.commands.MouvementSelectionCommand;
import fr.exemole.bdfext.scarabe.commands.PrerequestConfigCommand;
import fr.exemole.bdfext.scarabe.commands.TableDefCommand;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import net.mapeadores.util.request.RequestMap;

public class ScarabeBdfCommandProvider
implements BdfCommandProvider {
    private final ScarabeContext scarabeContext;

    public ScarabeBdfCommandProvider(ScarabeContext scarabeContext) {
        this.scarabeContext = scarabeContext;
    }

    public BdfCommand getBdfCommand(BdfCommandParameters bdfCommandParameters) {
        if (!BdfInstructionUtils.ownsToExtension((BdfCommandParameters)bdfCommandParameters, (String)"scarabe")) {
            return null;
        }
        BdfServer bdfServer = bdfCommandParameters.getBdfServer();
        RequestMap requestMap = bdfCommandParameters.getRequestMap();
        switch (bdfCommandParameters.getCommandName()) {
            case "Installation": {
                return new InstallationCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "MouvementSelection": {
                return new MouvementSelectionCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "LigneSelection": {
                return new LigneSelectionCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "BanqueDetail": {
                return new BanqueDetailCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "AnalytiqueDetail": {
                return new AnalytiqueDetailCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "AnalytiqueConfig": {
                return new AnalytiqueConfigCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "DesherenceRemove": {
                return new DesherenceRemoveCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "TableDef": {
                return new TableDefCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "AnalytiqueRecap": {
                return new AnalytiqueRecapCommand(bdfServer, requestMap, this.scarabeContext);
            }
            case "PrerequestConfig": {
                return new PrerequestConfigCommand(bdfServer, requestMap, this.scarabeContext);
            }
        }
        return null;
    }
}

