/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.menu.ActionEntry;
import fr.exemole.bdfserver.api.menu.ActionGroup;
import fr.exemole.bdfserver.api.providers.ActionProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.menu.ActionEntryBuilder;
import fr.exemole.bdfserver.tools.menu.ActionGroupBuilder;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;

public class ScarabeActionProvider
implements ActionProvider {
    private final ScarabeContext scarabeContext;

    public ScarabeActionProvider(ScarabeContext scarabeContext) {
        this.scarabeContext = scarabeContext;
    }

    public String getCssThemeFile(String actionKey) {
        return "_action.css";
    }

    public ActionGroup getActionGroup(String actionKey, BdfServer bdfServer, BdfUser bdfUser) {
        switch (actionKey) {
            case "admin": {
                return this.getAdminActionGroup(bdfServer, bdfUser);
            }
        }
        return null;
    }

    private ActionGroup getAdminActionGroup(BdfServer bdfServer, BdfUser bdfUser) {
        if (!BdfUserUtils.isAdmin((BdfServer)bdfServer, (BdfUser)bdfUser)) {
            return null;
        }
        ActionGroupBuilder builder = ActionGroupBuilder.init((String)"scarabe").setTitleMessage("_ title.scarabe.extension", new Object[0]);
        switch (this.scarabeContext.getInitState()) {
            case 1: {
                builder.addActionEntry(this.toActionEntry("action-scarabe-Analytique", "_ link.scarabe.config_analytique", "AnalytiqueConfig")).addActionEntry(this.toActionEntry("action-scarabe-Columns", "_ link.scarabe.config_tableaux", "ColumnsConfig")).addActionEntry(this.toActionEntry("action-scarabe-Prerequest", "_ link.scarabe.config_prerequest", "PrerequestConfig"));
                break;
            }
            case 2: {
                builder.addActionEntry(this.toActionEntry("action-scarabe-Installation", "_ link.scarabe.installation", "Installation", "List"));
            }
        }
        if (!this.scarabeContext.getInitMessageLog().isEmpty()) {
            builder.addActionEntry(this.toActionEntry("action-Logs", "_ link.scarabe.initlog", "InitLog"));
        }
        if (builder.isEmpty()) {
            return null;
        }
        return builder.toActionGroup();
    }

    private ActionEntry toActionEntry(String cssName, String key, String pageName) {
        return this.toActionEntry(cssName, key, pageName, null);
    }

    private ActionEntry toActionEntry(String cssName, String key, String pageName, String target) {
        return ActionEntryBuilder.init((String)BH.domain((String)Scarabe.DOMAIN).page(pageName).toString()).setTitleMessage(key, new Object[0]).setCssName(cssName).toActionEntry();
    }
}

