/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce;

import fr.exemole.bdfext.icyce.IcyceUserConstants;
import fr.exemole.bdfext.icyce.IcyceUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.List;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.SphereUtils;

public class IcyceUser
implements IcyceUserConstants {
    private static final String ICYCE_USER_KEY = " fr.exemole.bdfext.icyce";
    private final BdfUser bdfUser;
    private final short userLevel;
    private final int[] conferenceIdArray;

    private IcyceUser(BdfUser bdfUser, short userLevel, int[] conferenceIdArray) {
        this.bdfUser = bdfUser;
        this.userLevel = userLevel;
        this.conferenceIdArray = conferenceIdArray;
    }

    public int getConferenceCount() {
        return this.conferenceIdArray.length;
    }

    public int getConferenceId(int i) {
        return this.conferenceIdArray[i];
    }

    public short getUserLevel() {
        return this.userLevel;
    }

    public static IcyceUser getIcyceUser(BdfServer bdfServer, BdfUser bdfUser) {
        IcyceUser icyceUser = (IcyceUser)bdfUser.getParameterValue(ICYCE_USER_KEY);
        if (icyceUser != null) {
            return icyceUser;
        }
        short userLevel = IcyceUser.initLevel(bdfServer, bdfUser);
        int[] conferenceIdArray = IcyceUser.initConferences(bdfServer, bdfUser);
        icyceUser = new IcyceUser(bdfUser, userLevel, conferenceIdArray);
        bdfUser.putParameter(ICYCE_USER_KEY, (Object)icyceUser);
        return icyceUser;
    }

    private static short initLevel(BdfServer bdfServer, BdfUser bdfUser) {
        PermissionManager permissionManager = bdfServer.getPermissionManager();
        if (permissionManager.isAdmin(bdfUser.getRedacteur())) {
            return 2;
        }
        List roleList = permissionManager.getRoleList(bdfUser.getRedacteur());
        for (Role role : roleList) {
            String name = role.getName();
            if (name.equals("coordination")) {
                return 2;
            }
            if (!name.equals("brasilia")) continue;
            return 2;
        }
        return 1;
    }

    private static int[] initConferences(BdfServer bdfServer, BdfUser bdfUser) {
        Fichotheque fichotheque = bdfServer.getFichotheque();
        Corpus corpus = IcyceUtils.getConfCorpus(fichotheque);
        String globalId = bdfUser.getRedacteur().getGlobalId();
        TreeMap<Integer, FicheMeta> map = new TreeMap<Integer, FicheMeta>();
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (!SphereUtils.ownsToRedacteur((FicheMeta)ficheMeta, (String)globalId)) continue;
            map.put(ficheMeta.getId(), ficheMeta);
        }
        int size = map.size();
        int[] conferenceIdArray = new int[size];
        int p = 0;
        for (Integer itg : map.keySet()) {
            conferenceIdArray[p] = itg;
            ++p;
        }
        return conferenceIdArray;
    }
}

