/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce;

import fr.exemole.bdfext.icyce.api.IcyceConfig;
import fr.exemole.bdfext.icyce.builders.IcyceConfigBuilder;
import fr.exemole.bdfext.icyce.xml.IcyceConfigDOMReader;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.text.RelativePath;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class Icyce {
    public static final String REGISTRATION_NAME = "fr-exemole-icyce";
    public static final RelativePath EXTENSION_RESOURCE_ROOT = StorageUtils.buildExtensionResourcePath((String)"fr-exemole-icyce", (String)"");
    private static boolean isInit = false;
    public static IcyceConfig config;

    private Icyce() {
    }

    public static boolean isInit() {
        return isInit;
    }

    public static void init(BdfServer bdfServer) {
        IcyceConfigBuilder builder = new IcyceConfigBuilder();
        RelativePath privatePath = EXTENSION_RESOURCE_ROOT.buildChild("private/listes");
        SortedMap map = bdfServer.getResourceStorages().listResources(privatePath, false);
        for (String name : map.keySet()) {
            int idx = name.indexOf(".");
            if (idx < 1) continue;
            String baseName = name.substring(0, idx);
            String extension = name.substring(idx + 1);
            if (!extension.equals("txt")) continue;
            List<SubsetKey> subsetKeyList = Icyce.getSubsetKeyList(bdfServer.getResourceStorages().getResourceDocStream(privatePath.buildChild(name)));
            builder.add(baseName, subsetKeyList);
        }
        DocStream docStream = bdfServer.getResourceStorages().getResourceDocStream(EXTENSION_RESOURCE_ROOT.buildChild("icyce-config.xml"));
        if (docStream != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try (InputStream is = docStream.getInputStream();){
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.parse(is);
                IcyceConfigDOMReader reader = new IcyceConfigDOMReader(builder);
                reader.readConfig(doc.getDocumentElement());
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        config = builder.toIcyceConfig();
        isInit = true;
    }

    private static List<SubsetKey> getSubsetKeyList(DocStream docStream) {
        ArrayList<SubsetKey> arrayList;
        ArrayList<SubsetKey> result = new ArrayList<SubsetKey>();
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(docStream.getInputStream()));
        try {
            String ligne = null;
            while ((ligne = bufReader.readLine()) != null) {
                if ((ligne = ligne.trim()).length() <= 0) continue;
                SubsetKey subsetKey = SubsetKey.build((short)1, (String)ligne);
                result.add(subsetKey);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        bufReader.close();
        return arrayList;
    }
}

