/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.xml;

import java.io.IOException;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Ventilation;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class VentilationXMLPart
extends XMLPart {
    public VentilationXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addVentilation(Ventilation ventilation) throws IOException {
        this.openTag("ventilation");
        this.addSimpleElement("ventilationname", ventilation.getVentilationName().toUriString());
        Term root = ventilation.getRoot();
        if (root == null) {
            this.addEmptyElement("root");
        } else {
            this.openTag("root");
            this.addTerm(root);
            this.closeTag("root");
        }
        SecteurList secteurList = ventilation.getFirstLevelSecteurList();
        int secteurCount = secteurList.getSecteurCount();
        for (int i = 0; i < secteurCount; ++i) {
            Secteur secteur = secteurList.getSecteur(i);
            this.addSecteur(secteur);
        }
        this.closeTag("ventilation");
    }

    private void addTerm(Term term) throws IOException {
        this.startOpenTag("termeinatlas");
        short type = term.getTermType();
        switch (type) {
            case 1: {
                this.addAttribute("type", "descripteur");
                this.addAttribute("iddesc", ((Descripteur)term).getIddesc().toString());
                break;
            }
            case 2: {
                this.addAttribute("type", "grille");
                String grilleName = ((Grille)term).getGrilleName();
                this.addAttribute("grl", grilleName);
                this.addAttribute("name", grilleName);
                break;
            }
            case 3: {
                this.addAttribute("type", "contexte");
                Contexte contexte = (Contexte)term;
                String contextGrilleName = contexte.getGrille().getGrilleName();
                this.addAttribute("grl", contextGrilleName);
                this.addAttribute("grille", contextGrilleName);
                this.addAttribute("idctxt", contexte.getIdctxt());
                break;
            }
            case 4: {
                this.addAttribute("type", "famille");
                this.addAttribute("idctxt", ((Contexte)term).getIdctxt());
                break;
            }
            case 5: {
                this.addAttribute("type", "special:horsgrille");
                break;
            }
            case 6: {
                this.addAttribute("type", "special:sansfamille");
                break;
            }
            case 7: {
                this.addAttribute("type", "special:familles");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal TermType");
            }
        }
        this.endOpenTag();
        XMLUtils.addLibElements((XMLWriter)this, (Labels)term.getLabels());
        this.closeTag("termeinatlas");
    }

    private void addSecteur(Secteur secteur) throws IOException {
        this.startOpenTag("secteur");
        if (!secteur.isActive()) {
            this.addAttribute("active", "false");
        }
        this.endOpenTag();
        Term term = secteur.getSecteurTerm();
        this.addTerm(term);
        LiaisonList liaisonList = secteur.getLiaisonList();
        int liaisonCount = liaisonList.getLiaisonCount();
        for (int i = 0; i < liaisonCount; ++i) {
            Liaison liaison = liaisonList.getLiaison(i);
            this.writeLiaison(liaison);
        }
        SecteurList secteurList = secteur.getChildren();
        int secteurCount = secteurList.getSecteurCount();
        for (int i = 0; i < secteurCount; ++i) {
            Secteur child = secteurList.getSecteur(i);
            this.addSecteur(child);
        }
        this.closeTag("secteur");
    }

    private void writeLiaison(Liaison liaison) throws IOException {
        this.openTag("liaison");
        Term term = liaison.getTerm();
        this.addTerm(term);
        this.closeTag("liaison");
    }
}

