/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.builders;

import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.ColorStyle;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Ventilation;

public class SecteurBuilder {
    private final List<SecteurBuilder> secteurList = new ArrayList<SecteurBuilder>();
    private final List<InternalLiaison> liaisonList = new ArrayList<InternalLiaison>();
    private final Term term;
    private boolean active;
    private ColorStyle colorStyle;
    private int ventilationCode;

    public SecteurBuilder(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setVentilationCode(int ventilationCode) {
        this.ventilationCode = ventilationCode;
    }

    public void setColorStyle(ColorStyle colorStyle) {
        this.colorStyle = colorStyle;
    }

    public void addChild(SecteurBuilder secteurBuilder) {
        this.secteurList.add(secteurBuilder);
    }

    public int getChildCount() {
        return this.secteurList.size();
    }

    public SecteurBuilder getChild(int i) {
        return this.secteurList.get(i);
    }

    public boolean addLiaison(LiaisonFilter liaisonFilter, Lien lien, Term termeLiaison, short position, int indexInLien, int code) {
        InternalLiaison defliaison = new InternalLiaison(lien, termeLiaison, position, indexInLien, code);
        if (liaisonFilter != null && !liaisonFilter.accept(defliaison)) {
            return false;
        }
        this.liaisonList.add(defliaison);
        return true;
    }

    public Secteur toSecteur(Ventilation ventilation, int index, boolean ignoreEmpty) {
        InternalSecteur secteur = this.toSecteur(ventilation, ignoreEmpty, 0, null);
        if (!ignoreEmpty || !secteur.isEmpty()) {
            secteur.index = index;
            return secteur;
        }
        return null;
    }

    private InternalSecteur toSecteur(Ventilation ventilation, boolean ignoreEmpty, int profondeur, InternalSecteur parent) {
        int liaisonSize = this.liaisonList.size();
        if (liaisonSize == 0 && ignoreEmpty) {
            this.active = false;
        }
        InternalSecteur secteur = new InternalSecteur(this.term, ventilation, parent, this.colorStyle, this.active, this.ventilationCode, profondeur);
        if (liaisonSize == 0) {
            secteur.liaisonList = VentilationUtils.EMPTY_LIAISON_LIST;
        } else {
            Liaison[] array = new InternalLiaison[liaisonSize];
            for (int i = 0; i < liaisonSize; ++i) {
                InternalLiaison liaison = this.liaisonList.get(i);
                liaison.secteur = secteur;
                array[i] = liaison;
            }
            secteur.liaisonList = VentilationUtils.toLiaisonList(array);
        }
        int size = this.secteurList.size();
        if (size == 0) {
            secteur.secteurList = VentilationUtils.EMPTY_SECTEUR_LIST;
        } else {
            ArrayList<Secteur> resultList = new ArrayList<Secteur>();
            int index = 0;
            for (int i = 0; i < size; ++i) {
                InternalSecteur child = this.secteurList.get(i).toSecteur(ventilation, ignoreEmpty, profondeur + 1, secteur);
                if (ignoreEmpty && child.isEmpty()) continue;
                child.index = index;
                ++index;
                resultList.add(child);
            }
            secteur.secteurList = VentilationUtils.toSecteurList(resultList);
        }
        return secteur;
    }

    private static class InternalLiaison
    implements Liaison {
        private final Lien lien;
        private final Term terme;
        private final int code;
        private final short position;
        private final int indexInLien;
        private InternalSecteur secteur;

        private InternalLiaison(Lien lien, Term terme, short position, int indexInLien, int code) {
            this.lien = lien;
            this.terme = terme;
            this.code = code;
            this.position = position;
            this.indexInLien = indexInLien;
        }

        @Override
        public int getIndexInLien() {
            return this.indexInLien;
        }

        @Override
        public Lien getLien() {
            return this.lien;
        }

        @Override
        public Term getTerm() {
            return this.terme;
        }

        @Override
        public Secteur getSecteur() {
            return this.secteur;
        }

        @Override
        public int getVentilationCode() {
            return this.code;
        }

        @Override
        public short getPosition() {
            return this.position;
        }

        private void initSecteur(InternalSecteur secteur) {
            this.secteur = secteur;
        }
    }

    private static class InternalSecteur
    implements Secteur {
        private final Term terme;
        private final Ventilation ventilation;
        private final Secteur parent;
        private final ColorStyle colorStyle;
        private final boolean active;
        private final int ventilationCode;
        private final int profondeur;
        private int index;
        private SecteurList secteurList;
        private LiaisonList liaisonList;

        private InternalSecteur(Term terme, Ventilation ventilation, Secteur parent, ColorStyle colorStyle, boolean active, int ventilationCode, int profondeur) {
            this.terme = terme;
            this.ventilation = ventilation;
            this.parent = parent;
            this.colorStyle = colorStyle;
            this.active = active;
            this.ventilationCode = ventilationCode;
            this.profondeur = profondeur;
        }

        @Override
        public SecteurList getChildren() {
            return this.secteurList;
        }

        @Override
        public Secteur getParent() {
            return this.parent;
        }

        @Override
        public LiaisonList getLiaisonList() {
            return this.liaisonList;
        }

        @Override
        public Term getSecteurTerm() {
            return this.terme;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public Ventilation getVentilation() {
            return this.ventilation;
        }

        @Override
        public int getVentilationCode() {
            return this.ventilationCode;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getProfondeur() {
            return this.profondeur;
        }

        @Override
        public ColorStyle getColorStyle() {
            return this.colorStyle;
        }

        private boolean isEmpty() {
            return this.secteurList.getSecteurCount() == 0 && this.liaisonList.getLiaisonCount() == 0;
        }
    }
}

