/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.l10n;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;

public class AtlasL10n {
    private static final Map<String, Labels> labelMap;

    private AtlasL10n() {
    }

    public static Labels getSpecialTypeLabels(short specialtype) {
        switch (specialtype) {
            case 7: {
                return labelMap.get("familles");
            }
            case 5: {
                return labelMap.get("horsgrille");
            }
            case 6: {
                return labelMap.get("sansfamille");
            }
        }
        throw new IllegalArgumentException("wrong specialtype");
    }

    public static Labels getAttributeLabels(AttributeKey attributeKey) {
        if (!attributeKey.getNameSpace().equals("atlas")) {
            return null;
        }
        return labelMap.get("attr_" + attributeKey.getLocalKey());
    }

    public static Labels getLabels(String key) {
        return labelMap.get(key);
    }

    static {
        String[] keyArray = new String[]{"sansfamille", "horsgrille", "familles", "attr_url", "attr_poids", "attr_authors", "attr_date", "attr_source", "attr_color", "attr_ventilationnaturelle", "attr_ventilations", "val_ventilations_none", "val_ventilations_all"};
        Initializer initializer = new Initializer(keyArray);
        initializer.initLang("fr");
        initializer.initLang("es");
        initializer.initLang("en");
        initializer.initLang("zh");
        labelMap = initializer.toMap();
    }

    private static class Initializer {
        private final Map<String, LabelChangeBuilder> builderMap = new HashMap<String, LabelChangeBuilder>();

        private Initializer(String[] keyArray) {
            for (String key : keyArray) {
                this.builderMap.put(key, new LabelChangeBuilder());
            }
        }

        private void initLang(String langString) {
            try {
                Lang langInteger = Lang.parse((String)langString);
                Properties properties = new Properties();
                properties.load(AtlasL10n.class.getResourceAsStream("atlas_" + langString + ".properties"));
                for (Map.Entry<String, LabelChangeBuilder> entry : this.builderMap.entrySet()) {
                    String key = entry.getKey();
                    String libString = properties.getProperty(key);
                    CleanedString cleanedString = CleanedString.newInstance((CharSequence)libString);
                    if (cleanedString == null) continue;
                    entry.getValue().putLabel(LabelUtils.toLabel((Lang)langInteger, (CleanedString)cleanedString));
                }
            }
            catch (IOException ioe) {
                throw new InternalResourceException((Exception)ioe);
            }
            catch (ParseException lie) {
                throw new InternalResourceException((Exception)lie);
            }
        }

        private Map<String, Labels> toMap() {
            HashMap<String, Labels> result = new HashMap<String, Labels>();
            for (Map.Entry<String, LabelChangeBuilder> entry : this.builderMap.entrySet()) {
                result.put(entry.getKey(), entry.getValue().toLabels());
            }
            return result;
        }
    }
}

