/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.tools;

import java.text.ParseException;
import java.util.ArrayList;
import net.desmodo.atlas.json.api.FieldFilter;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.StringUtils;

public class FieldFilterBuilder {
    private static final int LENGTH = 15;
    public static final FieldFilter DEFAULT_FIELDFILTER = new InternalFieldFilter(new boolean[15], null);
    private final boolean[] withArray = new boolean[15];
    private AttrCondition[] attrConditionArray = null;

    public void setWith(int field, boolean value) {
        if (field < 0 || field >= 15) {
            return;
        }
        this.withArray[field] = value;
    }

    public void parseFields(String fieldsString) {
        for (String token : StringUtils.getTokens((String)fieldsString, (char)',', (short)2)) {
            if (token.equals("type")) {
                this.setWith(0, true);
                continue;
            }
            if (token.equals("libelles")) {
                this.setWith(1, true);
                continue;
            }
            if (token.equals("attrs")) {
                this.setWith(2, true);
                continue;
            }
            if (token.equals("idctxt")) {
                this.setWith(3, true);
                continue;
            }
            if (token.equals("grille-name")) {
                this.setWith(4, true);
                continue;
            }
            if (token.equals("grille-code")) {
                this.setWith(5, true);
                continue;
            }
            if (token.equals("index")) {
                this.setWith(6, true);
                continue;
            }
            if (token.equals("parent-code")) {
                this.setWith(7, true);
                continue;
            }
            if (token.equals("parent-idctxt")) {
                this.setWith(8, true);
                continue;
            }
            if (token.equals("iddesc")) {
                this.setWith(9, true);
                continue;
            }
            if (token.equals("famille-code")) {
                this.setWith(10, true);
                continue;
            }
            if (token.equals("famille-idctxt")) {
                this.setWith(11, true);
                continue;
            }
            if (token.equals("name")) {
                this.setWith(12, true);
                continue;
            }
            if (token.equals("famille-color")) {
                this.setWith(13, true);
                continue;
            }
            if (!token.equals("parents")) continue;
            this.setWith(14, true);
        }
    }

    public void parseAttributes(String attributesString) {
        String[] tokens2 = StringUtils.getTokens((String)attributesString, (char)',', (short)2);
        int length2 = tokens2.length;
        if (length2 > 0) {
            ArrayList<AttrCondition> attrConditionList = new ArrayList<AttrCondition>();
            for (int i = 0; i < length2; ++i) {
                String token2 = tokens2[i];
                if (token2.charAt(token2.length() - 1) == '*') {
                    if (token2.length() <= 1) continue;
                    attrConditionList.add(new StartAttrCondition(token2.substring(0, token2.length() - 1)));
                    continue;
                }
                try {
                    AttributeKey attributeKey = AttributeKey.parse((String)token2);
                    attrConditionList.add(new EqualsAttrCondition(attributeKey));
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            int size = attrConditionList.size();
            this.attrConditionArray = attrConditionList.toArray(new AttrCondition[size]);
        }
    }

    public boolean with(int field) {
        if (field < 0 || field >= 15) {
            return false;
        }
        return this.withArray[field];
    }

    public FieldFilter toFieldFilter() {
        InternalFieldFilter fieldFilter = new InternalFieldFilter(this.withArray, this.attrConditionArray);
        return fieldFilter;
    }

    private static abstract class AttrCondition {
        private AttrCondition() {
        }

        abstract boolean accept(AttributeKey var1);
    }

    private static class StartAttrCondition
    extends AttrCondition {
        private final String start;

        private StartAttrCondition(String start) {
            this.start = start;
        }

        @Override
        boolean accept(AttributeKey attributeKey) {
            return attributeKey.toString().startsWith(this.start);
        }
    }

    private static class EqualsAttrCondition
    extends AttrCondition {
        private final AttributeKey equalsAttributeKey;

        private EqualsAttrCondition(AttributeKey equalsAttributeKey) {
            this.equalsAttributeKey = equalsAttributeKey;
        }

        @Override
        boolean accept(AttributeKey attributeKey) {
            return this.equalsAttributeKey.equals((Object)this.equalsAttributeKey);
        }
    }

    private static class InternalFieldFilter
    implements FieldFilter {
        private final boolean[] withArray;
        private final AttrCondition[] attrConditionArray;

        private InternalFieldFilter(boolean[] withArray, AttrCondition[] attrConditionArray) {
            this.withArray = withArray;
            this.attrConditionArray = attrConditionArray;
        }

        @Override
        public boolean with(int field) {
            if (field < 0 || field >= 15) {
                return false;
            }
            return this.withArray[field];
        }

        @Override
        public boolean acceptLibelle(Lang lang) {
            return true;
        }

        @Override
        public boolean acceptAttribute(AttributeKey attributeKey) {
            if (!this.withArray[2]) {
                return false;
            }
            if (this.attrConditionArray == null) {
                return true;
            }
            int length = this.attrConditionArray.length;
            for (int i = 0; i < length; ++i) {
                if (!this.attrConditionArray[i].accept(attributeKey)) continue;
                return true;
            }
            return false;
        }
    }
}

