/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.event.AtlasMetadataEvent;
import net.desmodo.atlas.event.AtlasMetadataListener;
import net.desmodo.atlas.impl.TermCoder;
import net.desmodo.atlas.impl.TermImpl;
import net.desmodo.atlas.metadata.AtlasAttributeDefList;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.desmodo.atlas.metadata.AtlasMetadataEditor;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeDefBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.misc.ArrayUtils;
import net.mapeadores.util.text.Label;

class AtlasMetadataImpl
implements AtlasMetadata {
    private static final Langs DEFAULT_LANGS = LangsUtils.wrap((Lang[])new Lang[]{Lang.build((String)"fr")});
    private final TermCoder termCoder;
    private final Atlas atlas;
    private final AtlasMetadataEditorImpl metadataEditor = new AtlasMetadataEditorImpl();
    private final TitreImpl titre;
    private final AttributesCache attributesCache = new AttributesCache();
    private AtlasMetadataListener[] atlasMetadataListeners = new AtlasMetadataListener[0];
    private Langs workingLangs = DEFAULT_LANGS;
    private Map<AttributeKey, AttributeDef> attributeDefMap = null;
    private Map<String, List<AttributeDef>> scopeMap = null;
    private AtlasAttributeDefList atlasAttributeDefList = null;

    AtlasMetadataImpl(Atlas atlas, TermCoder termCoder) {
        this.atlas = atlas;
        this.termCoder = termCoder;
        int newCode = termCoder.getNewCode();
        this.titre = new TitreImpl(newCode);
        termCoder.setTerm(newCode, this.titre);
    }

    @Override
    public Atlas getAtlas() {
        return this.atlas;
    }

    @Override
    public Term getTitre() {
        return this.titre;
    }

    @Override
    public void addAtlasMetadataListener(AtlasMetadataListener atlasMetadataListener) {
        this.atlasMetadataListeners = (AtlasMetadataListener[])ArrayUtils.addUnique((Object[])this.atlasMetadataListeners, (Object)atlasMetadataListener, (Object[])new AtlasMetadataListener[this.atlasMetadataListeners.length + 1]);
    }

    @Override
    public void removeAtlasMetadataListener(AtlasMetadataListener atlasMetadataListener) {
        if (this.atlasMetadataListeners.length > 0) {
            this.atlasMetadataListeners = (AtlasMetadataListener[])ArrayUtils.removeUnique((Object[])this.atlasMetadataListeners, (Object)atlasMetadataListener, (Object[])new AtlasMetadataListener[this.atlasMetadataListeners.length - 1]);
        }
    }

    @Override
    public Langs getWorkingLangs() {
        return this.workingLangs;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributesCache.getAttributes();
    }

    @Override
    public AttributeDef getAttributeDef(AttributeKey attributeKey) {
        if (this.attributeDefMap == null) {
            return AtlasAttributes.getStandardAttributeDef(attributeKey);
        }
        return this.attributeDefMap.get(attributeKey);
    }

    @Override
    public List<AttributeDef> getAttributeListByScope(String scope) {
        if (this.scopeMap == null) {
            return AtlasAttributes.getStandardAttributeDefList(scope);
        }
        List<AttributeDef> attributeDefList = this.scopeMap.get(scope);
        if (attributeDefList == null) {
            return AttributeUtils.EMPTY_ATTRIBUTEDEFLIST;
        }
        return attributeDefList;
    }

    @Override
    public AtlasAttributeDefList getAtlasAttributeDefList() {
        if (this.atlasAttributeDefList == null) {
            return AtlasUtils.EMPTY_ATLASATTRIBUTEDEFLIST;
        }
        return this.atlasAttributeDefList;
    }

    protected boolean removeAttribute(AttributeKey attributeKey) {
        return this.attributesCache.removeAttribute(attributeKey);
    }

    protected boolean putAttribute(Attribute attribute) {
        return this.attributesCache.putAttribute(attribute);
    }

    AtlasMetadataEditor getAtlasMetadataEditor() {
        return this.metadataEditor;
    }

    private void fireWorkingLangIntegerListChanged() {
        int length = this.atlasMetadataListeners.length;
        if (length == 0) {
            return;
        }
        AtlasMetadataEvent atlasMetadataEvent = new AtlasMetadataEvent(this);
        for (int i = 0; i < length; ++i) {
            this.atlasMetadataListeners[i].workingLangIntegerListChanged(atlasMetadataEvent);
        }
    }

    private class AtlasMetadataEditorImpl
    implements AtlasMetadataEditor {
        private AtlasMetadataEditorImpl() {
        }

        @Override
        public AtlasMetadata getAtlasMetadata() {
            return AtlasMetadataImpl.this;
        }

        @Override
        public boolean setWorkingLangs(Langs integerList) {
            int count = integerList.size();
            if (count == 0) {
                throw new IllegalArgumentException("workingLangIntegerList is empty");
            }
            LinkedHashSet<Lang> langSet = new LinkedHashSet<Lang>();
            for (int i = 0; i < count; ++i) {
                langSet.add((Lang)integerList.get(i));
            }
            Langs newList = LangsUtils.fromCollection(langSet);
            int newCount = newList.size();
            boolean change = false;
            if (newCount != AtlasMetadataImpl.this.workingLangs.size()) {
                change = true;
            } else {
                for (int i = 0; i < newCount; ++i) {
                    if (newList.get(i) == AtlasMetadataImpl.this.workingLangs.get(i)) continue;
                    change = true;
                    break;
                }
            }
            if (change) {
                AtlasMetadataImpl.this.workingLangs = newList;
                AtlasMetadataImpl.this.fireWorkingLangIntegerListChanged();
            }
            return change;
        }

        @Override
        public void setAtlasAttributeDefList(AtlasAttributeDefList atlasAttributeDefList) {
            ScopeBuilder scopeBuilder = new ScopeBuilder(atlasAttributeDefList);
            scopeBuilder.build();
            AtlasMetadataImpl.this.attributeDefMap = scopeBuilder.toAttributeMap();
            AtlasMetadataImpl.this.scopeMap = scopeBuilder.toScopeMap();
            AtlasMetadataImpl.this.atlasAttributeDefList = atlasAttributeDefList;
        }
    }

    private class TitreImpl
    extends TermImpl {
        private TitreImpl(int code) {
            super(code);
        }

        @Override
        public Atlas getAtlas() {
            return AtlasMetadataImpl.this.atlas;
        }

        @Override
        public short getTermType() {
            return 8;
        }
    }

    private static class ScopeBuilder {
        private final AtlasAttributeDefList atlasAttributeDefList;
        private final Map<String, List<AttributeDef>> scopeBuilderMap = new LinkedHashMap<String, List<AttributeDef>>();
        private final Map<AttributeKey, AttributeDef> map = new HashMap<AttributeKey, AttributeDef>();
        private final Set<AttributeKey> ignoreStandardSet = new HashSet<AttributeKey>();

        private ScopeBuilder(AtlasAttributeDefList atlasAttributeDefList) {
            this.scopeBuilderMap.put("descripteur", new ArrayList());
            this.scopeBuilderMap.put("metadata", new ArrayList());
            this.scopeBuilderMap.put("titre", new ArrayList());
            this.scopeBuilderMap.put("contexte", new ArrayList());
            this.scopeBuilderMap.put("grille", new ArrayList());
            this.scopeBuilderMap.put("famille", new ArrayList());
            this.atlasAttributeDefList = atlasAttributeDefList;
        }

        private void build() {
            int count = this.atlasAttributeDefList.getInactiveAttributeKeyCount();
            for (int i = 0; i < count; ++i) {
                this.ignoreStandardSet.add(this.atlasAttributeDefList.getInactiveAttributeKey(i));
            }
            int attributeDefCount = this.atlasAttributeDefList.getAttributeDefCount();
            for (int i = 0; i < attributeDefCount; ++i) {
                this.addAttributeDef(this.atlasAttributeDefList.getAttributeDef(i), true);
            }
            for (AttributeDef attributeDef : AtlasAttributes.STANDARD_ATLASATTRIBUTEDEFLIST) {
                this.addAttributeDef(attributeDef, false);
            }
        }

        private void addAttributeDef(AttributeDef attributeDef, boolean mergeWithStandard) {
            AttributeDef standardAttributeDef;
            AttributeKey attributeKey = attributeDef.getAttributeKey();
            if (this.ignoreStandardSet.contains(attributeKey)) {
                return;
            }
            if (mergeWithStandard && (standardAttributeDef = AtlasAttributes.getStandardAttributeDef(attributeKey)) != null) {
                attributeDef = this.merge(standardAttributeDef, attributeDef);
            }
            this.map.put(attributeKey, attributeDef);
            this.ignoreStandardSet.add(attributeKey);
            Attribute scopeAttribute = attributeDef.getAttributes().getAttribute(AtlasAttributes.SCOPE_KEY);
            if (scopeAttribute == null) {
                for (List<AttributeDef> list : this.scopeBuilderMap.values()) {
                    list.add(attributeDef);
                }
            } else {
                int scopeLength = scopeAttribute.size();
                for (int i = 0; i < scopeLength; ++i) {
                    List<AttributeDef> list = this.scopeBuilderMap.get(scopeAttribute.get(i));
                    if (list == null) continue;
                    list.add(attributeDef);
                }
            }
        }

        private Map<AttributeKey, AttributeDef> toAttributeMap() {
            return this.map;
        }

        private Map<String, List<AttributeDef>> toScopeMap() {
            HashMap<String, List<AttributeDef>> result = new HashMap<String, List<AttributeDef>>();
            for (Map.Entry<String, List<AttributeDef>> entry : this.scopeBuilderMap.entrySet()) {
                result.put(entry.getKey(), AttributeUtils.toImmutableList((Collection)entry.getValue()));
            }
            return result;
        }

        private AttributeDef merge(AttributeDef standardAttributeDef, AttributeDef customAttributeDef) {
            AttributeDefBuilder builder = new AttributeDefBuilder(standardAttributeDef.getAttributeKey(), standardAttributeDef.getAttributes());
            for (Label label : standardAttributeDef.getTitleLabels()) {
                builder.putLabel(label);
            }
            for (Label label : customAttributeDef.getTitleLabels()) {
                builder.putLabel(label);
            }
            return builder.toAttributeDef();
        }
    }
}

