/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.DisplayUtils;
import net.desmodo.atlas.display.SxdWriter;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.blocks.TransversalLine;

public class CommonDisplay {
    public static final String SVG_TRANSVERSALLINE_CLASSNAME = "transversal_line";
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;

    private CommonDisplay() {
    }

    public static void paint(LibelleBlock block, Graphics g) {
        CommonDisplay.paint(block.getTextBox(), g, block.getLocation());
    }

    public static void exportSXD(LibelleBlock block, SxdWriter sxdwriter, String pageName, String layerName) throws IOException {
        CommonDisplay.exportSXD(block.getTextBox(), block.getLocation(), block.getId(), sxdwriter, pageName, layerName);
    }

    public static void exportSXD(LibelleBlock block, SxdWriter sxdwriter, String pageName, String layerName, int id) throws IOException {
        CommonDisplay.exportSXD(block.getTextBox(), block.getLocation(), id, sxdwriter, pageName, layerName);
    }

    public static void paint(TextBox box, Graphics g, Point Q) {
        CommonDisplay.paint(box, box.getBoxSkin(), g, Q);
    }

    public static void paint(TextBox box, BoxSkin boxSkin, Graphics g, Point Q) {
        Color backgroundColor;
        Dimension dimension = box.getDimension();
        int lineCount = box.getLineCount();
        int x = Q.x;
        int y = Q.y;
        int w = dimension.width;
        int h = dimension.height;
        if (boxSkin.isOpaque()) {
            backgroundColor = boxSkin.getBackgroundColor();
            g.setColor(backgroundColor);
            g.fillRect(x, y, w, h);
            Color borderColor = boxSkin.getBorderColor();
            if (borderColor != null) {
                g.setColor(borderColor);
                g.drawRect(x, y, w - 1, h - 1);
            }
        } else {
            backgroundColor = boxSkin.getBackgroundColor();
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
                for (int i = 0; i < lineCount; ++i) {
                    TextBox.Line line = box.getLine(i);
                    Point P = line.getStartPoint();
                    g.fillRect(x + P.x, y + P.y - (line.getLineAscent() - 2), line.getLineLength(), line.getLineAscent() + line.getLineDescent() - 1);
                }
            }
        }
        g.setFont(boxSkin.getFont());
        g.setColor(boxSkin.getTextColor());
        for (int i = 0; i < lineCount; ++i) {
            TextBox.Line line = box.getLine(i);
            Point P = line.getStartPoint();
            g.drawString(line.getLineString(), x + P.x, y + P.y);
        }
    }

    public static void exportSXD(TextBox box, Point D, int id, SxdWriter sxdwriter, String pageName, String layerName) throws IOException {
        sxdwriter.startTextBoxOpenTag();
        sxdwriter.addStyleNameAttribute("boite:" + box.getBoxSkin().getSkinName());
        sxdwriter.addLayerAttribute(layerName);
        if (id > -1) {
            sxdwriter.addIdAttribute(pageName + "_" + id);
        }
        sxdwriter.addPositionAttributes(D);
        sxdwriter.addDimensionAttributes(box.getDimension());
        sxdwriter.endOpenTag();
        sxdwriter.addTextElement(box.getText());
        sxdwriter.closeTextBox();
    }

    public static void exportSVG(LibelleBlock libelleBlock, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        Term term = libelleBlock.getTerm();
        Rectangle rect = libelleBlock.getRectangle();
        int x = rect.x + translation.getWestTranslation();
        int y = rect.y + translation.getNorthTranslation();
        TextBox box = libelleBlock.getTextBox();
        int lineCount = box.getLineCount();
        BoxSkin boxSkin = box.getBoxSkin();
        svgWriter.startGroupOpenTag();
        svgWriter.addAttribute("atlas:terme-uri", AtlasURI.toURIString(term));
        svgWriter.addAttribute("atlas:block-position", libelleBlock.getPositionString());
        svgWriter.endOpenTag();
        svgWriter.startRectOpenTag(x, y, rect.width, rect.height);
        svgWriter.addFillAttribute(boxSkin.getBackgroundColor());
        svgWriter.addStrokeAttribute(boxSkin.getBorderColor());
        svgWriter.closeEmptyTag();
        for (int i = 0; i < lineCount; ++i) {
            TextBox.Line line = box.getLine(i);
            Point P = line.getStartPoint();
            DisplayUtils.addTextElement(svgWriter, x + P.x, y + P.y, line.getLineString(), boxSkin);
        }
        svgWriter.closeGroup();
    }

    public static void paint(TransversalLine transversalLine, Graphics2D g) {
        g.setColor(Color.DARK_GRAY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point center1 = transversalLine.getBlock1().getCenterPoint();
        Point center2 = transversalLine.getBlock2().getCenterPoint();
        g.drawLine(center1.x, center1.y, center2.x, center2.y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void exportSVG(TransversalLine transversalLine, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        Point center1 = transversalLine.getBlock1().getCenterPoint();
        Point center2 = transversalLine.getBlock2().getCenterPoint();
        int x1 = center1.x + translation.getWestTranslation();
        int y1 = center1.y + translation.getNorthTranslation();
        int x2 = center2.x + translation.getWestTranslation();
        int y2 = center2.y + translation.getNorthTranslation();
        svgWriter.startLineOpenTag(x1, y1, x2, y2);
        svgWriter.addStrokeAttribute(Color.GRAY);
        svgWriter.closeEmptyTag();
    }

    public static void exportSXD(TransversalLine transversalLine, SxdWriter sxdwriter, String pageName, String layerName, String type) throws IOException {
        SxdWriter.ConnectorParameters param = new SxdWriter.ConnectorParameters();
        LiaisonBlock block1 = transversalLine.getBlock1();
        LiaisonBlock block2 = transversalLine.getBlock2();
        String styleName = "special:fleche";
        int transversalType = transversalLine.getTransversaliteType();
        if (transversalType == 3) {
            styleName = styleName + "/both";
        } else if (transversalType == 2) {
            styleName = styleName + "/start";
        } else if (transversalType == 1) {
            styleName = styleName + "/end";
        }
        param.setStyleName(styleName);
        param.setLayer(layerName);
        param.setStartShape(pageName + "_" + block1.getId());
        param.setEndShape(pageName + "_" + block2.getId());
        param.setStartGluePoint(CommonDisplay.getGluePoint(block1, block2));
        param.setEndGluePoint(CommonDisplay.getGluePoint(block2, block1));
        sxdwriter.addConnectorElement(param, type);
    }

    public static void exportRayonSXD(LibelleBlock centralBlock, LiaisonBlock liaisonBlock, SxdWriter sxdwriter, String pageName, String layerName, String type) throws IOException {
        SxdWriter.ConnectorParameters param = new SxdWriter.ConnectorParameters();
        String styleName = "special:fleche";
        short boxType = liaisonBlock.getBoxType();
        switch (boxType) {
            case 1: {
                styleName = styleName + "/start";
                break;
            }
            case 3: {
                styleName = styleName + "/both";
                break;
            }
            default: {
                styleName = styleName + "/end";
            }
        }
        param.setStyleName(styleName);
        param.setLayer(layerName);
        param.setStartShape(pageName + "_0");
        param.setEndShape(pageName + "_" + liaisonBlock.getId());
        param.setStartGluePoint(CommonDisplay.getGluePoint(centralBlock, liaisonBlock));
        param.setEndGluePoint(CommonDisplay.getGluePoint(liaisonBlock, centralBlock));
        sxdwriter.addConnectorElement(param, type);
    }

    private static int getGluePoint(LibelleBlock block1, LibelleBlock block2) {
        return CommonDisplay.getGluePoint(block1.getCenterPoint(), block1.getSize(), block2.getCenterPoint());
    }

    private static int getGluePoint(Point K1, Dimension dim, Point K2) {
        double tangentedim;
        Point P = new Point(K2.x - K1.x, K2.y - K1.y);
        if (P.x == 0) {
            return P.y > 0 ? 2 : 0;
        }
        if (P.y == 0) {
            return P.x > 0 ? 1 : 3;
        }
        double tangente = Math.abs((double)P.y / (double)P.x);
        if (tangente > (tangentedim = Math.abs((double)dim.height / (double)dim.width))) {
            return P.y > 0 ? 2 : 0;
        }
        return P.x > 0 ? 1 : 3;
    }
}

