/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.importation;

import fr.exemole.bdfext.desmoservice.DesmoserviceSpace;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.Label;

public class SessionImportEngine {
    private static final Attribute INACTIVE_ATTRIBUTE = AttributeBuilder.toAttribute((AttributeKey)DesmoserviceSpace.ACTIVE_KEY, (String)"0");
    private final BdfParameters bdfParameters;
    private final DesmoserviceContext desmoserviceContext;
    private final AliasHolder coreAliasHolder;
    private final String name;
    private final FichothequeEditor fichothequeEditor;

    private SessionImportEngine(BdfParameters bdfParameters, DesmoserviceContext desmoserviceContext, String name, FichothequeEditor fichothequeEditor) {
        this.bdfParameters = bdfParameters;
        this.desmoserviceContext = desmoserviceContext;
        this.coreAliasHolder = desmoserviceContext.getCoreAliasHolder();
        this.name = name;
        this.fichothequeEditor = fichothequeEditor;
    }

    public static void run(String name, SessionSource sessionSource, BdfParameters bdfParameters, DesmoserviceContext desmoserviceContext, FichothequeEditor fichothequeEditor) {
        SessionImportEngine engine = new SessionImportEngine(bdfParameters, desmoserviceContext, name, fichothequeEditor);
        engine.run(sessionSource);
    }

    private void run(SessionSource sessionSource) {
        Atlas atlas = sessionSource.getAtlas();
        this.initAtlas(atlas, sessionSource.getSessionConf());
        this.initFamilles(atlas);
        this.initGrilles(atlas.getStructure());
        this.initDescripteurs(atlas);
        this.initLiens(atlas);
    }

    private void initLiens(Atlas atlas) {
        CroisementEditor croisementEditor = this.fichothequeEditor.getCroisementEditor();
        Corpus lhCorpus = this.coreAliasHolder.getCorpus("lienhierarchique");
        CorpusEditor corpusEditor = this.fichothequeEditor.getCorpusEditor(lhCorpus);
        Thesaurus descripteurThesaurus = this.coreAliasHolder.getThesaurus("descripteur");
        Thesaurus grilleThesaurus = this.coreAliasHolder.getThesaurus("grille");
        LienHierarchiqueGroupList list = atlas.getLiens().getLienHierarchiqueGroupList();
        int count = list.getLienHierarchiqueGroupCount();
        for (int i = 0; i < count; ++i) {
            FicheMeta ficheMeta;
            LienHierarchiqueGroup lhg = list.getLienHierarchiqueGroup(i);
            Motcle pereMotcle = descripteurThesaurus.getMotcleByIdalpha(this.name + "/" + lhg.getDescripteurPere().getIddesc());
            Contexte contexte = lhg.getContexte();
            Motcle contexteMotcle = null;
            if (contexte.getGrille() != null) {
                contexteMotcle = grilleThesaurus.getMotcleByIdalpha(this.name + "/" + contexte.getGrille().getGrilleName() + "/" + contexte.getIdctxt());
            }
            try {
                ficheMeta = corpusEditor.createFiche(-1);
            }
            catch (ExistingIdException eie) {
                throw new ShouldNotOccurException("Test done before");
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException("Not a satellite subset");
            }
            CroisementChangeEngine engine = CroisementChangeEngine.clearExistingEngine((SubsetItem)ficheMeta);
            engine.addLien((SubsetItem)pereMotcle, "pere", 1);
            if (contexteMotcle != null) {
                engine.addLien((SubsetItem)contexteMotcle, "", 1);
            }
            int lhCount = lhg.getLienHierarchiqueCount();
            for (int j = 0; j < lhCount; ++j) {
                Motcle filsMotcle = descripteurThesaurus.getMotcleByIdalpha(this.name + "/" + lhg.getLienHierarchique(j).getDescripteurFils().getIddesc());
                engine.addLien((SubsetItem)filsMotcle, "fils", 1);
            }
            croisementEditor.updateCroisements((SubsetItem)ficheMeta, engine.toCroisementChanges());
            corpusEditor.saveFiche(ficheMeta, (FicheAPI)new Fiche());
        }
    }

    private void initDescripteurs(Atlas atlas) {
        Thesaurus familleThesaurus = this.coreAliasHolder.getThesaurus("famille");
        Thesaurus descripteurThesaurus = this.coreAliasHolder.getThesaurus("descripteur");
        ThesaurusEditor descripteurEditor = this.fichothequeEditor.getThesaurusEditor(descripteurThesaurus);
        Descripteurs descripteurs = atlas.getDescripteurs();
        Grille grille = atlas.getStructure().getGrilleDesFamilles();
        this.initDescripteurs(grille.getFirstLevelContexteList(), descripteurs, descripteurEditor, familleThesaurus);
        Contexte sansfamille = atlas.getStructure().getSpecialContexte((short)6);
        DescripteurList descripteurList = atlas.getDescripteurs().getInFamilleDescripteurList(sansfamille);
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int j = 0; j < descripteurCount; ++j) {
            Descripteur descripteur = descripteurList.getDescripteur(j);
            try {
                Motcle descripteurMotcle = descripteurEditor.createMotcle(-1, this.name + "/" + descripteur.getIddesc().toString());
                SessionImportEngine.copy(descripteur, descripteurMotcle, descripteurEditor);
                continue;
            }
            catch (ParseException | ExistingIdException throwable) {
                // empty catch block
            }
        }
    }

    private void initDescripteurs(ContexteList contexteList, Descripteurs descripteurs, ThesaurusEditor descripteurEditor, Thesaurus familleThesaurus) {
        CroisementEditor croisementEditor = descripteurEditor.getFichothequeEditor().getCroisementEditor();
        int count = contexteList.getContexteCount();
        for (int i = 0; i < count; ++i) {
            Contexte contexte = contexteList.getContexte(i);
            Motcle familleMotcle = familleThesaurus.getMotcleByIdalpha(this.name + "/" + contexte.getIdctxt());
            DescripteurList descripteurList = descripteurs.getInFamilleDescripteurList(contexte);
            int descripteurCount = descripteurList.getDescripteurCount();
            for (int j = 0; j < descripteurCount; ++j) {
                Descripteur descripteur = descripteurList.getDescripteur(j);
                try {
                    Motcle descripteurMotcle = descripteurEditor.createMotcle(-1, this.name + "/" + descripteur.getIddesc().toString());
                    SessionImportEngine.copy(descripteur, descripteurMotcle, descripteurEditor);
                    CroisementChangeEngine engine = CroisementChangeEngine.clearExistingEngine((SubsetItem)descripteurMotcle);
                    engine.addLien((SubsetItem)familleMotcle, "", 1);
                    croisementEditor.updateCroisements((SubsetItem)descripteurMotcle, engine.toCroisementChanges());
                    continue;
                }
                catch (ParseException | ExistingIdException throwable) {
                    // empty catch block
                }
            }
            this.initDescripteurs(contexte.getChildren(), descripteurs, descripteurEditor, familleThesaurus);
        }
    }

    private void initFamilles(Atlas atlas) {
        Thesaurus familleThesaurus = this.coreAliasHolder.getThesaurus("famille");
        ThesaurusEditor familleEditor = this.fichothequeEditor.getThesaurusEditor(familleThesaurus);
        try {
            Motcle root = familleEditor.createMotcle(-1, this.name);
            Grille grille = atlas.getStructure().getGrilleDesFamilles();
            this.initContexteList(grille.getFirstLevelContexteList(), root, familleEditor, this.name + "/");
        }
        catch (ParseException | ExistingIdException throwable) {
            // empty catch block
        }
    }

    private void initGrilles(Structure structure) {
        Thesaurus grilleThesaurus = this.coreAliasHolder.getThesaurus("grille");
        ThesaurusEditor grilleEditor = this.fichothequeEditor.getThesaurusEditor(grilleThesaurus);
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            Grille grille = grilleList.getGrille(i);
            try {
                Motcle root = grilleEditor.createMotcle(-1, this.name + "/" + grille.getGrilleName());
                SessionImportEngine.copy(grille, root, grilleEditor);
                this.initContexteList(grille.getFirstLevelContexteList(), root, grilleEditor, this.name + "/" + grille.getGrilleName() + "/");
                continue;
            }
            catch (ParseException | ExistingIdException throwable) {
                // empty catch block
            }
        }
    }

    private void initContexteList(ContexteList contexteList, Motcle parent, ThesaurusEditor contexteEditor, String prefix) {
        int count = contexteList.getContexteCount();
        for (int i = 0; i < count; ++i) {
            Contexte contexte = contexteList.getContexte(i);
            try {
                Motcle motcle = contexteEditor.createMotcle(-1, prefix + contexte.getIdctxt());
                SessionImportEngine.copy(contexte, motcle, contexteEditor);
                contexteEditor.setParent(motcle, parent);
                if (!contexte.isActive()) {
                    contexteEditor.getFichothequeEditor().putAttribute((Object)motcle, INACTIVE_ATTRIBUTE);
                }
                this.initContexteList(contexte.getChildren(), motcle, contexteEditor, prefix);
                continue;
            }
            catch (ParseException | ExistingIdException | ParentRecursivityException throwable) {
                // empty catch block
            }
        }
    }

    private void initAtlas(Atlas atlas, Conf conf) {
        AtlasMetadata atlasMetadata = atlas.getAtlasMetadata();
        CorpusField langsField = this.coreAliasHolder.getCorpusField("atlas_langs");
        CorpusField paramsField = this.coreAliasHolder.getCorpusField("atlas_params");
        Thesaurus atlasThesaurus = this.coreAliasHolder.getThesaurus("atlas");
        Corpus atlasCorpus = this.coreAliasHolder.getCorpus("atlas");
        ThesaurusEditor atlasEditor = this.fichothequeEditor.getThesaurusEditor(atlasThesaurus);
        CorpusEditor corpusEditor = this.fichothequeEditor.getCorpusEditor(atlasCorpus);
        try {
            Motcle motcle = atlasEditor.createMotcle(-1, this.name);
            SessionImportEngine.copy(atlasMetadata.getTitre(), motcle, atlasEditor);
            FicheMeta ficheMeta = corpusEditor.createFiche(motcle.getId());
            Fiche fiche = new Fiche();
            ArrayList<Langue> langsList = new ArrayList<Langue>();
            for (Lang lang : atlasMetadata.getWorkingLangs()) {
                langsList.add(new Langue(lang));
            }
            fiche.setInformation(langsField.getFieldKey(), FicheUtils.toFicheItems(langsList));
            ArrayList<Item> paramsList = new ArrayList<Item>();
            Map<String, String> paramsMap = conf.toStringMap(true);
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                paramsList.add(new Item(entry.getKey() + "=" + entry.getValue()));
            }
            fiche.setInformation(paramsField.getFieldKey(), FicheUtils.toFicheItems(paramsList));
            FieldGenerationEngine engine = BdfCommandUtils.buildEngine((BdfParameters)this.bdfParameters, (Corpus)corpusEditor.getCorpus());
            corpusEditor.setDate(ficheMeta, FuzzyDate.current(), false);
            CorpusTools.saveFiche((CorpusEditor)corpusEditor, (FicheMeta)ficheMeta, (Fiche)fiche, (FieldGenerationEngine)engine, (boolean)false);
        }
        catch (ParseException | ExistingIdException | NoMasterIdException throwable) {
            // empty catch block
        }
    }

    private static void copy(Term term, Motcle motcle, ThesaurusEditor thesaurusEditor) {
        for (Label label : term.getLabels()) {
            thesaurusEditor.putLabel(motcle, label);
        }
        FichothequeEditor fichothequeEditor = thesaurusEditor.getFichothequeEditor();
        for (Attribute attribute : term.getAttributes()) {
            fichothequeEditor.putAttribute((Object)motcle, attribute);
        }
    }
}

