/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.edition;

import fr.exemole.bdfext.desmoservice.api.AtlasEdition;
import fr.exemole.bdfext.desmoservice.edition.AtlasEditionBuilder;
import fr.exemole.bdfext.desmoservice.edition.DescripteurCreationBuilder;
import fr.exemole.bdfext.desmoservice.edition.TermChangeBuilder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtlasEditionDOMReader {
    private final MessageHandler messageHandler;
    private final AtlasEditionBuilder atlasEditionBuilder;
    private final Atlas atlas;

    public AtlasEditionDOMReader(AtlasEditionBuilder atlasEditionBuilder, Atlas atlas, MessageHandler messageHandler) {
        this.atlasEditionBuilder = atlasEditionBuilder;
        this.messageHandler = messageHandler;
        this.atlas = atlas;
    }

    public void fillAtlasEdition(Element element) {
        DOMUtils.readChildren((Element)element, (Consumer)new RootConsumer());
    }

    private static AttributeKey getAttributeKey(Element element, MessageHandler messageHandler, String xpath) {
        CheckedLocalKey localKey;
        CheckedNameSpace nameSpace;
        String nameSpaceString = element.getAttribute("ns");
        if (nameSpaceString.length() == 0) {
            DomMessages.emptyAttribute((MessageHandler)messageHandler, (String)xpath, (String)"ns");
            return null;
        }
        String localKeyString = element.getAttribute("key");
        if (localKeyString.length() == 0) {
            DomMessages.emptyAttribute((MessageHandler)messageHandler, (String)xpath, (String)"key");
            return null;
        }
        xpath = xpath + "[@ns='" + nameSpaceString + "' AND @key='" + localKeyString + "']";
        try {
            nameSpace = CheckedNameSpace.parse((CharSequence)nameSpaceString);
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue((MessageHandler)messageHandler, (String)xpath, (String)"ns", (String)nameSpaceString);
            return null;
        }
        try {
            localKey = CheckedLocalKey.parse((CharSequence)localKeyString);
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue((MessageHandler)messageHandler, (String)xpath, (String)"key", (String)localKeyString);
            return null;
        }
        return AttributeKey.build((CheckedNameSpace)nameSpace, (CheckedLocalKey)localKey);
    }

    private static boolean hasDescripteurCode(Element element, String codeAttributeName) {
        if (element.hasAttribute(codeAttributeName)) {
            return true;
        }
        String iddescParamName = codeAttributeName.equals("code") ? "iddesc" : codeAttributeName + "-iddesc";
        return element.hasAttribute(iddescParamName);
    }

    private int getDescripteurMandatoryCode(Element element, String codeAttributeName, String xPath) {
        int code;
        String codeString = element.getAttribute(codeAttributeName);
        if (codeString.length() == 0) {
            String iddescParamName = codeAttributeName.equals("code") ? "iddesc" : codeAttributeName + "-iddesc";
            String iddescString = element.getAttribute(iddescParamName);
            if (iddescString.length() == 0) {
                DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName);
                return -1;
            }
            Iddesc iddesc = Iddesc.parse(iddescString);
            Descripteur descripteur = this.atlas.getDescripteurs().getDescripteurByIddesc(iddesc);
            if (descripteur == null) {
                DomMessages.wrongAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)iddescParamName, (String)iddescString);
                return -1;
            }
            return descripteur.getCode();
        }
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName, (String)codeString);
            return -1;
        }
        if (code < 1) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName, (String)codeString);
        }
        return code;
    }

    private int getFamilleMandatoryCode(Element element, String codeAttributeName, String xPath) {
        int code;
        String codeString = element.getAttribute(codeAttributeName);
        if (codeString.length() == 0) {
            String idctxtParamName = codeAttributeName.equals("code") ? "idctxt" : codeAttributeName + "-idctxt";
            String idctxtString = element.getAttribute(idctxtParamName);
            if (idctxtString.length() == 0) {
                DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName);
                return -1;
            }
            Contexte contexte = this.atlas.getStructure().getGrilleDesFamilles().getContexteByIdctxt(idctxtString);
            if (contexte == null) {
                DomMessages.wrongAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)idctxtParamName, (String)idctxtString);
                return -1;
            }
            return contexte.getCode();
        }
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName, (String)codeString);
            return -1;
        }
        if (code < 1) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName, (String)codeString);
        }
        return code;
    }

    private int getContexteMandatoryCode(Element element, String codeAttributeName, String xPath) {
        int code;
        String codeString = element.getAttribute(codeAttributeName);
        if (codeString.length() == 0) {
            String grilleParamName;
            String idctxtParamName;
            if (codeAttributeName.equals("code")) {
                idctxtParamName = "idctxt";
                grilleParamName = "grille";
            } else {
                idctxtParamName = codeAttributeName + "-idctxt";
                grilleParamName = codeAttributeName + "-grille";
            }
            String idctxtString = element.getAttribute(idctxtParamName);
            String grilleString = element.getAttribute(grilleParamName);
            if (idctxtString.length() == 0 && grilleString.length() == 0) {
                DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName);
                return -1;
            }
            if (idctxtString.length() == 0) {
                DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xPath, (String)idctxtParamName);
                return -1;
            }
            if (grilleString.length() == 0) {
                DomMessages.emptyAttribute((MessageHandler)this.messageHandler, (String)xPath, (String)grilleParamName);
                return -1;
            }
            Grille grille = this.atlas.getStructure().getGrille(grilleString);
            if (grille == null) {
                DomMessages.wrongAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)grilleParamName, (String)idctxtString);
                return -1;
            }
            Contexte contexte = grille.getContexteByIdctxt(idctxtString);
            if (contexte == null) {
                DomMessages.wrongAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)idctxtParamName, (String)idctxtString);
                return -1;
            }
            return contexte.getCode();
        }
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName, (String)codeString);
            return -1;
        }
        if (code < 1) {
            DomMessages.wrongIntegerAttributeValue((MessageHandler)this.messageHandler, (String)xPath, (String)codeAttributeName, (String)codeString);
        }
        return code;
    }

    private Peres checkPeres(Element element, MessageHandler messageHandler) {
        String tagName = element.getTagName();
        if (AtlasEditionDOMReader.hasDescripteurCode(element, "pere")) {
            int pere = this.getDescripteurMandatoryCode(element, "pere", tagName);
            int contexte = this.getContexteMandatoryCode(element, "contexte", tagName);
            if (pere != -1 && contexte != -1) {
                return new Peres(pere, contexte);
            }
            return null;
        }
        NodeList childNodes = element.getChildNodes();
        int size = childNodes.getLength();
        Peres peres = new Peres();
        for (int i = 0; i < size; ++i) {
            Element child;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !(child = (Element)node).getTagName().equals("pere")) continue;
            int pere = this.getDescripteurMandatoryCode(child, "code", tagName + "/pere");
            int contexte = this.getContexteMandatoryCode(child, "contexte", tagName);
            peres.add(pere, contexte);
        }
        if (peres.isEmpty()) {
            return null;
        }
        return peres;
    }

    private static class Peres {
        private final List<Integer> pereList = new ArrayList<Integer>();
        private final List<Integer> contexteList = new ArrayList<Integer>();

        private Peres(int pere, int contexte) {
            this.pereList.add(pere);
            this.contexteList.add(contexte);
        }

        private Peres() {
        }

        private boolean isEmpty() {
            return this.pereList.isEmpty();
        }

        private void add(int pere, int contexte) {
            this.pereList.add(pere);
            this.contexteList.add(contexte);
        }

        private void createLienHierarchique(AtlasEditionBuilder atlasEditionBuilder, int codefils) {
            int size = this.pereList.size();
            for (int i = 0; i < size; ++i) {
                atlasEditionBuilder.addLienHierarchiqueCreation((int)this.pereList.get(i), (int)this.contexteList.get(i), codefils);
            }
        }

        private void createLienHierarchique(AtlasEditionBuilder atlasEditionBuilder, AtlasEdition.DescripteurCreation descripteurCreation) {
            int size = this.pereList.size();
            for (int i = 0; i < size; ++i) {
                atlasEditionBuilder.addLienHierarchiqueCreation((int)this.pereList.get(i), (int)this.contexteList.get(i), descripteurCreation);
            }
        }

        private void removeLienHierarchique(AtlasEditionBuilder atlasEditionBuilder, int codefils) {
            int size = this.pereList.size();
            for (int i = 0; i < size; ++i) {
                atlasEditionBuilder.addLienHierarchiqueRemove(this.pereList.get(i), this.contexteList.get(i), codefils);
            }
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private TermChangeConsumer termeChangeConsumer;
        private DescripteurCreationConsumer descripteurCreationConsumer;

        private RootConsumer() {
            this.termeChangeConsumer = new TermChangeConsumer();
            this.descripteurCreationConsumer = new DescripteurCreationConsumer();
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("term-change") || tagName.equals("terme-change")) {
                int code = AtlasEditionDOMReader.this.getDescripteurMandatoryCode(element, "code", tagName);
                if (code != -1) {
                    TermChangeBuilder termeChangeBuilder = AtlasEditionDOMReader.this.atlasEditionBuilder.getTermChangeBuilder(code);
                    this.termeChangeConsumer.setTermChangeBuilder(termeChangeBuilder);
                    DOMUtils.readChildren((Element)element, (Consumer)this.termeChangeConsumer);
                }
            } else if (tagName.equals("lienhierarchique-creation")) {
                Peres peres = AtlasEditionDOMReader.this.checkPeres(element, AtlasEditionDOMReader.this.messageHandler);
                if (peres != null) {
                    if (AtlasEditionDOMReader.hasDescripteurCode(element, "fils")) {
                        int fils = AtlasEditionDOMReader.this.getDescripteurMandatoryCode(element, "fils", tagName);
                        if (fils != -1) {
                            peres.createLienHierarchique(AtlasEditionDOMReader.this.atlasEditionBuilder, fils);
                        }
                    } else {
                        DescripteurCreationBuilder descripteurCreationBuilder = new DescripteurCreationBuilder();
                        this.descripteurCreationConsumer.setDescripteurCreationBuilder(descripteurCreationBuilder);
                        DOMUtils.readChildren((Element)element, (Consumer)this.descripteurCreationConsumer);
                        peres.createLienHierarchique(AtlasEditionDOMReader.this.atlasEditionBuilder, descripteurCreationBuilder.toDescripteurCreation());
                    }
                }
            } else if (tagName.equals("descripteur-creation")) {
                DescripteurCreationBuilder descripteurCreationBuilder = new DescripteurCreationBuilder();
                this.descripteurCreationConsumer.setDescripteurCreationBuilder(descripteurCreationBuilder);
                DOMUtils.readChildren((Element)element, (Consumer)this.descripteurCreationConsumer);
                AtlasEditionDOMReader.this.atlasEditionBuilder.addDescripteurCreation(descripteurCreationBuilder.toDescripteurCreation());
            } else if (tagName.equals("contexte-lienhierarchique-change")) {
                int codeNewContexte;
                int codeFils;
                int codePere = AtlasEditionDOMReader.this.getDescripteurMandatoryCode(element, "pere", tagName);
                if (codePere != -1 && (codeFils = AtlasEditionDOMReader.this.getDescripteurMandatoryCode(element, "fils", tagName)) != -1 && (codeNewContexte = AtlasEditionDOMReader.this.getContexteMandatoryCode(element, "new-contexte", tagName)) != -1) {
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addContexteLienHierarchiqueChange(codePere, codeNewContexte, codeFils);
                }
            } else if (tagName.equals("lienhierarchique-remove")) {
                int fils;
                Peres peres = AtlasEditionDOMReader.this.checkPeres(element, AtlasEditionDOMReader.this.messageHandler);
                if (peres != null && AtlasEditionDOMReader.hasDescripteurCode(element, "fils") && (fils = AtlasEditionDOMReader.this.getDescripteurMandatoryCode(element, "fils", tagName)) != -1) {
                    peres.removeLienHierarchique(AtlasEditionDOMReader.this.atlasEditionBuilder, fils);
                }
            } else if (tagName.equals("term-remove")) {
                int code = AtlasEditionDOMReader.this.getDescripteurMandatoryCode(element, "code", tagName);
                if (code != -1) {
                    AtlasEditionDOMReader.this.atlasEditionBuilder.addTermRemove(code);
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class AttributeConsumer
    implements Consumer<Element> {
        private final AttributeKey attributeKey;
        private final AttributeChangeBuilder attributeChangeBuilder;

        public AttributeConsumer(AttributeKey attributeKey, AttributeChangeBuilder attributeChangeBuilder) {
            this.attributeKey = attributeKey;
            this.attributeChangeBuilder = attributeChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("val")) {
                CleanedString cs = XMLUtils.toCleanedString((Element)element);
                if (cs != null) {
                    this.attributeChangeBuilder.appendValue(this.attributeKey, cs);
                } else {
                    DomMessages.emptyElement((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)"val");
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class TermChangeConsumer
    implements Consumer<Element> {
        private TermChangeBuilder termChangeBuilder;

        private TermChangeConsumer() {
        }

        private void setTermChangeBuilder(TermChangeBuilder termChangeBuilder) {
            this.termChangeBuilder = termChangeBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("label") || tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel((Element)element);
                    if (label != null) {
                        LabelChangeBuilder changeLibelleHolderBuilder = this.termChangeBuilder.getLabelChangeBuilder();
                        changeLibelleHolderBuilder.putLabel(label);
                    }
                }
                catch (ParseException e) {
                    DomMessages.wrongLangAttribute((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName, (String)element.getAttribute("xml:lang"));
                }
            } else if (tagName.equals("label-remove") || tagName.equals("lib-remove")) {
                try {
                    Lang lang = Lang.parse((String)element.getAttribute("xml:lang"));
                    LabelChangeBuilder changeLibelleHolderBuilder = this.termChangeBuilder.getLabelChangeBuilder();
                    changeLibelleHolderBuilder.putRemovedLang(lang);
                }
                catch (ParseException e) {
                    DomMessages.wrongLangAttribute((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName, (String)element.getAttribute("xml:lang"));
                }
            } else if (tagName.equals("attr")) {
                AttributeKey attributeKey = AtlasEditionDOMReader.getAttributeKey(element, AtlasEditionDOMReader.this.messageHandler, tagName);
                if (attributeKey != null) {
                    DOMUtils.readChildren((Element)element, (Consumer)new AttributeConsumer(attributeKey, this.termChangeBuilder.getAttributeChangeBuilder()));
                }
            } else if (tagName.equals("attr-remove")) {
                AttributeKey attributeKey = AtlasEditionDOMReader.getAttributeKey(element, AtlasEditionDOMReader.this.messageHandler, tagName);
                if (attributeKey != null) {
                    AttributeChangeBuilder attributeChangeBuilder = this.termChangeBuilder.getAttributeChangeBuilder();
                    attributeChangeBuilder.putRemovedAttributeKey(attributeKey);
                }
            } else if (tagName.equals("famille")) {
                int code = AtlasEditionDOMReader.this.getFamilleMandatoryCode(element, "code", tagName);
                if (code != -1) {
                    this.termChangeBuilder.setCodefamille(code);
                }
            } else {
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }

    private class DescripteurCreationConsumer
    implements Consumer<Element> {
        private DescripteurCreationBuilder descripteurCreationBuilder;

        private DescripteurCreationConsumer() {
        }

        private void setDescripteurCreationBuilder(DescripteurCreationBuilder descripteurCreationBuilder) {
            this.descripteurCreationBuilder = descripteurCreationBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("label") || tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel((Element)element);
                    if (label != null) {
                        LabelChangeBuilder changeLibelleHolderBuilder = this.descripteurCreationBuilder.getLabelChangeBuilder();
                        changeLibelleHolderBuilder.putLabel(label);
                    }
                }
                catch (ParseException e) {
                    DomMessages.wrongLangAttribute((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName, (String)element.getAttribute("xml:lang"));
                }
            } else if (tagName.equals("attr")) {
                AttributeKey attributeKey = AtlasEditionDOMReader.getAttributeKey(element, AtlasEditionDOMReader.this.messageHandler, tagName);
                if (attributeKey != null) {
                    DOMUtils.readChildren((Element)element, (Consumer)new AttributeConsumer(attributeKey, this.descripteurCreationBuilder.getAttributesBuilder()));
                }
            } else if (tagName.equals("famille")) {
                int code = AtlasEditionDOMReader.this.getFamilleMandatoryCode(element, "code", tagName);
                if (code != -1) {
                    this.descripteurCreationBuilder.setCodefamille(code);
                }
            } else if (tagName.equals("key-prefix")) {
                this.descripteurCreationBuilder.setKeyPrefix(XMLUtils.getData((Element)element));
            } else {
                if (tagName.equals("pere")) {
                    return;
                }
                DomMessages.unknownTagWarning((MessageHandler)AtlasEditionDOMReader.this.messageHandler, (String)tagName);
            }
        }
    }
}

