/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice;

import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.producers.html.AdministrationHtmlProducer;
import fr.exemole.bdfext.desmoservice.producers.html.DescripteurHtmlProducer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import net.fichotheque.Subset;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.logging.ErrorMessageException;

public class DesmoserviceHtmlProducerProvider
implements HtmlProducerProvider {
    private final DesmoserviceContext desmoserviceContext;

    public DesmoserviceHtmlProducerProvider(DesmoserviceContext desmoserviceContext) {
        this.desmoserviceContext = desmoserviceContext;
    }

    public HtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        BdfServerHtmlProducer htmlProducer = this.getBdfHtmlProducer(parameters);
        if (htmlProducer != null) {
            htmlProducer.setBdfCommandResult(parameters.getBdfCommandResult());
        }
        return htmlProducer;
    }

    private BdfServerHtmlProducer getBdfHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        if (!BdfInstructionUtils.ownsToExtension((OutputParameters)parameters, (String)"fr-exemole-desmoservice")) {
            return null;
        }
        OutputRequestHandler requestHandler = OutputRequestHandler.init((OutputParameters)parameters);
        switch (page = parameters.getOutput()) {
            case "Administration": {
                parameters.checkFichothequeAdmin();
                return new AdministrationHtmlProducer((BdfParameters)parameters, this.desmoserviceContext);
            }
            case "Descripteur": {
                Motcle motcle = requestHandler.getMotcle();
                parameters.checkSubsetAdmin((Subset)motcle.getThesaurus());
                if (!motcle.getThesaurus().equals(this.desmoserviceContext.getCoreAliasHolder().getThesaurus("descripteur"))) {
                    throw BdfErrors.internalError((String)"Thesaurus is not Descripteur thesaurus");
                }
                return new DescripteurHtmlProducer((BdfParameters)parameters, this.desmoserviceContext, motcle);
            }
        }
        return null;
    }
}

