/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice;

import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.commands.DsmdImportCommand;
import fr.exemole.bdfext.desmoservice.commands.DsmdUpdateCommand;
import fr.exemole.bdfext.desmoservice.commands.FamilleChangeCommand;
import fr.exemole.bdfext.desmoservice.commands.InstallationCommand;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandParameters;
import fr.exemole.bdfserver.api.providers.BdfCommandProvider;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import net.mapeadores.util.request.RequestMap;

public class DesmoserviceBdfCommandProvider
implements BdfCommandProvider {
    private final DesmoserviceContext desmoserviceContext;

    public DesmoserviceBdfCommandProvider(DesmoserviceContext desmoserviceContext) {
        this.desmoserviceContext = desmoserviceContext;
    }

    public BdfCommand getBdfCommand(BdfCommandParameters bdfCommandParameters) {
        if (!BdfInstructionUtils.ownsToExtension((BdfCommandParameters)bdfCommandParameters, (String)"fr-exemole-desmoservice")) {
            return null;
        }
        BdfServer bdfServer = bdfCommandParameters.getBdfServer();
        RequestMap requestMap = bdfCommandParameters.getRequestMap();
        switch (bdfCommandParameters.getCommandName()) {
            case "Installation": {
                return new InstallationCommand(bdfServer, requestMap, this.desmoserviceContext);
            }
            case "FamilleChange": {
                return new FamilleChangeCommand(bdfServer, requestMap, this.desmoserviceContext);
            }
            case "DsmdImport": {
                return new DsmdImportCommand(bdfServer, requestMap, this.desmoserviceContext);
            }
            case "DsmdUpdate": {
                return new DsmdUpdateCommand(bdfServer, requestMap, this.desmoserviceContext);
            }
        }
        return null;
    }
}

