/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public class MetadataJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Lang lang;

    public MetadataJsonProducer(Atlas atlas, Lang lang) {
        this.atlas = atlas;
        this.lang = lang;
    }

    public void writeJson(Appendable appendable) throws IOException {
        Attributes attributes = this.atlas.getTermThesaurus().getThesaurusMetadata().getAttributes();
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("lang").value((Object)this.lang.toString());
        TermJson.labelProperties(jw, this.atlas, AtlasUtils.getTitleLabels(this.atlas), this.lang);
        jw.key("langs");
        jw.array();
        for (Lang authorizedLang : this.atlas.getLangs()) {
            jw.value((Object)authorizedLang.toString());
        }
        jw.endArray();
        TermJson.attributesProperties(jw, attributes);
        jw.key("home");
        jw.object();
        this.writeHomeName(jw, attributes);
        jw.endObject();
        jw.endObject();
    }

    private void writeHomeName(JSONWriter jw, Attributes attributes) throws IOException {
        Attribute attribute = attributes.getAttribute(DesmographySpace.HOME_KEY);
        if (attribute != null) {
            jw.key("name").value((Object)attribute.getFirstValue());
        }
    }
}

