/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.inclusionresolvers;

import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfserver.api.BdfServer;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.text.Labels;

public class AxesInclusionResolver
implements TableInclusionResolver {
    public static final String NAMESPACE = "desmography_axes";
    private final BdfServer bdfServer;

    public AxesInclusionResolver(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    public boolean test(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler lineMessageHandler) {
        Atlas atlas = this.getAtlas(subset);
        return atlas != null;
    }

    public Col[] resolve(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext) {
        Atlas atlas = this.getAtlas(subset);
        if (atlas == null) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        Col[] cols = new Col[]{this.toCol(atlas, "upwards"), this.toCol(atlas, "downwards"), this.toCol(atlas, "families")};
        return cols;
    }

    private Col toCol(Atlas atlas, String name) {
        return TableExportUtils.toCol((ColDef)new InternalColDef(name), (SourceFormatter)new AxeSourceFormatter(atlas, name));
    }

    private Atlas getAtlas(Subset subset) {
        if (!(subset instanceof Thesaurus)) {
            return null;
        }
        try {
            return DesmographyUtils.getAtlas(this.bdfServer, subset.getSubsetName());
        }
        catch (ErrorMessageException eme) {
            return null;
        }
    }

    private static class InternalColDef
    implements ColDef {
        private final String name;

        private InternalColDef(String name) {
            this.name = name;
        }

        public String getColName() {
            return this.name;
        }

        public Labels getCustomLabels() {
            return null;
        }

        public Object getParameterValue(String paramKey) {
            if (paramKey.equals("cast")) {
                return (short)6;
            }
            return null;
        }

        public short getCastType() {
            return 6;
        }
    }

    private static class AxeSourceFormatter
    implements SourceFormatter {
        private final Atlas atlas;
        private final String name;

        private AxeSourceFormatter(Atlas atlas, String name) {
            this.atlas = atlas;
            this.name = name;
        }

        public String formatSource(FormatSource formatSource) {
            String otherMode;
            List<FicheMeta> relationList;
            SubsetItemPointeur pointeur = formatSource.getSubsetItemPointeur();
            Croisements croisements = pointeur.getCroisements((Subset)this.atlas.getRelationCorpus());
            switch (this.name) {
                case "upwards": {
                    relationList = AtlasUtils.getRelationList(croisements, "inferior", "hierarchy");
                    otherMode = "superior";
                    break;
                }
                case "downwards": {
                    relationList = AtlasUtils.getRelationList(croisements, "superior", "hierarchy");
                    otherMode = "inferior";
                    break;
                }
                case "families": {
                    relationList = AtlasUtils.getRelationList(croisements, "inferior", "family");
                    otherMode = "superior";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown name: " + this.name);
                }
            }
            if (relationList.isEmpty()) {
                return null;
            }
            HashSet<Integer> addedSet = new HashSet<Integer>();
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            boolean first = true;
            for (FicheMeta relation : relationList) {
                List<Motcle> otherTerms = AtlasUtils.getTermList(this.atlas, relation, otherMode);
                for (Motcle otherTerm : otherTerms) {
                    int otherId = otherTerm.getId();
                    if (addedSet.contains(otherId)) continue;
                    if (first) {
                        first = false;
                    } else {
                        buf.append(',');
                    }
                    addedSet.add(otherId);
                    buf.append('\"');
                    buf.append(otherId);
                    buf.append('\"');
                }
            }
            buf.append(']');
            return buf.toString();
        }
    }
}

