/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.commands;

import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.sync.AtlasSync;
import fr.exemole.bdfext.desmography.sync.AtlasSyncEngine;
import fr.exemole.bdfext.desmography.sync.AtlasSyncUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.mapeadores.util.exceptions.ResponseCodeException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.request.RequestMap;
import org.xml.sax.SAXException;

public class SyncCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Sync";
    private Atlas atlas;
    private URL url;

    public SyncCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        AtlasSync atlasSync = null;
        try {
            atlasSync = AtlasSyncUtils.download(this.url, (MessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER);
        }
        catch (ResponseCodeException rce) {
            throw BdfErrors.error((String)"_ error.exception.url_httpcode", (Object[])new Object[]{rce.getHttpStatusCode()});
        }
        catch (IOException ioe) {
            throw BdfErrors.error((String)"_ error.exception.url_io", (Object[])new Object[]{this.url});
        }
        catch (SAXException saxe) {
            throw BdfErrors.error((String)"_ error.exception.xml.sax", (Object[])new Object[]{saxe.getLocalizedMessage()});
        }
        try (EditSession session = this.startEditSession(Desmography.DOMAIN, COMMANDNAME);){
            AtlasSyncEngine.run(session, (BdfParameters)this, atlasSync, this.atlas);
        }
    }

    protected void checkParameters() throws ErrorMessageException {
        this.atlas = DesmographyUtils.getAtlas(this.requestHandler);
        String urlString = DesmographyUtils.getAtlasSyncUrl(this.atlas);
        if (urlString == null) {
            throw BdfErrors.error((String)"_ error.empty.attribute", (Object[])new Object[]{DesmographyUtils.SYNC_ATLAS_KEY});
        }
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException mue) {
            throw BdfErrors.error((String)"_ error.wrong.url", (Object[])new Object[]{urlString});
        }
    }
}

