/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.IndexationItem;
import fr.exemole.bdfext.desmography.atlas.RelationReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.croisement.Lien;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.utils.Comparators;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrase;

public final class AtlasUtils {
    public static final CroisementChange INFERIORREMOVE_CROISEMENTCHANGE = new InferiorRemoveCroisementChange();
    private static final List<Motcle> EMPTY_MOTCLELIST = Collections.emptyList();
    private static final List<FicheMeta> EMPTY_FICHEMETALIST = Collections.emptyList();
    private static final List<RelationReference> EMPTY_RELATIONREFERENCELIST = Collections.emptyList();

    private AtlasUtils() {
    }

    public static List<Motcle> superiors(Atlas atlas, FicheMeta relation) {
        return AtlasUtils.getTermList(AtlasUtils.getTermCroisements(atlas, relation), "superior");
    }

    public static List<Motcle> inferiors(Atlas atlas, FicheMeta relation) {
        return AtlasUtils.getTermList(AtlasUtils.getTermCroisements(atlas, relation), "inferior");
    }

    public static List<Motcle> sectors(Atlas atlas, FicheMeta relation) {
        return AtlasUtils.getTermList(AtlasUtils.getTermCroisements(atlas, relation), "sector");
    }

    public static Croisements getRelationCroisements(Atlas atlas, Motcle term) {
        return atlas.getFichotheque().getCroisements((SubsetItem)term, (Subset)atlas.getRelationCorpus());
    }

    public static Croisements getTermCroisements(Atlas atlas, FicheMeta relation) {
        return atlas.getFichotheque().getCroisements((SubsetItem)relation, (Subset)atlas.getTermThesaurus());
    }

    public static List<Motcle> getTermList(Atlas atlas, FicheMeta relation, String mode) {
        return AtlasUtils.getTermList(atlas.getFichotheque().getCroisements((SubsetItem)relation, (Subset)atlas.getTermThesaurus()), mode);
    }

    public static List<Motcle> getTermList(Croisements croisements, String mode) {
        if (croisements.isEmpty()) {
            return EMPTY_MOTCLELIST;
        }
        ArrayList<Motcle> result = new ArrayList<Motcle>();
        for (Liaison liaison : CroisementUtils.filter((Croisements)croisements, (String)mode)) {
            result.add((Motcle)liaison.getSubsetItem());
        }
        return result;
    }

    public static boolean containsTerm(Atlas atlas, FicheMeta relation, String mode) {
        return AtlasUtils.containsTerm(atlas.getFichotheque().getCroisements((SubsetItem)relation, (Subset)atlas.getTermThesaurus()), mode);
    }

    public static boolean containsTerm(Croisements croisements, String mode) {
        if (croisements.isEmpty()) {
            return false;
        }
        for (Croisements.Entry entry : croisements.getEntryList()) {
            if (!entry.getCroisement().containsMode(mode)) continue;
            return true;
        }
        return false;
    }

    public static List<FicheMeta> getRelationList(Atlas atlas, Motcle term, String mode, String relationType) {
        return AtlasUtils.getRelationList(AtlasUtils.getRelationCroisements(atlas, term), mode, relationType);
    }

    public static List<FicheMeta> getRelationList(Croisements croisements, String mode, String relationType) {
        if (croisements.isEmpty()) {
            return EMPTY_FICHEMETALIST;
        }
        ArrayList<FicheMeta> result = new ArrayList<FicheMeta>();
        for (Croisements.Entry entry : croisements.getEntryList()) {
            FicheMeta relation;
            if (!entry.getCroisement().containsMode(mode) || !AtlasUtils.getRelationType(relation = (FicheMeta)entry.getSubsetItem()).equals(relationType)) continue;
            result.add(relation);
        }
        result.sort(Comparators.FICHEID_ASC);
        return result;
    }

    public static List<Motcle> getRootFamiliesList(Atlas atlas) {
        return AtlasUtils.getSpecialList(atlas, "rootfamilies");
    }

    public static List<Motcle> getGridsList(Atlas atlas) {
        return AtlasUtils.getSpecialList(atlas, "grids");
    }

    public static String getRelationType(FicheMeta ficheMeta) {
        Attribute relationtypeAttribute = ficheMeta.getAttributes().getAttribute(DesmographySpace.RELATIONTYPE_KEY);
        if (relationtypeAttribute == null) {
            return "";
        }
        return relationtypeAttribute.getFirstValue();
    }

    public static Motcle getSector(Atlas atlas, FicheMeta relation) {
        Croisements croisements = AtlasUtils.getTermCroisements(atlas, relation);
        for (Croisements.Entry entry : croisements.getEntryList()) {
            if (!entry.getCroisement().containsMode("sector")) continue;
            return (Motcle)entry.getSubsetItem();
        }
        return null;
    }

    public static FicheMeta getStandardHierarchyRelation(Atlas atlas, Motcle superior, Motcle inferior, Collection<Motcle> sectors) {
        String key = AtlasUtils.toSectorKey(sectors);
        Collection liaisons = CroisementUtils.filter((Croisements)AtlasUtils.getRelationCroisements(atlas, inferior), (String)"inferior");
        for (Liaison liaison : liaisons) {
            FicheMeta relation = (FicheMeta)liaison.getSubsetItem();
            String currentKey = AtlasUtils.testStandardHierarchyRelation(atlas, relation, superior, inferior);
            if (currentKey == null || !currentKey.equals(key)) continue;
            return relation;
        }
        return null;
    }

    private static String testStandardHierarchyRelation(Atlas atlas, FicheMeta relation, Motcle superior, Motcle inferior) {
        String currentType = AtlasUtils.getRelationType(relation);
        if (!currentType.equals("hierarchy")) {
            return null;
        }
        Croisements croisements = AtlasUtils.getTermCroisements(atlas, relation);
        Collection superiors = CroisementUtils.filter((Croisements)croisements, (String)"superior");
        if (superiors.size() != 1) {
            return null;
        }
        if (!((Liaison)superiors.iterator().next()).getSubsetItem().equals(superior)) {
            return null;
        }
        Collection inferiors = CroisementUtils.filter((Croisements)croisements, (String)"inferior");
        if (inferiors.size() != 1) {
            return null;
        }
        if (!((Liaison)inferiors.iterator().next()).getSubsetItem().equals(inferior)) {
            return null;
        }
        return AtlasUtils.toSectorKeyFromLiaison(CroisementUtils.filter((Croisements)croisements, (String)"sector"));
    }

    public static FicheMeta getGridsRelation(Atlas atlas) {
        return AtlasUtils.getSpecialRelation(atlas, "grids");
    }

    public static FicheMeta getRootFamiliesRelation(Atlas atlas) {
        return AtlasUtils.getSpecialRelation(atlas, "rootfamilies");
    }

    public static List<FicheMeta> getRootSectorsRelationList(Atlas atlas) {
        ArrayList<FicheMeta> result = new ArrayList<FicheMeta>();
        FicheMeta gridsRelation = AtlasUtils.getGridsRelation(atlas);
        if (gridsRelation != null) {
            List<Motcle> grids = AtlasUtils.inferiors(atlas, gridsRelation);
            for (Motcle grid : grids) {
                List<FicheMeta> subsectorsList = AtlasUtils.getRelationList(atlas, grid, "superior", "subsectors");
                result.addAll(subsectorsList);
            }
        }
        return result;
    }

    public static List<Motcle> getSpecialList(Atlas atlas, String specialRelationType) {
        FicheMeta relation = AtlasUtils.getSpecialRelation(atlas, specialRelationType);
        if (relation == null) {
            return Collections.emptyList();
        }
        return AtlasUtils.inferiors(atlas, relation);
    }

    public static FicheMeta getSpecialRelation(Atlas atlas, String specialRelationType) {
        FicheMeta result = null;
        for (FicheMeta relation : atlas.getRelationCorpus().getFicheMetaList()) {
            if (!AtlasUtils.getRelationType(relation).equals(specialRelationType)) continue;
            if (result == null) {
                result = relation;
                continue;
            }
            if (relation.getId() >= result.getId()) continue;
            result = relation;
        }
        return result;
    }

    public static String getConfirmationWord(Atlas atlas) {
        Attribute attribute = atlas.getTermThesaurus().getThesaurusMetadata().getAttributes().getAttribute(DesmographySpace.CONFIRMATIONWORD_KEY);
        if (attribute == null) {
            return null;
        }
        return attribute.getFirstValue();
    }

    public static String getAlias(Motcle term) {
        String idalpha = term.getIdalpha();
        if (idalpha != null && !idalpha.startsWith("_") && idalpha.indexOf(32) == -1) {
            return idalpha;
        }
        return null;
    }

    public static Labels getTitleLabels(Atlas atlas) {
        ThesaurusMetadata termMetadata = atlas.getTermThesaurus().getThesaurusMetadata();
        Phrase titleLabels = termMetadata.getPhrases().getPhrase("desmography.title");
        if (titleLabels == null) {
            titleLabels = termMetadata.getTitleLabels();
        }
        return titleLabels;
    }

    public static boolean isRemoveableRelation(Atlas atlas, FicheMeta relation) {
        String relationType = AtlasUtils.getRelationType(relation);
        return relationType.equals("hierarchy") && !AtlasUtils.containsTerm(atlas, relation, "inferior");
    }

    public static String toSectorKey(Collection<Motcle> sectors) {
        TreeSet<Integer> idSet = new TreeSet<Integer>();
        for (Motcle sector : sectors) {
            idSet.add(sector.getId());
        }
        StringBuilder buf = new StringBuilder();
        boolean next = false;
        for (Integer id : idSet) {
            if (next) {
                buf.append(",");
            } else {
                next = true;
            }
            buf.append(id);
        }
        return buf.toString();
    }

    public static String toSectorKeyFromLiaison(Collection<Liaison> liaisons) {
        TreeSet<Integer> idSet = new TreeSet<Integer>();
        for (Liaison liaison : liaisons) {
            idSet.add(liaison.getSubsetItem().getId());
        }
        StringBuilder buf = new StringBuilder();
        boolean next = false;
        for (Integer id : idSet) {
            if (next) {
                buf.append(",");
            } else {
                next = true;
            }
            buf.append(id);
        }
        return buf.toString();
    }

    public static boolean isEmptyLeaf(Atlas atlas, Motcle term) {
        for (Croisements.Entry entry : AtlasUtils.getRelationCroisements(atlas, term).getEntryList()) {
            for (Lien lien : entry.getCroisement().getLienList()) {
                switch (lien.getMode()) {
                    case "superior": 
                    case "sector": {
                        return false;
                    }
                }
            }
        }
        Fichotheque fichotheque = atlas.getFichotheque();
        for (IndexationItem indexationItem : atlas.getIndexationItemMap().values()) {
            Croisements croisements = fichotheque.getCroisements((SubsetItem)term, indexationItem.getSubset());
            for (IncludeKey includeKey : indexationItem.getOtherSubsetInTermIncludeKeySet()) {
                if (!CroisementUtils.contains((Croisements)croisements, (String)includeKey.getMode(), (int)includeKey.getPoidsFilter())) continue;
                return false;
            }
        }
        return true;
    }

    public static List<RelationReference> getRelationReferenceList(Atlas atlas, Attribute attribute) {
        if (attribute == null) {
            return EMPTY_RELATIONREFERENCELIST;
        }
        ArrayList<RelationReference> result = new ArrayList<RelationReference>();
        HashSet<String> existing = new HashSet<String>();
        for (String value : attribute) {
            if (existing.contains(value)) continue;
            existing.add(value);
            result.add(RelationReference.build(value, atlas));
        }
        return result;
    }

    private static class InferiorRemoveCroisementChange
    implements CroisementChange {
        private final List<String> removedModeList = Collections.singletonList("inferior");

        private InferiorRemoveCroisementChange() {
        }

        public List<String> getRemovedModeList() {
            return this.removedModeList;
        }

        public List<Lien> getChangedLienList() {
            return CroisementUtils.EMPTY_LIENLIST;
        }
    }
}

