/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmodo.json;

import fr.exemole.bdfext.desmodo.DesmodoManager;
import fr.exemole.bdfext.desmodo.Desmographie;
import fr.exemole.bdfext.desmodo.json.AbstractJsonProducer;
import fr.exemole.bdfext.desmodo.json.AtlasJsonProducer;
import fr.exemole.bdfext.desmodo.json.ErrorJsonProducer;
import fr.exemole.bdfext.desmodo.json.ParameterErrorException;
import fr.exemole.bdfext.desmodo.json.Parameters;
import fr.exemole.bdfext.desmodo.json.VentilationJsonProducer;
import fr.exemole.bdfext.desmodo.json.WarningHandler;
import fr.exemole.bdfserver.api.BdfServer;
import java.text.ParseException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.conf.StringMapConf;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.session.SessionUtils;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.UnsupportedVentilationNameException;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.mapeadores.util.geometry.CartesianPoint;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.net.UUIDURI;
import net.mapeadores.util.request.RequestMap;

public final class JsonProducerFactory
implements Parameters {
    private JsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(BdfServer bdfServer, RequestMap requestMap, DesmodoManager desmodoManager) {
        AbstractJsonProducer abstractJsonProducer;
        WarningHandler warningHandler = new WarningHandler();
        try {
            abstractJsonProducer = JsonProducerFactory.getJsonProducer(bdfServer, requestMap, desmodoManager, warningHandler);
        }
        catch (ParameterErrorException pee) {
            abstractJsonProducer = new ErrorJsonProducer(pee.getErrorKey(), pee.getParameter(), pee.getValue());
        }
        if (!warningHandler.isEmpty() && requestMap.isTrue("warnings")) {
            abstractJsonProducer.setWarningHandler(warningHandler);
        }
        return abstractJsonProducer;
    }

    private static AbstractJsonProducer getJsonProducer(BdfServer bdfServer, RequestMap requestMap, DesmodoManager desmodoManager, WarningHandler warningHandler) {
        String type = JsonProducerFactory.getMandatoryValue(requestMap, "type");
        String desmo = JsonProducerFactory.getMandatoryValue(requestMap, "desmo");
        Desmographie desmographie = JsonProducerFactory.getDesmographie(desmodoManager, desmo);
        if (desmographie == null) {
            throw new ParameterErrorException("unknownParameterValue", "desmo", desmo);
        }
        if (type.equals("ventilation")) {
            return JsonProducerFactory.getVentilationJsonProducer(requestMap, desmodoManager.getVentilationFactory(), desmographie);
        }
        if (type.equals("atlas")) {
            return JsonProducerFactory.getAtlasJsonProducer(requestMap, desmographie);
        }
        throw new ParameterErrorException("unknownParameterValue", "type", type);
    }

    private static Desmographie getDesmographie(DesmodoManager desmodoManager, String desmoString) {
        try {
            int code = Integer.parseInt(desmoString);
            return desmodoManager.getDesmographieByCode(code);
        }
        catch (NumberFormatException nfe) {
            return desmodoManager.getDesmographieByName(desmoString);
        }
    }

    private static AbstractJsonProducer getVentilationJsonProducer(RequestMap requestMap, VentilationFactory ventilationFactory, Desmographie desmographie) {
        String root = JsonProducerFactory.getMandatoryValue(requestMap, "root");
        String name = JsonProducerFactory.getMandatoryValue(requestMap, "name");
        Atlas atlas = desmographie.getAtlas();
        Term term = JsonProducerFactory.getTerm(desmographie, "root", root);
        VentilationName ventilationName = JsonProducerFactory.getVentilationName(desmographie, "name", name);
        InternalVentilationParameters ventilationParameters = new InternalVentilationParameters(atlas, term, null, JsonProducerFactory.getConf(requestMap, desmographie.getSessionConf()), ventilationName);
        Ventilation ventilation = null;
        try {
            ventilation = ventilationFactory.getVentilation(ventilationParameters);
        }
        catch (UnsupportedVentilationNameException uvne) {
            throw new ParameterErrorException("unknownParameterValue", "name", name);
        }
        catch (UnsupportedVentilationRootException uvre) {
            throw new ParameterErrorException("unexpectedParameterValue", "root", root);
        }
        double xyRatio = JsonProducerFactory.getXYRatio(requestMap);
        FaisceauAngulaire faisceau = new FaisceauAngulaire(ventilation, 0.0, Math.PI * 2);
        faisceau.redim(new CartesianPoint(0, 0), xyRatio);
        return new VentilationJsonProducer(ventilation, faisceau);
    }

    private static AbstractJsonProducer getAtlasJsonProducer(RequestMap requestMap, Desmographie desmographie) {
        Atlas atlas = desmographie.getAtlas();
        Lang[] langArray = JsonProducerFactory.getLangArray(requestMap);
        return new AtlasJsonProducer(atlas, langArray);
    }

    private static VentilationName getVentilationName(Desmographie desmographie, String parameter, String value) {
        VentilationName ventilationName;
        Atlas atlas = desmographie.getAtlas();
        if (value.equals("home")) {
            String homeVentilationNameString = desmographie.getSessionConf().getString("home.ventilationname");
            try {
                ventilationName = VentilationName.parse(homeVentilationNameString, atlas);
            }
            catch (ParseException pe) {
                throw new ParameterErrorException("wrongHomeValue", parameter, homeVentilationNameString);
            }
        }
        try {
            ventilationName = VentilationName.parse(value, atlas);
        }
        catch (ParseException pe) {
            throw new ParameterErrorException("malformedParameterValue", parameter, value);
        }
        return ventilationName;
    }

    private static Term getTerm(Desmographie desmographie, String parameter, String value) {
        Atlas atlas = desmographie.getAtlas();
        if (value.equals("home")) {
            String ventilationRootString = desmographie.getSessionConf().getString("home.ventilationroot");
            Term term = SessionUtils.getHomeTerm(ventilationRootString, atlas);
            if (term == null) {
                throw new ParameterErrorException("wrongHomeValue", parameter, ventilationRootString);
            }
            return term;
        }
        Term term = null;
        try {
            int code = Integer.parseInt(value);
            term = atlas.getTerm(code);
        }
        catch (NumberFormatException nfe) {
            try {
                UUIDURI uri = UUIDURI.parse((String)value);
                term = AtlasURI.parse(atlas, uri);
            }
            catch (ParseException pe) {
                throw new ParameterErrorException("malformedParameterValue", parameter, value);
            }
        }
        if (term == null) {
            throw new ParameterErrorException("unknownParameterValue", parameter, value);
        }
        return term;
    }

    private static String getMandatoryValue(RequestMap requestMap, String paramName) {
        String value = requestMap.getParameter(paramName);
        if (value == null) {
            throw new ParameterErrorException("missingParameter", paramName);
        }
        if (value.isEmpty()) {
            throw new ParameterErrorException("emptyParameter", paramName);
        }
        return value;
    }

    private static double getXYRatio(RequestMap requestMap) {
        String value = requestMap.getParameter("xyratio");
        if (value == null) {
            return 1.0;
        }
        if (value.isEmpty()) {
            return 1.0;
        }
        try {
            double d = Double.parseDouble(value);
            return d;
        }
        catch (NumberFormatException nfe) {
            throw new ParameterErrorException("malformedParameterValue", "xyratio");
        }
    }

    private static Lang[] getLangArray(RequestMap requestMap) {
        String param_langs = requestMap.getParameter("langlist");
        if (param_langs == null) {
            return null;
        }
        Lang[] langArray = LangsUtils.toCleanLangArray((String)param_langs);
        if (langArray.length == 0) {
            return null;
        }
        return langArray;
    }

    private static Conf getConf(RequestMap requestMap, Conf defaultConf) {
        StringMapConf stringMapConf = new StringMapConf(defaultConf);
        for (String name : requestMap.getParameterNameSet()) {
            if (!name.startsWith("conf:")) continue;
            String value = requestMap.getParameter(name);
            name = name.substring(5);
            stringMapConf.put(name, value);
        }
        return stringMapConf;
    }

    private static class InternalVentilationParameters
    implements VentilationParameters {
        private final Term ventilationRoot;
        private final Atlas atlas;
        private final LiaisonFilter liaisonFilter;
        private final Conf sessionConf;
        private final VentilationName ventilationName;

        private InternalVentilationParameters(Atlas atlas, Term ventilationRoot, LiaisonFilter liaisonFilter, Conf sessionConf, VentilationName ventilationName) {
            this.ventilationRoot = ventilationRoot;
            this.atlas = atlas;
            this.liaisonFilter = liaisonFilter;
            this.sessionConf = sessionConf;
            this.ventilationName = ventilationName;
        }

        @Override
        public Atlas getAtlas() {
            return this.atlas;
        }

        @Override
        public Term getVentilationRoot() {
            return this.ventilationRoot;
        }

        @Override
        public LiaisonFilter getLiaisonFilter() {
            return this.liaisonFilter;
        }

        @Override
        public Conf getSessionConf() {
            return this.sessionConf;
        }

        @Override
        public VentilationName getVentilationName() {
            return this.ventilationName;
        }
    }
}

