/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadQuoteException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class CSVLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int BEFORE = 1;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 3;
    public static final int AFTER = 2;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0003\u0001\u0000\u0001\u0001\u0001\u0002\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0005\t\u0000\u0001\u0004/\u0000\u0001\u0006\uffa3\u0000";
    private static final char[] ZZ_CMAP = CSVLexer.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\u0003\u0001\u0000\u0001\u0001\u0001\u0002\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0005\t\u0000\u0001\u0004/\u0000\u0001\u0006\uffa3\u0000");
    private static final int[] ZZ_ACTION = CSVLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0003\u0001\u0001\u0002\u0001\u0003\u0002\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0001\u0002\b\u0001\t\u0001\n\u0002\u0001\u0001\u000b\u0001\u0001\u0002\u0000\u0001\f\u0002\u0000\u0001\r\u0001\u0000";
    private static final int[] ZZ_ROWMAP = CSVLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0007\u0000\u000e\u0000\u0015\u0000\u001c\u0000#\u0000*\u00001\u00001\u00008\u0000?\u0000F\u0000M\u00001\u00001\u0000T\u0000[\u0000b\u00001\u0000i\u0000\u001c\u0000#\u00001\u0000p\u0000?\u00001\u0000w";
    private static final int[] ZZ_TRANS = CSVLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u0005\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u000b\u0001\u0011\u0001\u0012\u0001\u0007\u0001\b\u0001\u0013\u0002\u0011\u0001\u0014\u0001\u0004\u0001\u0007\u0001\b\u0003\u0014\u0001\u0005\u0001\u0015\u0003\u0000\u0002\u0005\u0001\u0000\u0001\u0016\u0001\u0007\u0001\b\u0006\u0000\u0001\b\n\u0000\u0005\n\u0001\u0017\u0001\u0018\u0001\u000b\u0001\u0019\u0003\u0000\u0002\u000b\u0001\u0000\u0001\f\b\u0000\u0001\u000e\u0003\u0000\u0005\u0010\u0001\u001a\u0001\u001b\u0002\u0011\u0003\u0000\u0003\u0011\u0001\u0012\u0001\u0007\u0001\b\u0001\u0000\u0002\u0011\u0002\u0014\u0002\u0000\u0003\u0014\u0007\n\u0007\u0010";
    private char[] zzcmap_instance = ZZ_CMAP;
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CSVLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0006\u0001\u0002\t\u0004\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\u0002\u0000\u0001\t\u0002\u0000\u0001\t\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private char delimiter = (char)44;
    private char quote = (char)34;
    private String escapes = "";
    private String replacements = "";
    private String commentDelims = "";
    private int addLine = 1;
    private int lines = 0;

    private static int[] zzUnpackAction() {
        int[] result = new int[27];
        int offset = 0;
        offset = CSVLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[27];
        int offset = 0;
        offset = CSVLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[126];
        int offset = 0;
        offset = CSVLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[27];
        int offset = 0;
        offset = CSVLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            String t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            CSVLexer shredder = new CSVLexer(in);
            shredder.setCommentStart("#;!");
            shredder.setEscapes("nrtf", "\n\r\t\f");
            while ((t = shredder.getNextToken()) != null) {
                System.out.println("" + shredder.getLineNumber() + " " + t);
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void ensureCharacterMapIsInstance() {
        if (ZZ_CMAP == this.zzcmap_instance) {
            this.zzcmap_instance = new char[ZZ_CMAP.length];
            System.arraycopy(ZZ_CMAP, 0, this.zzcmap_instance, 0, ZZ_CMAP.length);
        }
    }

    private boolean charIsSafe(char c) {
        return this.zzcmap_instance[c] == ZZ_CMAP[97] || this.zzcmap_instance[c] == ZZ_CMAP[9];
    }

    private void updateCharacterClasses(char oldChar, char newChar) {
        this.ensureCharacterMapIsInstance();
        this.zzcmap_instance[newChar] = this.zzcmap_instance[oldChar];
        switch (oldChar) {
            case '\"': 
            case ',': {
                this.zzcmap_instance[oldChar] = ZZ_CMAP[97];
                break;
            }
            default: {
                this.zzcmap_instance[oldChar] = ZZ_CMAP[oldChar];
            }
        }
    }

    public void changeDelimiter(char newDelim) throws BadDelimiterException {
        if (newDelim == this.delimiter) {
            return;
        }
        if (!this.charIsSafe(newDelim)) {
            throw new BadDelimiterException(newDelim + " is not a safe delimiter.");
        }
        this.updateCharacterClasses(this.delimiter, newDelim);
        this.delimiter = newDelim;
    }

    public void changeQuote(char newQuote) throws BadQuoteException {
        if (newQuote == this.quote) {
            return;
        }
        if (!this.charIsSafe(newQuote)) {
            throw new BadQuoteException(newQuote + " is not a safe quote.");
        }
        this.updateCharacterClasses(this.quote, newQuote);
        this.quote = newQuote;
    }

    public void setEscapes(String escapes, String replacements) {
        int length = escapes.length();
        if (replacements.length() < length) {
            length = replacements.length();
        }
        this.escapes = escapes.substring(0, length);
        this.replacements = replacements.substring(0, length);
    }

    private String unescape(String s) {
        if (s.indexOf(92) == -1) {
            return s.substring(1, s.length() - 1);
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                char c1;
                if ((c1 = s.charAt(++i)) == '\\' || c1 == '\"') {
                    sb.append(c1);
                    continue;
                }
                int index = this.escapes.indexOf(c1);
                if (index != -1) {
                    sb.append(this.replacements.charAt(index));
                    continue;
                }
                sb.append(c1);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setCommentStart(String commentDelims) {
        this.commentDelims = commentDelims;
    }

    public int getLineNumber() {
        return this.lines;
    }

    public CSVLexer(Reader in) {
        this.zzReader = in;
    }

    public CSVLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 30) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public String getNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = this.zzcmap_instance;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block31: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 2: {
                    this.lines += this.addLine;
                    this.addLine = 0;
                    String text = this.yytext();
                    if (this.commentDelims.indexOf(text.charAt(0)) == -1) {
                        this.yybegin(2);
                        return text;
                    }
                    this.yybegin(3);
                }
                case 14: {
                    continue block31;
                }
                case 8: {
                    ++this.addLine;
                    this.yybegin(0);
                    return "";
                }
                case 15: {
                    continue block31;
                }
                case 9: {
                    this.yybegin(1);
                    return "";
                }
                case 16: {
                    continue block31;
                }
                case 4: {
                    ++this.addLine;
                    this.yybegin(0);
                }
                case 17: {
                    continue block31;
                }
                case 5: {
                    this.lines += this.addLine;
                    this.addLine = 0;
                    this.yybegin(1);
                    return "";
                }
                case 18: {
                    continue block31;
                }
                case 12: {
                    this.lines += this.addLine;
                    this.addLine = 0;
                    this.yybegin(2);
                    return this.unescape(this.yytext());
                }
                case 19: {
                    continue block31;
                }
                case 7: {
                    this.yybegin(2);
                    return this.yytext();
                }
                case 20: {
                    continue block31;
                }
                case 6: {
                    this.lines += this.addLine;
                    this.addLine = 0;
                    this.yybegin(0);
                    return this.yytext();
                }
                case 21: {
                    continue block31;
                }
                case 11: {
                    this.yybegin(1);
                }
                case 22: {
                    continue block31;
                }
                case 13: {
                    this.yybegin(2);
                    return this.unescape(this.yytext());
                }
                case 23: {
                    continue block31;
                }
                case 10: {
                    this.yybegin(0);
                    return this.yytext();
                }
                case 24: {
                    continue block31;
                }
                case 1: 
                case 25: {
                    continue block31;
                }
                case 3: {
                    this.lines += this.addLine;
                    this.addLine = 0;
                    this.yybegin(1);
                }
                case 26: {
                    continue block31;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 1: {
                        this.yybegin(0);
                        ++this.addLine;
                        return "";
                    }
                    case 28: {
                        continue block31;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

