/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.CroisementUtils;

public class PersonneAtelierParFonctionMap {
    private final Map<String, PersonneAtelierParFonction> fonctionMap = new HashMap<String, PersonneAtelierParFonction>();
    private final Corpus personneatelierCorpus;
    private final Thesaurus fonctionThesaurus;

    public PersonneAtelierParFonctionMap(Corpus personneatelierCorpus, Thesaurus fonctionThesaurus) {
        this.personneatelierCorpus = personneatelierCorpus;
        this.fonctionThesaurus = fonctionThesaurus;
    }

    public void build(Croisements croisements) {
        Fichotheque fichotheque = this.personneatelierCorpus.getFichotheque();
        for (Croisements.Entry entry : croisements.getEntryList()) {
            FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
            Collection fonctionLiaisons = CroisementUtils.filter((Croisements)fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)this.fonctionThesaurus), (String)"");
            for (Liaison liaison : fonctionLiaisons) {
                Motcle motcle = (Motcle)liaison.getSubsetItem();
                int poids = liaison.getLien().getPoids();
                this.add(motcle, poids, ficheMeta);
            }
        }
    }

    private void add(Motcle fonction, int poids, FicheMeta personneAtelier) {
        String idalpha = fonction.getIdalpha();
        PersonneAtelierParFonction papf = this.fonctionMap.get(idalpha);
        if (papf == null) {
            papf = new PersonneAtelierParFonction(fonction);
            this.fonctionMap.put(idalpha, papf);
        }
        papf.add(poids, personneAtelier);
    }

    public Map<String, PersonneAtelierParFonction> getFonctionMap() {
        return this.fonctionMap;
    }
}

